/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.util.FileHolder;
import org.dbforms.util.Util;

public class SqlUtil {
    private static Log logCat = LogFactory.getLog((String)SqlUtil.class.getName());

    public static final void closeConnection(Connection con) {
        if (con != null) {
            try {
                logCat.debug((Object)("About to close connection - " + con));
                con.close();
                logCat.debug((Object)"Connection closed");
            }
            catch (SQLException e) {
                SqlUtil.logSqlException(e, "::closeConnection - cannot close the input connection");
            }
        }
    }

    public static final void logSqlException(SQLException e, String desc) {
        int i = 0;
        String excDesc = "::logSqlExceptionSQL - main SQL exception";
        if (!Util.isNull(desc)) {
            excDesc = excDesc + " [" + desc + "]";
        }
        logCat.error((Object)excDesc, (Throwable)e);
        while ((e = e.getNextException()) != null) {
            logCat.error((Object)("::logSqlException - nested SQLException (" + i++ + ")"), (Throwable)e);
        }
    }

    public static final void logSqlException(SQLException e) {
        SqlUtil.logSqlException(e, null);
    }

    public static FileHolder readFileHolderBlob(ResultSet rs) throws IOException, SQLException {
        logCat.info((Object)"READING FILEHOLDER");
        Object o = rs.getObject(1);
        if (o == null) {
            logCat.warn((Object)"::readDbFieldBlob - blob null, no response sent");
            return null;
        }
        logCat.info((Object)("o instanceof ..." + o.getClass().getName()));
        try {
            if (o instanceof Blob) {
                Blob blob = rs.getBlob(1);
                ObjectInputStream ois = new ObjectInputStream(blob.getBinaryStream());
                FileHolder fh = (FileHolder)ois.readObject();
                return fh;
            }
            InputStream blobIS = rs.getBinaryStream(1);
            ObjectInputStream ois = new ObjectInputStream(blobIS);
            FileHolder fh = (FileHolder)ois.readObject();
            return fh;
        }
        catch (ClassNotFoundException cnfe) {
            logCat.error((Object)"::readDbFieldBlob - class not found", (Throwable)cnfe);
            throw new IOException("error:" + cnfe.toString());
        }
    }

    public static InputStream readDbFieldBlob(ResultSet rs) throws IOException, SQLException {
        logCat.info((Object)"READING BLOB");
        Object o = rs.getObject(1);
        if (o == null) {
            logCat.warn((Object)"::readDbFieldBlob - blob null, no response sent");
            return null;
        }
        logCat.info((Object)("o instanceof ..." + o.getClass().getName()));
        if (o instanceof Blob) {
            return ((Blob)o).getBinaryStream();
        }
        return rs.getBinaryStream(1);
    }

    public static FileInputStream readDiskBlob(String fileName, String directory, String defVal) throws FileNotFoundException, IOException {
        logCat.info((Object)new StringBuffer("READING DISKBLOB\n  directory = [").append(directory).append("]\n").append("  fileName = [").append(fileName).append("]\n").append("  defaultValue = [").append(defVal).append("]\n").toString());
        if (Util.isNull(fileName) && (fileName = defVal) != null) {
            logCat.info((Object)("::readDiskBlob - database data is null; use the default value [" + fileName + "]"));
        }
        if (fileName != null) {
            File file = new File(directory, fileName = fileName.trim());
            if (file.exists()) {
                logCat.info((Object)("::readDiskBlob - file found [" + file.getAbsoluteFile() + "]"));
                return new FileInputStream(file);
            }
            logCat.error((Object)("::readDiskBlob - file [" + directory + "/" + fileName + "] not found"));
            return null;
        }
        logCat.warn((Object)"::readDiskBlob - file name or directory value is null");
        return null;
    }
}

