/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.ResultSetVector;
import org.dbforms.taglib.EmbeddedData;

public class QueryData
extends EmbeddedData
implements TryCatchFinally {
    private static Log logCat = LogFactory.getLog((String)QueryData.class.getName());
    private String query;

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.query = null;
        super.doFinally();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List fetchData(Connection con) throws SQLException {
        logCat.info((Object)("about to execute user defined query:" + this.query));
        ResultSetVector rsv = null;
        try (PreparedStatement ps = con.prepareStatement(this.query);){
            rsv = new ResultSetVector();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            DbEventInterceptorData data = new DbEventInterceptorData(request, this.getConfig(), con, null);
            data.setAttribute("pageContext", this.pageContext);
            rsv.addResultSet(data, ps.executeQuery());
        }
        return this.formatEmbeddedResultRows(rsv);
    }
}

