/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import org.dbforms.config.ResultSetVector;
import org.dbforms.taglib.DbBaseButtonTag;

public class DbNavPrevButtonTag
extends DbBaseButtonTag
implements TryCatchFinally {
    private String stepWidth;

    public void setStepWidth(String stepWidth) {
        this.stepWidth = stepWidth;
    }

    public String getStepWidth() {
        return this.stepWidth;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    @Override
    public void doFinally() {
        this.stepWidth = null;
        super.doFinally();
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        if (this.getParentForm().isFooterReached() && ResultSetVector.isNull(this.getParentForm().getResultSetVector())) {
            return 0;
        }
        boolean isFirstPage = this.getParentForm().getResultSetVector().isFirstPage();
        try {
            if (isFirstPage && "nohtml".equals(this.getDisabledBehaviour())) {
                return 0;
            }
            if (isFirstPage && "altimage".equals(this.getDisabledBehaviour())) {
                this.pageContext.getOut().write(this.getDisabledImage());
                return 0;
            }
            StringBuffer tagBuf = new StringBuffer();
            String tagName = "ac_prev_" + this.getTable().getId() + "_" + Integer.toString(DbNavPrevButtonTag.getUniqueID());
            if (this.stepWidth != null) {
                tagBuf.append(this.getDataTag(tagName, "sw", this.stepWidth));
            }
            if (this.getFollowUp() != null) {
                tagBuf.append(this.getDataTag(tagName, "fu", this.getFollowUp()));
            }
            if (this.getFollowUpOnError() != null) {
                tagBuf.append(this.getDataTag(tagName, "fue", this.getFollowUpOnError()));
            }
            tagBuf.append(this.getButtonBegin());
            if (isFirstPage) {
                tagBuf.append(" disabled=\"true\"");
            }
            tagBuf.append(" name=\"");
            tagBuf.append(tagName);
            tagBuf.append(this.getButtonEnd());
            this.pageContext.getOut().write(tagBuf.toString());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        if (this.getChoosenFlavor() == 2) {
            return 2;
        }
        return 0;
    }
}

