/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.dom.DOMFactory;
import org.dbforms.util.TimeUtil;
import org.dbforms.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.xpath.XPathEvaluator;
import org.w3c.dom.xpath.XPathNSResolver;
import org.w3c.dom.xpath.XPathResult;

public class XMLDataResult {
    private static Log logCat = LogFactory.getLog(XMLDataResult.class);
    private Element root;
    private XPathEvaluator evaluator;
    private XPathNSResolver resolver;
    private XPathResult data;
    private boolean changed = false;

    public XMLDataResult(Element root, String qry) {
        this.root = root;
        this.evaluator = DOMFactory.instance().newXPathEvaluator();
        this.resolver = this.evaluator.createNSResolver(root);
        this.data = (XPathResult)this.evaluator.evaluate(qry, this.root, this.resolver, (short)7, null);
    }

    public void setItemValue(int i, String expression, int objectType, Object value) {
    }

    public Object getItemValue(int i, String expression, int objectType) {
        Object result = null;
        try {
            XPathResult pdata;
            Node n = this.item(i);
            if (n != null && (pdata = (XPathResult)this.evaluator.evaluate(expression, n, this.resolver, (short)9, null)) != null && (n = pdata.getSingleNodeValue()) != null) {
                switch (objectType) {
                    case 1: {
                        result = this.toString(n);
                        break;
                    }
                    case 2: 
                    case 6: {
                        result = new Double(this.toString(n));
                        break;
                    }
                    case 4: {
                        result = new Integer(this.toString(n));
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        result = TimeUtil.parseISO8601Date(this.toString(n));
                        break;
                    }
                    default: {
                        result = this.toString(n);
                    }
                }
            }
        }
        catch (Exception e) {
            logCat.error((Object)"getItemValue", (Throwable)e);
        }
        return result;
    }

    public Element getRoot() {
        return this.root;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public Node item(int index) {
        Node res = null;
        if (index < this.data.getSnapshotLength()) {
            res = this.data.snapshotItem(index);
        }
        return res;
    }

    public int size() {
        int res = this.data.getSnapshotLength();
        return res;
    }

    private String toString(Node element) {
        String result = null;
        if (element != null) {
            if (element.getNodeType() == 3) {
                result = element.getNodeValue();
            } else {
                for (Node tx = element.getFirstChild(); tx != null && Util.isNull(result = this.toString(tx)); tx = tx.getNextSibling()) {
                }
            }
        }
        return result;
    }
}

