/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.classic;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValues;
import org.dbforms.event.DatabaseEvent;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class DeleteEvent
extends DatabaseEvent {
    static Log logCat = LogFactory.getLog((String)DeleteEvent.class.getName());

    public DeleteEvent(Integer tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        super(tableId, keyId, request, config);
    }

    public DeleteEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        super(StringUtil.getEmbeddedStringAsInteger(action, 2, '_'), StringUtil.getEmbeddedString(action, 3, '_'), request, config);
    }

    @Override
    public FieldValues getFieldValues() {
        return this.getFieldValues(true);
    }

    @Override
    public void processEvent(Connection con) throws SQLException {
        if (!this.hasUserPrivileg(3)) {
            String s = MessageResourcesInternal.getMessage("dbforms.events.delete.nogrant", this.getRequest().getLocale(), new String[]{this.getTable().getName()});
            throw new SQLException(s);
        }
        String keyValuesStr = this.getKeyValues();
        if (Util.isNull(keyValuesStr)) {
            logCat.error((Object)"At least one key is required per table, check your dbforms-config.xml");
            return;
        }
        FieldValues fieldValues = this.getFieldValues();
        DbEventInterceptorData interceptorData = new DbEventInterceptorData(this.getRequest(), this.getConfig(), con, this.getTable());
        interceptorData.setAttribute("fieldValues", fieldValues);
        interceptorData.setAttribute("keyValues", keyValuesStr);
        int operation = this.getTable().processInterceptors(4, interceptorData);
        if (operation == 0) {
            ResultSet diskblobs = null;
            if (this.getTable().containsDiskblob()) {
                StringBuffer queryBuf = new StringBuffer();
                queryBuf.append(this.getTable().getDisblobSelectStatement());
                queryBuf.append(" WHERE ");
                queryBuf.append(this.getTable().getWhereClauseForKeyFields());
                PreparedStatement diskblobsPs = con.prepareStatement(queryBuf.toString());
                this.getTable().populateWhereClauseWithKeyFields(keyValuesStr, diskblobsPs, 1);
                diskblobs = diskblobsPs.executeQuery();
                diskblobsPs.close();
            }
            PreparedStatement ps = con.prepareStatement(this.getTable().getDeleteStatement());
            this.getTable().populateWhereClauseWithKeyFields(keyValuesStr, ps, 1);
            ps.executeUpdate();
            ps.close();
            if (diskblobs != null && diskblobs.next()) {
                Vector diskblobFields = this.getTable().getDiskblobs();
                for (int i = 0; i < diskblobFields.size(); ++i) {
                    Field aField = (Field)diskblobFields.elementAt(i);
                    String fileName = diskblobs.getString(i + 1);
                    if (fileName == null || (fileName = fileName.trim()).length() <= 0) continue;
                    String directory = null;
                    try {
                        directory = Util.replaceRealPath(aField.getDirectory(), DbFormsConfigRegistry.instance().lookup().getRealPath());
                    }
                    catch (Exception e) {
                        throw new SQLException(e.getMessage());
                    }
                    File file = new File(directory, fileName);
                    if (file.exists()) {
                        file.delete();
                        logCat.info((Object)("deleted file " + fileName + " from dir " + directory));
                        continue;
                    }
                    logCat.info((Object)("delete of file " + fileName + " from dir " + directory + " failed because file not found"));
                }
            }
            this.getTable().processInterceptors(5, interceptorData);
        }
    }
}

