/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.EventInfo;
import org.dbforms.config.Table;
import org.dbforms.config.TableEvents;
import org.dbforms.event.EventHelper;
import org.dbforms.event.WebEvent;
import org.dbforms.event.eventtype.EventTypeUtil;
import org.dbforms.util.ReflectionUtil;
import org.dbforms.util.Util;

public abstract class EventFactory {
    private static Log logCat = LogFactory.getLog(EventFactory.class);
    static final Class[] constructorArgsTypes = new Class[]{String.class, HttpServletRequest.class, DbFormsConfig.class};
    protected HashMap eventInfoMap = new HashMap();

    protected EventFactory() {
        try {
            this.initializeEvents();
        }
        catch (Exception e) {
            logCat.error((Object)"::EventFactory - cannot initialize the factory events", (Throwable)e);
        }
    }

    public abstract WebEvent createEvent(String var1, HttpServletRequest var2, DbFormsConfig var3);

    public void addEventInfo(EventInfo einfo) {
        if (this.eventInfoMap != null) {
            EventInfo prevEinfo;
            String id = einfo.getId();
            if (this.eventInfoMap.containsKey(id) && (prevEinfo = (EventInfo)this.eventInfoMap.get(id)) != null) {
                String prevClassName = prevEinfo.getClassName();
                logCat.warn((Object)new StringBuffer("::addEventInfo - the event information having id, class [").append(id).append(", ").append(einfo.getClassName()).append("] overrides the event class [").append(prevClassName).append("]").toString());
            }
            this.eventInfoMap.put(id, einfo);
            logCat.info((Object)new StringBuffer("::addEventInfo - event info having id, type, class [").append(id).append(", ").append(einfo.getType()).append(", ").append(einfo.getClassName()).append("] registered"));
        }
    }

    protected abstract void initializeEvents() throws Exception;

    protected WebEvent getEvent(EventInfo einfo, Class[] aconstructorArgsTypes, Object[] constructorArgs) {
        WebEvent event = null;
        if (einfo != null) {
            try {
                event = (WebEvent)ReflectionUtil.newInstance(einfo.getClassName(), aconstructorArgsTypes, constructorArgs);
                event.setProperties(new Properties(einfo.getProperties()));
                event.setType(einfo.getType());
            }
            catch (Exception e) {
                logCat.error((Object)("::getEvent - cannot create the new event [" + einfo + "]"), (Throwable)e);
            }
        }
        return event;
    }

    protected String getEventIdFromDestinationTable(HttpServletRequest request, String action) {
        DbFormsConfig config = null;
        Table table = null;
        String eventId = null;
        String eventType = EventTypeUtil.getEventType(action).getEventType();
        try {
            config = DbFormsConfigRegistry.instance().lookup();
        }
        catch (Exception e) {
            logCat.error((Object)"::getEventIdFromDestinationTable - cannot get the config object from the DbFormsConfigRegistry");
        }
        if (config != null) {
            String tableName = EventHelper.getDestinationTableName(request, action);
            if (!Util.isNull(tableName)) {
                table = config.getTableByName(tableName);
            } else {
                int tableId = EventHelper.getTableId(action);
                table = config.getTable(tableId);
            }
            if (!Util.isNull(eventType)) {
                TableEvents tableEvents = table != null ? table.getTableEvents() : new TableEvents();
                eventId = tableEvents.getEventId(eventType);
            }
        }
        logCat.info((Object)("::getEventIdFromDestinationTable - eventId = [" + eventId + "]"));
        return eventId;
    }

    protected String getEventIdFromDestinationTable(Table table, String action) {
        TableEvents tableEvents = table.getTableEvents();
        String eventType = EventTypeUtil.getEventType(action).getEventType();
        String eventId = tableEvents.getEventId(eventType);
        logCat.info((Object)("::getEventIdFromDestinationTable - eventId = [" + eventId + "]"));
        return eventId;
    }

    protected EventInfo getEventInfo(String id) {
        EventInfo einfo = null;
        if (this.eventInfoMap != null && this.eventInfoMap.containsKey(id)) {
            einfo = (EventInfo)this.eventInfoMap.get(id);
        } else {
            logCat.error((Object)("::getEventInfo - event having id [" + id + "] is not registered into the factory, returning a NULL event"));
        }
        return einfo;
    }
}

