/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.EventInfo;
import org.dbforms.config.Table;
import org.dbforms.config.TableEvents;
import org.dbforms.event.DatabaseEvent;
import org.dbforms.event.DatabaseEventFactory;
import org.dbforms.event.KeyInfo;
import org.dbforms.event.NavEventFactoryImpl;
import org.dbforms.event.WebEvent;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.StringUtil;

public class DatabaseEventFactoryImpl
extends DatabaseEventFactory {
    private static final Class[] keyInfoConstructorArgsTypes = new Class[]{Integer.class, String.class, HttpServletRequest.class, DbFormsConfig.class};
    private static DatabaseEventFactory instance = null;
    private static Log logCat = LogFactory.getLog(NavEventFactoryImpl.class);

    public static synchronized DatabaseEventFactory instance() {
        if (instance == null) {
            instance = new DatabaseEventFactoryImpl();
        }
        return instance;
    }

    @Override
    public WebEvent createEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        WebEvent event = null;
        Object[] constructorArgs = null;
        String eventId = this.getEventIdFromDestinationTable(request, action);
        EventInfo einfo = this.getEventInfo(eventId);
        logCat.info((Object)("::createEvent - got event [" + einfo + "] from action [" + action + "]"));
        if (!this.isKeyInfoEvent(action)) {
            constructorArgs = new Object[]{action, request, config};
            event = this.getEvent(einfo, constructorArgsTypes, constructorArgs);
        } else {
            KeyInfo kInfo = this.getKeyInfo(action, request);
            constructorArgs = new Object[]{new Integer(kInfo.getTableId()), kInfo.getKeyId(), request, config};
            event = this.getEvent(einfo, keyInfoConstructorArgsTypes, constructorArgs);
        }
        return event;
    }

    @Override
    public DatabaseEvent createInsertEvent(int tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        DatabaseEvent event = null;
        Object[] constructorArgs = new Object[]{new Integer(tableId), keyId, request, config};
        Table table = config.getTable(tableId);
        TableEvents tableEvents = table.getTableEvents();
        String eventId = tableEvents.getEventId("insert");
        EventInfo einfo = this.getEventInfo(eventId);
        event = (DatabaseEvent)this.getEvent(einfo, keyInfoConstructorArgsTypes, constructorArgs);
        return event;
    }

    @Override
    public DatabaseEvent createUpdateEvent(int tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        DatabaseEvent event = null;
        Object[] constructorArgs = new Object[]{new Integer(tableId), keyId, request, config};
        Table table = config.getTable(tableId);
        TableEvents tableEvents = table.getTableEvents();
        String eventId = tableEvents.getEventId("update");
        EventInfo einfo = this.getEventInfo(eventId);
        event = (DatabaseEvent)this.getEvent(einfo, keyInfoConstructorArgsTypes, constructorArgs);
        return event;
    }

    @Override
    protected void initializeEvents() throws Exception {
        this.addEventInfo(new EventInfo("delete", "org.dbforms.event.datalist.DeleteEvent"));
        this.addEventInfo(new EventInfo("insert", "org.dbforms.event.datalist.InsertEvent"));
        this.addEventInfo(new EventInfo("update", "org.dbforms.event.datalist.UpdateEvent"));
    }

    private KeyInfo getKeyInfo(String action, HttpServletRequest request) {
        KeyInfo keyInfo = null;
        String associatedRadioName = ParseUtil.getParameter(request, "data" + action + "_arname");
        String keyString = ParseUtil.getParameter(request, associatedRadioName);
        if (keyString != null) {
            int tableId = StringUtil.getEmbeddedStringAsInteger(keyString, 0, '_');
            String keyId = StringUtil.getEmbeddedString(keyString, 1, '_');
            keyInfo = new KeyInfo();
            keyInfo.setTableId(tableId);
            keyInfo.setKeyId(keyId);
        }
        return keyInfo;
    }

    private boolean isKeyInfoEvent(String action) {
        boolean keyInfo = false;
        if (action.startsWith("ac_updatear_") || action.startsWith("ac_deletear_")) {
            keyInfo = true;
        }
        return keyInfo;
    }
}

