/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.devgui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditorPanel
extends JPanel
implements ActionListener,
DocumentListener {
    File file;
    JButton b_save;
    JLabel l_fileName;
    JTextArea ta_editor;
    boolean unsavedChanges = false;

    public EditorPanel() {
        this.initComponents();
        this.doLayout();
    }

    public void setFile(File aFile) {
        int result;
        if (this.unsavedChanges && (result = JOptionPane.showConfirmDialog(this, this.file.getName() + " is not saved. Want to save?", "save file?", 0)) == 0) {
            this.saveFile(this.file);
            this.unsavedChanges = false;
        }
        this.file = aFile;
        this.l_fileName.setText(this.file.getAbsolutePath());
        this.ta_editor.setText(this.readFile(this.file));
        this.ta_editor.setCaretPosition(0);
        this.ta_editor.getDocument().addDocumentListener(this);
        this.unsavedChanges = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.b_save) {
            this.saveFile(this.file);
            this.unsavedChanges = false;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.unsavedChanges = true;
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.unsavedChanges = true;
    }

    protected void showExceptionDialog(Exception e) {
        JOptionPane.showMessageDialog(this, "An exception occurred:\n\n" + e.toString() + "\n", "Exception", 0);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.l_fileName = new JLabel();
        this.add("North", this.l_fileName);
        this.ta_editor = new JTextArea();
        this.add("Center", new JScrollPane(this.ta_editor));
        JPanel panel_buttons = new JPanel();
        panel_buttons.setLayout(new BorderLayout());
        this.b_save = new JButton("Save File");
        this.b_save.addActionListener(this);
        panel_buttons.add("Center", this.b_save);
        this.add("South", panel_buttons);
    }

    private String readFile(File afile) {
        StringBuffer result = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(afile));
            String s = null;
            while ((s = reader.readLine()) != null) {
                result.append(s);
                result.append("\n");
            }
            reader.close();
        }
        catch (IOException ioe) {
            this.showExceptionDialog(ioe);
        }
        return result.toString();
    }

    private void saveFile(File afile) {
        try {
            FileWriter fw = new FileWriter(afile);
            fw.write(this.ta_editor.getText());
            fw.flush();
            fw.close();
            System.out.println("saved.");
        }
        catch (IOException ioe) {
            this.showExceptionDialog(ioe);
        }
    }
}

