/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.Field;
import org.dbforms.util.FileHolder;
import org.dbforms.util.TimeUtil;
import org.dbforms.util.UniqueIDGenerator;
import org.dbforms.util.Util;

public class FieldValue
implements Cloneable,
Serializable {
    private Field field;
    private FileHolder fileHolder;
    private Locale locale;
    private static Log logCat = LogFactory.getLog((String)FieldValue.class.getName());
    private String fieldValue;
    private String oldValue;
    private String pattern;
    private boolean logicalOR = false;
    private boolean renderHiddenHtmlTag = true;
    private int operator;
    private int searchAlgorithm;
    private int searchMode;
    private int sortDirection = -1;

    public FieldValue(Field field, String fieldValue) {
        this(field);
        this.fieldValue = fieldValue;
    }

    private FieldValue(Field field) {
        this.field = field;
    }

    public static FieldValue createFieldValueForSearching(Field field, String fieldValue, Locale locale, int operator, int searchMode, int searchAlgorithm, boolean logicalOR) {
        FieldValue fv = new FieldValue(field, fieldValue);
        fv.setLocale(locale);
        fv.setOperator(operator);
        fv.setSearchMode(searchMode);
        fv.setSearchAlgorithm(searchAlgorithm);
        fv.setLogicalOR(logicalOR);
        return fv;
    }

    public static FieldValue createFieldValueForSorting(Field field, int sortDirection) {
        FieldValue fv = new FieldValue(field);
        fv.setSortDirection(sortDirection);
        return fv;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public void setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public Object getFieldValueAsObject() {
        if (this.getField() == null) {
            return null;
        }
        return this.getFieldValueAsObject(this.getFieldValue(), this.getField().getType());
    }

    public void setFileHolder(FileHolder fileHolder) {
        this.fileHolder = fileHolder;
    }

    public FileHolder getFileHolder() {
        return this.fileHolder;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLogicalOR(boolean newLogicalOR) {
        this.logicalOR = newLogicalOR;
    }

    public boolean getLogicalOR() {
        return this.logicalOR;
    }

    public static final boolean isNull(FieldValue[] arr) {
        return arr == null || arr.length == 0;
    }

    public void setOldValue(String string) {
        this.oldValue = string;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public Object getOldValueAsObject() {
        if (this.getField() == null) {
            return null;
        }
        return this.getFieldValueAsObject(this.getOldValue(), this.getField().getType());
    }

    public void setOperator(int i) {
        this.operator = i;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setRenderHiddenHtmlTag(boolean renderHiddenHtmlTag) {
        this.renderHiddenHtmlTag = renderHiddenHtmlTag;
    }

    public boolean getRenderHiddenHtmlTag() {
        return this.renderHiddenHtmlTag;
    }

    public void setSearchAlgorithm(int searchAlgorithm) {
        this.searchAlgorithm = searchAlgorithm;
    }

    public int getSearchAlgorithm() {
        return this.searchAlgorithm;
    }

    public void setSearchMode(int searchMode) {
        this.searchMode = searchMode;
    }

    public int getSearchMode() {
        return this.searchMode;
    }

    public void setSortDirection(int sortDirection) {
        this.sortDirection = sortDirection;
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public Object clone() {
        try {
            FieldValue fv = (FieldValue)super.clone();
            return fv;
        }
        catch (CloneNotSupportedException e) {
            logCat.error((Object)"::clone - exception", (Throwable)e);
            return null;
        }
    }

    public static void invert(FieldValue[] fv) {
        block4: for (int i = 0; i < fv.length; ++i) {
            switch (fv[i].getSortDirection()) {
                case 0: {
                    fv[i].setSortDirection(1);
                    continue block4;
                }
                case 1: {
                    fv[i].setSortDirection(0);
                }
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String fieldName = this.getField().getName();
        buf.append("  ").append("field [").append(fieldName).append("] has value, oldvalue [").append(this.getFieldValue()).append(", ").append(this.getOldValue()).append("]\n");
        return buf.toString();
    }

    public static String toString(FieldValue[] fieldValues) {
        StringBuffer sb = new StringBuffer();
        sb.append("FieldValue array size: ").append(fieldValues.length).append("; elements are:\n");
        for (int i = 0; i < fieldValues.length; ++i) {
            FieldValue fieldValue = fieldValues[i];
            sb.append(fieldValue.toString());
        }
        return sb.toString();
    }

    private Object getFieldValueAsObject(String value, int fieldType) {
        Object res = null;
        switch (fieldType) {
            case 4: {
                res = this.parseINTEGER(value);
                break;
            }
            case 8: {
                res = this.parseDOUBLE(value);
                break;
            }
            case 6: {
                res = this.parseFLOAT(value);
                break;
            }
            case 2: {
                res = this.parseNUMERIC(value);
                break;
            }
            case 1: {
                res = this.parseCHAR(value);
                break;
            }
            case 91: {
                res = this.parseDATE(value);
                break;
            }
            case 92: {
                res = this.parseTIME(value);
                break;
            }
            case 93: {
                res = this.parseTIMESTAMP(value);
                break;
            }
            case 2004: {
                if (this.getFileHolder() == null) {
                    res = value;
                    break;
                }
                res = this.getFileHolder();
                break;
            }
            case 4200: {
                res = this.parseDISKBLOB();
                break;
            }
        }
        return res;
    }

    private String parseCHAR(String value) {
        String res = "[NULL]".equals(value) ? null : value;
        return res;
    }

    private Date parseDATE(String value) {
        String valueStr = value.trim();
        if (Util.isNull(valueStr)) {
            return null;
        }
        if (this.getLocale() != null) {
            try {
                SimpleDateFormat f = (SimpleDateFormat)this.getField().getFormat(this.getPattern(), this.getLocale());
                Calendar result = TimeUtil.parseDate(f, valueStr);
                result.set(11, 0);
                result.set(12, 0);
                result.set(13, 0);
                return new Date(result.getTime().getTime());
            }
            catch (Exception e) {
                logCat.error((Object)(e.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
                try {
                    SimpleDateFormat f = (SimpleDateFormat)this.getField().getFormat("short", this.getLocale());
                    Calendar result = TimeUtil.parseDate(f, valueStr);
                    result.set(11, 0);
                    result.set(12, 0);
                    result.set(13, 0);
                    return new Date(result.getTime().getTime());
                }
                catch (Exception ex) {
                    logCat.error((Object)(ex.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
                }
            }
        }
        try {
            String[] vStr = StringUtils.split((String)valueStr, (String)" ");
            String str = vStr[0];
            return Date.valueOf(str);
        }
        catch (Exception e) {
            logCat.error((Object)(e.getMessage() + " <" + valueStr + ">"));
            return null;
        }
    }

    private String parseDISKBLOB() {
        if (this.getField().hasEncodedSet()) {
            String fileName = this.getFileHolder().getFileName();
            int dotIndex = fileName.lastIndexOf(46);
            String suffix = dotIndex != -1 ? fileName.substring(dotIndex) : "";
            this.fileHolder.setFileName(UniqueIDGenerator.getUniqueID() + suffix);
        }
        return this.fileHolder.getFileName();
    }

    private Double parseDOUBLE(String value) {
        String valueStr = value.trim();
        if (Util.isNull(valueStr)) {
            return null;
        }
        if (this.getLocale() != null) {
            try {
                DecimalFormat f = (DecimalFormat)this.getField().getFormat(this.getPattern(), this.getLocale());
                return new Double(f.parse(valueStr).doubleValue());
            }
            catch (Exception e) {
                logCat.error((Object)(e.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
            }
        }
        try {
            return new Double(valueStr);
        }
        catch (Exception e) {
            logCat.error((Object)(e.getMessage() + " <" + valueStr + ">"));
            return null;
        }
    }

    private Float parseFLOAT(String value) {
        String valueStr = value.trim();
        if (Util.isNull(valueStr)) {
            return null;
        }
        if (this.getLocale() != null) {
            try {
                DecimalFormat f = (DecimalFormat)this.getField().getFormat(this.getPattern(), this.getLocale());
                return new Float(f.parse(valueStr).floatValue());
            }
            catch (Exception e) {
                logCat.error((Object)(e.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
            }
        }
        try {
            return new Float(valueStr);
        }
        catch (Exception e) {
            logCat.error((Object)(e.getMessage() + " <" + valueStr + ">"));
            return null;
        }
    }

    private Integer parseINTEGER(String value) {
        String valueStr = value.trim();
        if (Util.isNull(valueStr)) {
            return null;
        }
        if (this.getLocale() != null) {
            try {
                DecimalFormat f = (DecimalFormat)this.getField().getFormat(this.getPattern(), this.getLocale());
                return new Integer(f.parse(valueStr).intValue());
            }
            catch (Exception e) {
                logCat.error((Object)(e.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
            }
        }
        try {
            return new Integer(valueStr);
        }
        catch (Exception e) {
            logCat.error((Object)(e.getMessage() + " <" + valueStr + ">"));
            return null;
        }
    }

    private BigDecimal parseNUMERIC(String value) {
        String valueStr = value.trim();
        if (Util.isNull(valueStr)) {
            return null;
        }
        if (this.getLocale() != null) {
            try {
                DecimalFormat f = (DecimalFormat)this.getField().getFormat(this.getPattern(), this.getLocale());
                return new BigDecimal(f.parse(valueStr).doubleValue());
            }
            catch (Exception e) {
                logCat.error((Object)(e.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
            }
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            logCat.error((Object)(e.getMessage() + " <" + valueStr + ">"));
            return null;
        }
    }

    private Time parseTIME(String value) {
        String valueStr = value.trim();
        if (Util.isNull(valueStr)) {
            return null;
        }
        if (this.getLocale() != null) {
            try {
                SimpleDateFormat f = (SimpleDateFormat)this.getField().getFormat(this.getPattern(), this.getLocale());
                Calendar result = TimeUtil.parseDate(f, valueStr);
                result.set(5, 0);
                result.set(2, 0);
                result.set(1, 0);
                return new Time(result.getTime().getTime());
            }
            catch (Exception e) {
                logCat.error((Object)(e.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
                try {
                    SimpleDateFormat f = (SimpleDateFormat)this.getField().getFormat("short", this.getLocale());
                    Calendar result = TimeUtil.parseDate(f, valueStr);
                    result.set(5, 0);
                    result.set(2, 0);
                    result.set(1, 0);
                    return new Time(result.getTime().getTime());
                }
                catch (Exception ex) {
                    logCat.error((Object)(ex.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
                }
            }
        }
        try {
            return Time.valueOf(valueStr);
        }
        catch (Exception e) {
            logCat.error((Object)(e.getMessage() + " <" + valueStr + ">"));
            return null;
        }
    }

    private Timestamp parseTIMESTAMP(String value) {
        String valueStr = value.trim();
        if (Util.isNull(valueStr)) {
            return null;
        }
        if (this.getLocale() != null) {
            try {
                SimpleDateFormat f = (SimpleDateFormat)this.getField().getFormat(this.getPattern(), this.getLocale());
                Calendar result = TimeUtil.parseDate(f, valueStr);
                return new Timestamp(result.getTime().getTime());
            }
            catch (Exception e) {
                logCat.error((Object)(e.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
                try {
                    SimpleDateFormat f = (SimpleDateFormat)this.getField().getFormat("short", this.getLocale());
                    Calendar result = TimeUtil.parseDate(f, valueStr);
                    return new Timestamp(result.getTime().getTime());
                }
                catch (Exception ex) {
                    logCat.error((Object)(ex.getMessage() + " <" + valueStr + "/" + this.getPattern() + ">"));
                }
            }
        }
        try {
            return Timestamp.valueOf(valueStr);
        }
        catch (Exception e) {
            logCat.error((Object)(e.getMessage() + " <" + valueStr + ">"));
            return null;
        }
    }
}

