/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource.util;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.TransferProtocolException;
import de.destatis.core.connect.survey.EidResourceId;
import de.destatis.core.connect.survey.EidResourceIdWithVersion;
import de.destatis.core.connect.survey.Survey;
import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.connect.util.Contract;
import de.destatis.core.resource.DatmlSdfSource;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.Resource;
import de.destatis.core.resource.ResourceConfig;
import de.destatis.core.resource.ResourceStorage;
import de.destatis.core.resource.ResourceStorageException;
import de.destatis.core.resource.ResourceType;
import de.destatis.core.resource.SDFMetaResource;
import de.destatis.core.resource.util.AbstractGetSurveyResourceQuery;
import de.destatis.core.resource.util.CommonResourceId;
import de.destatis.core.resource.util.DatMlRawVersion;
import de.destatis.core.resource.util.GetResourceQuery;
import de.destatis.core.resource.util.GetSDFMetaResourceQuery;
import de.destatis.core.resource.util.GetSurveyResourceQuery;
import de.destatis.core.resource.util.ResourceResponse;
import de.destatis.core.resource.util.ResponseStatusException;
import de.destatis.core.resource.util.SimpleLRUCache;
import java.io.Reader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ResourceManager {
    private static final long DEFAULT_CHECK_FOR_NEW_UPDATES_PERIOD_MINUTES = 1440L;
    private static final ClientLogger LOG = ClientLogger.getLogger(ResourceManager.class);
    private long checkForNewUpdatesPeriodMinutes = 1440L;
    private ResourceConfig resourceConfig;
    private Map allLocalResourceIdsCache;
    private Map resourceQueryCache;
    private Map resourceCache;

    public ResourceManager(ResourceConfig resourceConfig) {
        this(resourceConfig, 20, 10);
    }

    public ResourceManager(ResourceConfig resourceConfig, int maxQueryCacheSize, int maxResourceCacheSize) {
        Contract.verify(resourceConfig != null, "ResourceConfig ist erforderlich");
        this.resourceConfig = resourceConfig;
        this.allLocalResourceIdsCache = new HashMap();
        this.resourceQueryCache = new SimpleLRUCache(maxQueryCacheSize);
        this.resourceCache = new SimpleLRUCache(maxResourceCacheSize);
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public void reset() {
        this.allLocalResourceIdsCache.clear();
        this.resourceQueryCache.clear();
        this.resourceCache.clear();
    }

    public DatmlSdfSource getSdfResource(String statId, String reportingPeriod, String collector) throws NoResourceFoundException, ResourceStorageException, TransferProtocolException, ResponseStatusException {
        return this.getSdfResource(statId, reportingPeriod, collector, this.resourceConfig.isSurveyAutoUpdate(), null);
    }

    public DatmlSdfSource getSdfResource(String statId, String reportingPeriod, String collector, boolean autoUpdate, Client client) throws NoResourceFoundException, ResourceStorageException, TransferProtocolException, ResponseStatusException {
        GetSurveyResourceQuery query = new GetSurveyResourceQuery(ResourceType.TYPE_DATML_SDF, statId, reportingPeriod, collector);
        DatmlSdfSource resource = (DatmlSdfSource)this.getResource(query, this.resourceConfig.getSurveyResourceStorage(), autoUpdate, client);
        return resource;
    }

    public List getLocalSurveys() throws ResourceStorageException {
        List sdfResourceIds = this.getAllResourceIds(ResourceType.TYPE_DATML_SDF, this.resourceConfig.getSurveyResourceStorage());
        Iterator it = sdfResourceIds.iterator();
        HashMap<String, String> maxVersions = new HashMap<String, String>();
        while (it.hasNext()) {
            String resourceId = (String)it.next();
            String preVersionPart = EidResourceId.getStaticPart(resourceId);
            String version = EidResourceIdWithVersion.getVersion(resourceId);
            String currentMaxVersion = (String)maxVersions.get(preVersionPart);
            String maxVersion = currentMaxVersion == null ? version : (Integer.parseInt(version) > Integer.parseInt(currentMaxVersion) ? version : currentMaxVersion);
            maxVersions.put(preVersionPart, maxVersion);
        }
        ArrayList<Survey> surveys = new ArrayList<Survey>(maxVersions.size());
        for (Map.Entry entry : maxVersions.entrySet()) {
            String preVersionPart = (String)entry.getKey();
            String version = (String)entry.getValue();
            String resourceId = preVersionPart + version;
            String erhebungsId = EidResourceId.getErhebungsId(resourceId);
            String description = null;
            try {
                DatmlSdfSource resource = (DatmlSdfSource)this.doGetResource(new GetSurveyResourceByResourceIdQuery(resourceId), this.resourceConfig.getSurveyResourceStorage(), false, null);
                GetSurveyDescriptionParser parser = new GetSurveyDescriptionParser();
                parser.parse(resource.getReader());
                String name = parser.getSurveyName();
                String label = parser.getSurveyLabel();
                description = label != null && label.length() > 0 ? label : name;
            }
            catch (Exception e) {
                e.printStackTrace();
                description = "* Fehler: " + e.getMessage() + " *";
            }
            Survey survey = new Survey(erhebungsId, description, null);
            surveys.add(survey);
        }
        final Collator collator = Collator.getInstance(Locale.GERMAN);
        Collections.sort(surveys, new Comparator(){

            public int compare(Object o1, Object o2) {
                Survey s1 = (Survey)o1;
                Survey s2 = (Survey)o2;
                return collator.compare(s1.getErhebungsId().getErhebungsId(), s2.getErhebungsId().getErhebungsId());
            }
        });
        return surveys;
    }

    public SDFMetaResource getSdfMetaResource(String datMlRawVersion) throws NoResourceFoundException, ResourceStorageException, TransferProtocolException, ResponseStatusException {
        return this.getSdfMetaResource(datMlRawVersion, this.resourceConfig.isSdfMetaAutoUpdate(), null);
    }

    public SDFMetaResource getSdfMetaResource(String datMlRawVersion, boolean autoUpdate, Client client) throws NoResourceFoundException, ResourceStorageException, TransferProtocolException, ResponseStatusException {
        GetSDFMetaResourceQuery query = new GetSDFMetaResourceQuery(datMlRawVersion);
        SDFMetaResource resource = (SDFMetaResource)this.getResource(query, this.resourceConfig.getSdfMetaResourceStorage(), autoUpdate, client);
        return resource;
    }

    public List getLocalDatMlRawVersions() throws ResourceStorageException {
        List sdfMetaResourceIds = this.getAllResourceIds(ResourceType.TYPE_SDFMETA, this.resourceConfig.getSdfMetaResourceStorage());
        Iterator it = sdfMetaResourceIds.iterator();
        HashSet<DatMlRawVersion> datMlRawVersions = new HashSet<DatMlRawVersion>();
        while (it.hasNext()) {
            String resourceId = (String)it.next();
            String datMlRawVersionPart = CommonResourceId.getDatMlRawVersion(resourceId);
            String prettyDatMlRawVersion = DatMlRawVersion.getPrettyDatMlRawVersionFromDatMlRawVerson(datMlRawVersionPart);
            DatMlRawVersion datMlRawVersion = new DatMlRawVersion(prettyDatMlRawVersion);
            if (datMlRawVersions.contains(datMlRawVersion)) continue;
            datMlRawVersions.add(datMlRawVersion);
        }
        ArrayList<DatMlRawVersion> result = new ArrayList<DatMlRawVersion>(datMlRawVersions.size());
        result.addAll(datMlRawVersions);
        Collections.sort(result);
        return result;
    }

    private Resource getResource(GetResourceQuery query, ResourceStorage resourceStorage, boolean autoUpdate, Client client) throws NoResourceFoundException, ResourceStorageException, TransferProtocolException, ResponseStatusException {
        Object queryRes;
        Object queryKey = query.getQueryKey();
        if (queryKey != null && (queryRes = this.resourceQueryCache.get(queryKey)) != null) {
            if (queryRes instanceof Integer) {
                throw new NoResourceFoundException((Integer)queryRes);
            }
            if (queryRes instanceof Resource) {
                return (Resource)queryRes;
            }
        }
        try {
            Resource resource = this.doGetResource(query, resourceStorage, autoUpdate, client);
            if (queryKey != null) {
                this.resourceQueryCache.put(queryKey, resource);
            }
            return resource;
        }
        catch (NoResourceFoundException e) {
            if (queryKey != null) {
                this.resourceQueryCache.put(queryKey, new Integer(e.getReason()));
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Resource doGetResource(GetResourceQuery query, ResourceStorage resourceStorage, boolean autoUpdate, Client clientParam) throws NoResourceFoundException, ResourceStorageException, TransferProtocolException, ResponseStatusException {
        byte[] resourceData;
        Resource resource;
        String resourceId;
        block28: {
            Client client;
            block27: {
                client = clientParam;
                if (client == null) {
                    client = this.resourceConfig.getClient();
                }
                if (autoUpdate && client == null) {
                    throw new IllegalStateException("Bei aktiviertem Autoupdate muss ein Client zum Herunterladen der Ressourcen vom CORE.server angegeben werden.");
                }
                List allResourceIds = this.getAllResourceIds(query.getResourceType(), resourceStorage);
                resourceId = null;
                try {
                    resourceId = query.getResourceId(allResourceIds);
                    Contract.verify(resourceId != null, "ResourceId darf nicht null sein");
                }
                catch (NoResourceFoundException e) {
                    if (autoUpdate) break block27;
                    throw e;
                }
            }
            String localResourceId = resourceId;
            resource = null;
            resourceData = null;
            if (resourceId == null) {
                ResourceResponse response = query.downloadRessource(client, null);
                ResponseStatus resStatus = response.getStatus();
                if (resStatus == ResponseStatus.OK) {
                    resourceId = response.getResourceId();
                    resourceData = response.getResourceData();
                    resourceStorage.saveResource(resourceId, resourceData);
                    this.clearAllLocalResourceIds(query.getResourceType());
                    break block28;
                } else {
                    if (resStatus == ResponseStatus.NO_RESOURCE_FOR_STAT_ID) {
                        throw new NoResourceFoundException(1);
                    }
                    if (resStatus == ResponseStatus.NO_RESOURCE_FOR_REPORTING_PERIOD_TYPE) {
                        throw new NoResourceFoundException(2);
                    }
                    if (resStatus == ResponseStatus.NO_RESOURCE_FOR_REPORTING_PERIOD) {
                        throw new NoResourceFoundException(3);
                    }
                    if (resStatus == ResponseStatus.NO_RESOURCE_FOR_COLLECTOR) {
                        throw new NoResourceFoundException(4);
                    }
                    if (resStatus == ResponseStatus.RESOURCE_NOT_AVAILABLE) {
                        throw new NoResourceFoundException(0);
                    }
                    StringBuffer msg = new StringBuffer("Es ist ein Fehler beim Herunterladen einer Ressource aufgetreten:");
                    msg.append(" Unzul\u00e4ssiger ResponseStatus: " + resStatus.toString());
                    String errorMsg = response.getErrorText();
                    if (errorMsg != null && errorMsg.length() > 0) {
                        msg.append(", Fehler: " + errorMsg);
                    }
                    throw new ResponseStatusException(resStatus, errorMsg, msg.toString());
                }
            }
            boolean updateResource = false;
            Date currentTime = new Date();
            if (autoUpdate) {
                Date lastUpdateCheck = resourceStorage.getLastUpdateCheck(localResourceId);
                if (lastUpdateCheck == null) {
                    updateResource = true;
                } else {
                    long checkTime = lastUpdateCheck.getTime() + this.checkForNewUpdatesPeriodMinutes * 60L * 1000L;
                    if (currentTime.getTime() >= checkTime) {
                        updateResource = true;
                    }
                }
            }
            if (updateResource) {
                ResourceResponse response = query.downloadRessource(client, localResourceId);
                ResponseStatus resStatus = response.getStatus();
                if (resStatus == ResponseStatus.OK) {
                    String tempResourceId = response.getResourceId();
                    byte[] tempResourceData = response.getResourceData();
                    resourceStorage.saveResource(tempResourceId, tempResourceData);
                    this.clearAllLocalResourceIds(query.getResourceType());
                    resourceId = tempResourceId;
                    resourceData = tempResourceData;
                } else if (resStatus == ResponseStatus.RESOURCE_UPTODATE) {
                    LOG.info("Ressource '" + localResourceId + "' ist aktuell.");
                    resourceStorage.setLastUpdateCheck(localResourceId, currentTime);
                } else if (resStatus == ResponseStatus.RESOURCE_NOT_AVAILABLE || resStatus == ResponseStatus.NO_RESOURCE_FOR_STAT_ID || resStatus == ResponseStatus.NO_RESOURCE_FOR_REPORTING_PERIOD_TYPE || resStatus == ResponseStatus.NO_RESOURCE_FOR_REPORTING_PERIOD || resStatus == ResponseStatus.NO_RESOURCE_FOR_COLLECTOR) {
                    LOG.error("Es ist keine entsprechende Ressource auf dem Server vorhanden. Es wird die lokale Ressource '" + localResourceId + "' verwendet.");
                } else {
                    StringBuffer msg = new StringBuffer("Es ist ein Fehler beim Herunterladen einer Ressource aufgetreten:");
                    msg.append(" Unzul\u00e4ssiger ResponseStatus: " + resStatus.toString());
                    String errorMsg = response.getErrorText();
                    if (errorMsg != null && errorMsg.length() > 0) {
                        msg.append(", Fehler: " + errorMsg);
                    }
                    throw new ResponseStatusException(resStatus, errorMsg, msg.toString());
                }
            }
            if (resourceData == null && (resource = (Resource)this.resourceCache.get(resourceId)) == null) {
                resourceData = resourceStorage.getResource(resourceId);
            }
        }
        if (resource == null) {
            resource = query.createResource(resourceId, resourceData);
        }
        this.resourceCache.put(resourceId, resource);
        return resource;
    }

    private List getAllResourceIds(ResourceType type, ResourceStorage storage) throws ResourceStorageException {
        List resourceIdList = null;
        resourceIdList = (List)this.allLocalResourceIdsCache.get(type);
        if (resourceIdList == null) {
            resourceIdList = storage.getResourceIds();
            this.allLocalResourceIdsCache.put(type, resourceIdList);
        }
        return resourceIdList;
    }

    private void clearAllLocalResourceIds(ResourceType type) {
        this.allLocalResourceIdsCache.remove(type);
    }

    private static class GetSurveyResourceByResourceIdQuery
    extends AbstractGetSurveyResourceQuery {
        private String resourceId;

        public GetSurveyResourceByResourceIdQuery(String resourceId) {
            super(ResourceType.TYPE_DATML_SDF);
            this.resourceId = resourceId;
        }

        @Override
        public Object getQueryKey() {
            return null;
        }

        @Override
        public String getResourceId(List allResourceIds) throws NoResourceFoundException {
            return this.resourceId;
        }

        @Override
        public ResourceResponse downloadRessource(Client client, String localResourceId) throws TransferProtocolException {
            throw new UnsupportedOperationException("downloadRessource()");
        }
    }

    private static class ParsingFinishedException
    extends SAXException {
        public ParsingFinishedException() {
            super("Finished");
        }
    }

    private class GetSurveyDescriptionParser
    extends DefaultHandler {
        private boolean inSurvey = false;
        private StringBuffer buffer;
        private String surveyName;
        private String surveyLabel;

        private GetSurveyDescriptionParser() {
        }

        public void parse(Reader reader) throws Exception {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            try {
                xmlReader.parse(new InputSource(reader));
            }
            catch (ParsingFinishedException parsingFinishedException) {
                // empty catch block
            }
        }

        public String getSurveyName() {
            return this.surveyName;
        }

        public String getSurveyLabel() {
            return this.surveyLabel;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("survey".equalsIgnoreCase(localName)) {
                this.inSurvey = true;
            } else if (this.inSurvey) {
                if ("surveyName".equalsIgnoreCase(localName)) {
                    this.buffer = new StringBuffer();
                } else if ("surveyLabel".equalsIgnoreCase(localName)) {
                    this.buffer = new StringBuffer();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("survey".equalsIgnoreCase(localName)) {
                throw new ParsingFinishedException();
            }
            if (this.inSurvey) {
                if ("surveyName".equalsIgnoreCase(localName)) {
                    this.surveyName = this.buffer.toString();
                    this.buffer = null;
                } else if ("surveyLabel".equalsIgnoreCase(localName)) {
                    this.surveyLabel = this.buffer.toString();
                    this.buffer = null;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(ch, start, length);
            }
        }
    }
}

