/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource.util;

import de.destatis.core.connect.Client;
import de.destatis.core.connect.GetSurveyDefinitionResourceRequest;
import de.destatis.core.connect.IncompleteRequestException;
import de.destatis.core.connect.ResponseToGetResourceRequest;
import de.destatis.core.connect.TransferProtocolException;
import de.destatis.core.connect.UnsupportedProtocolException;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.ResourceType;
import de.destatis.core.resource.util.AbstractGetSurveyResourceQuery;
import de.destatis.core.resource.util.ResourceResponse;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;

public class GetSurveyResourceQuery
extends AbstractGetSurveyResourceQuery {
    private String statId;
    private String reportingPeriod;
    private String collector;
    private Integer hashCode;

    public GetSurveyResourceQuery(ResourceType type, String statId, String reportingPeriod, String collector) {
        super(type);
        this.statId = statId;
        this.reportingPeriod = reportingPeriod;
        this.collector = collector;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj != null && GetSurveyResourceQuery.class.equals(obj.getClass())) {
            GetSurveyResourceQuery other = (GetSurveyResourceQuery)obj;
            if (this.type.equals(other.type) && this.statId.equals(other.statId) && this.reportingPeriod.equals(other.reportingPeriod) && this.collector.equals(other.collector)) {
                equals = true;
            }
        }
        return equals;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            StringBuffer hash = new StringBuffer();
            hash.append(this.type.getTypeId());
            hash.append(this.statId);
            hash.append(this.reportingPeriod);
            hash.append(this.collector);
            this.hashCode = new Integer(hash.toString().hashCode());
        }
        return this.hashCode;
    }

    @Override
    public Object getQueryKey() {
        return this;
    }

    @Override
    public String getResourceId(List allResourceIds) throws NoResourceFoundException {
        return this.getCurrentResourceId(this.statId, this.reportingPeriod, this.collector, allResourceIds);
    }

    @Override
    public ResourceResponse downloadRessource(Client client, String localResourceId) throws TransferProtocolException {
        ResponseToGetResourceRequest response;
        GetSurveyDefinitionResourceRequest request = null;
        if (!ResourceType.TYPE_DATML_SDF.equals(this.type)) {
            throw new IllegalArgumentException("Nicht unterst\u00fctzter Typ '" + this.type + "'.");
        }
        request = new GetSurveyDefinitionResourceRequest(this.statId, this.collector, this.reportingPeriod, localResourceId);
        try {
            response = client.send(request);
        }
        catch (IncompleteRequestException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedProtocolException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    private String getCurrentResourceId(String statId, String reportingPeriod, String collector, List allResourceIds) throws NoResourceFoundException {
        int noResourceFoundReason = 0;
        String resourceId = null;
        List resourceIds = this.listAllResourceIdsWithType(allResourceIds);
        if (resourceIds != null) {
            if ((resourceIds = this.listCurrentStatIdResourceIds(resourceIds, statId)) != null) {
                if ((resourceIds = this.listCurrentTypeOfReportingPeriodResourceIds(resourceIds, reportingPeriod)) != null) {
                    if ((resourceIds = this.listCurrentReportingPeriodResourceIds(resourceIds, reportingPeriod)) != null) {
                        if ((resourceIds = this.listCurrentCollectorResourceIds(resourceIds, collector)) != null) {
                            resourceId = this.selectCurrentRessourceId(resourceIds);
                        } else {
                            noResourceFoundReason = 4;
                        }
                    } else {
                        noResourceFoundReason = 3;
                    }
                } else {
                    noResourceFoundReason = 2;
                }
            } else {
                noResourceFoundReason = 1;
            }
        }
        if (resourceId == null) {
            throw new NoResourceFoundException(noResourceFoundReason);
        }
        return resourceId;
    }

    private List listAllResourceIdsWithType(List allResourceIds) {
        Vector<String> allResourceIdsWithType = new Vector<String>();
        for (String resourceId : allResourceIds) {
            Matcher m;
            if (resourceId.length() != 21 || !this.isNumeric(resourceId) || !(m = this.resourceTypePattern.matcher(resourceId.substring(13, 17))).matches()) continue;
            allResourceIdsWithType.add(resourceId);
        }
        if (allResourceIdsWithType.isEmpty()) {
            return null;
        }
        return allResourceIdsWithType;
    }

    private List listCurrentStatIdResourceIds(List resourceIds, String statId) {
        Vector<String> currentStatIdResourceIds = new Vector<String>();
        if (statId.length() == 4) {
            for (String resourceId : resourceIds) {
                if (!resourceId.regionMatches(1, statId, 0, statId.length())) continue;
                currentStatIdResourceIds.add(resourceId);
            }
        }
        if (currentStatIdResourceIds.isEmpty()) {
            return null;
        }
        return currentStatIdResourceIds;
    }

    private List listCurrentTypeOfReportingPeriodResourceIds(List resourceIds, String reportingPeriod) {
        Vector<String> currentTypeOfReportingPeriodResourceIds = new Vector<String>();
        for (String resourceId : resourceIds) {
            if (resourceId.charAt(7) != reportingPeriod.charAt(2)) continue;
            currentTypeOfReportingPeriodResourceIds.add(resourceId);
        }
        if (currentTypeOfReportingPeriodResourceIds.isEmpty()) {
            return null;
        }
        return currentTypeOfReportingPeriodResourceIds;
    }

    private List listCurrentReportingPeriodResourceIds(List resourceIds, String reportingPeriod) {
        Vector<String> currentReportingPeriodResourceIds = new Vector<String>();
        int currentPeriodInt = Integer.parseInt(reportingPeriod);
        int lastPeriodInt = 0;
        for (String resourceId : resourceIds) {
            int periodInt = Integer.parseInt(resourceId.substring(5, 11));
            if (periodInt > currentPeriodInt) continue;
            if (periodInt > lastPeriodInt) {
                lastPeriodInt = periodInt;
                currentReportingPeriodResourceIds.clear();
                currentReportingPeriodResourceIds.add(resourceId);
                continue;
            }
            if (periodInt != lastPeriodInt) continue;
            currentReportingPeriodResourceIds.add(resourceId);
        }
        if (currentReportingPeriodResourceIds.isEmpty()) {
            return null;
        }
        return currentReportingPeriodResourceIds;
    }

    private List listCurrentCollectorResourceIds(List resourceIds, String collector) {
        Vector<String> currentReporterResourceIds = new Vector<String>();
        for (String resourceId : resourceIds) {
            if (!resourceId.substring(11, 13).equals(collector)) continue;
            currentReporterResourceIds.add(resourceId);
        }
        if (currentReporterResourceIds.isEmpty() && !"99".equals(collector)) {
            for (String resourceId : resourceIds) {
                if (!resourceId.substring(11, 13).equals("99")) continue;
                currentReporterResourceIds.add(resourceId);
            }
        }
        if (currentReporterResourceIds.isEmpty()) {
            return null;
        }
        return currentReporterResourceIds;
    }

    private String selectCurrentRessourceId(List resourceIds) {
        Iterator it = resourceIds.iterator();
        String curentVersionResourceId = (String)it.next();
        while (it.hasNext()) {
            String resourceId = (String)it.next();
            if (Integer.parseInt(resourceId.substring(17, 21)) <= Integer.parseInt(curentVersionResourceId.substring(17, 21))) continue;
            curentVersionResourceId = resourceId;
        }
        return curentVersionResourceId;
    }

    private boolean isNumeric(String string) {
        boolean numeric;
        if (string != null && string.length() > 0) {
            numeric = true;
            char[] chars = string.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) continue;
                numeric = false;
                break;
            }
        } else {
            numeric = false;
        }
        return numeric;
    }
}

