/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer;

import de.destatis.core.connect.IncompleteRequestException;
import de.destatis.core.resource.util.DatMlRawVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoreCommunicationInterface {
    private static final int MAX_PARAM_LENGTH_DEFAULT = 32;
    private static final int PARAM_LENGTH_COLLECTOR = 2;
    private static final int PARAM_LENGTH_STATISTIC_ID = 4;
    private static final int PARAM_LENGTH_REFERENCE_PERIOD = 6;

    public static void checkEntryStamp(String entryStamp) throws IncompleteRequestException {
        String message = null;
        if (entryStamp == null || entryStamp.length() == 0) {
            message = "Kein Eingangsstempel angegeben!";
        }
        if (message != null) {
            throw new IncompleteRequestException(message);
        }
    }

    public static void checkDatMLRESVersion(String resVersion) throws IncompleteRequestException {
        Pattern p;
        Matcher m;
        if (resVersion != null && resVersion.length() > 0 && !(m = (p = Pattern.compile("^\\d?\\d\\.\\d$")).matcher(resVersion)).matches()) {
            throw new IncompleteRequestException("Ungueltige DatML/RES-Versionsangabe (" + resVersion + ")!");
        }
    }

    public static void checkSurveyID(String surveyID) throws IncompleteRequestException {
        String message = null;
        if (surveyID == null || surveyID.length() == 0) {
            message = "Keine Erhebungs-ID angegeben!";
        } else if (surveyID.length() > 32) {
            message = "Angegebene Erhebungs-ID ist ungueltig (" + surveyID + ")!";
        }
        if (message != null) {
            throw new IncompleteRequestException(message);
        }
    }

    public static void checkStatisticID(String statisticID) throws IncompleteRequestException {
        String message = null;
        if (statisticID == null || statisticID.length() == 0) {
            message = "Keine Statistik-ID angegeben!";
        } else if (statisticID.length() != 4) {
            message = "Angegebene Statistik-ID ist ungueltig (" + statisticID + ")!";
        }
        if (message != null) {
            throw new IncompleteRequestException(message);
        }
    }

    public static void checkReferencePeriod(String referencePeriod) throws IncompleteRequestException {
        String message = null;
        if (referencePeriod == null || referencePeriod.length() == 0) {
            message = "Kein Berichtszeitraum angegeben!";
        } else if (referencePeriod.length() != 6) {
            message = "Angegebener Berichtszeitraum ungueltig (" + referencePeriod + ")!";
        }
        if (message != null) {
            throw new IncompleteRequestException(message);
        }
    }

    public static void checkCollector(String collector) throws IncompleteRequestException {
        String message = null;
        if (collector == null || collector.length() == 0) {
            message = "Kein Berichtsempfaenger angegeben!";
        } else if (collector.length() != 2) {
            message = "Angegebener Berichtsempfaenger ungueltig (" + collector + ")!";
        }
        if (message != null) {
            throw new IncompleteRequestException(message);
        }
    }

    public static void checkResourceID(String resourceID) throws IncompleteRequestException {
        if (resourceID != null && resourceID.length() > 32) {
            throw new IncompleteRequestException("Angegebene Resource-ID ist ungueltig (" + resourceID + ")!");
        }
    }

    public static void checkDatMLSDFVersion(String sdfVersion) throws IncompleteRequestException {
        Pattern p;
        Matcher m;
        if (sdfVersion != null && sdfVersion.length() > 0 && !(m = (p = Pattern.compile("^\\d?\\d\\.\\d$")).matcher(sdfVersion)).matches()) {
            throw new IncompleteRequestException("Ungueltige DatML/RES-Versionsangabe!");
        }
    }

    public static void checkDatMlRawVersion(String datMlRawVersion) throws IncompleteRequestException {
        if (!DatMlRawVersion.isValidPrettyDatMlRawVersion(datMlRawVersion)) {
            throw new IncompleteRequestException("Ungueltige DatML/RAW-Versionsangabe.");
        }
    }

    public static void checkCommonResourceId(String resourceId) throws IncompleteRequestException {
        if (resourceId.length() != 10) {
            throw new IncompleteRequestException("Ungueltige allgemeine RessourceId.");
        }
    }
}

