/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileObject;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileProvider;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileSystemConfigBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsFileSystem
extends AbstractFileSystem {
    private static final Log log = LogFactory.getLog(HdfsFileSystem.class);
    private FileSystem fs;

    protected HdfsFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    @Override
    protected void addCapabilities(Collection<Capability> capabilities) {
        capabilities.addAll(HdfsFileProvider.CAPABILITIES);
    }

    @Override
    public void close() {
        try {
            if (null != this.fs) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing HDFS client", e);
        }
        super.close();
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        throw new FileSystemException("Operation not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileObject resolveFile(FileName name) throws FileSystemException {
        HdfsFileSystem hdfsFileSystem = this;
        synchronized (hdfsFileSystem) {
            if (this.fs == null) {
                String hdfsUri = name.getRootURI();
                HdfsFileSystemConfigBuilder builder = HdfsFileSystemConfigBuilder.getInstance();
                String configName = builder.getConfigName(this.getFileSystemOptions());
                Configuration conf = new Configuration(true);
                conf.set("fs.defaultFS", hdfsUri);
                if (configName != null) {
                    log.debug((Object)("Adding HDFS configuration file: " + configName));
                    conf.addResource(configName);
                }
                try {
                    this.fs = FileSystem.get((Configuration)conf);
                }
                catch (IOException e) {
                    log.error((Object)("Error connecting to filesystem " + hdfsUri), (Throwable)e);
                    throw new FileSystemException("Error connecting to filesystem " + hdfsUri, e);
                }
            }
        }
        boolean useCache = null != this.getContext().getFileSystemManager().getFilesCache();
        FileObject file = useCache ? this.getFileFromCache(name) : null;
        if (null == file) {
            String path = null;
            try {
                path = URLDecoder.decode(name.getPath(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                path = name.getPath();
            }
            Path filePath = new Path(path);
            file = new HdfsFileObject((AbstractFileName)name, this, this.fs, filePath);
            if (useCache) {
                this.putFileToCache(file);
            }
        }
        if (this.getFileSystemManager().getCacheStrategy().equals((Object)CacheStrategy.ON_RESOLVE)) {
            file.refresh();
        }
        return file;
    }
}

