/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class Wget {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("\nUsage: java de.superx.bin.Wget url Dateiname");
            System.exit(1);
        }
        String url = args[0];
        String filename = args[1];
        if (filename.endsWith(".xls")) {
            url = String.valueOf(url) + "&stylesheet=tabelle_xls.xsl&maxoffset=1000000&contenttype=application/vnd.ms-excel";
        }
        if (filename.endsWith(".pdf")) {
            System.out.println("PDF derzeit nicht unterstuetzt.");
            url = String.valueOf(url) + "&stylesheet=tabelle_fo_pdf.xsl&maxoffset=1000000&contenttype=application/pdf";
            System.exit(1);
        }
        if (filename.endsWith(".xml")) {
            url = String.valueOf(url) + "&stylesheet=tabelle_xml.xsl&maxoffset=1000000&contenttype=text/xml";
        }
        try {
            if (url.indexOf("^") > -1) {
                url = StringUtils.replace(url, "^", "");
            }
            System.out.println("Load URL: " + url);
            if (filename.endsWith(".xls")) {
                Wget.getBinary(url, filename);
            }
            if (filename.endsWith(".html") || filename.endsWith(".htm") || filename.endsWith(".xml")) {
                Wget.getText(url, filename);
            }
        }
        catch (Exception e2) {
            System.out.println("Fehler : " + e2);
            System.exit(1);
        }
    }

    private static void getBinary(String url, String filename) throws MalformedURLException, IOException, FileNotFoundException {
        URL u = new URL(url);
        URLConnection uc = u.openConnection();
        String contentType = uc.getContentType();
        int contentLength = uc.getContentLength();
        if (contentType.startsWith("text/") || contentLength == -1) {
            throw new IOException("Keine Bin\u00e4rdatei oder keine Dateilaenge vom Server geliefert");
        }
        InputStream raw = uc.getInputStream();
        BufferedInputStream in = new BufferedInputStream(raw);
        byte[] data = new byte[contentLength];
        int bytesRead = 0;
        int offset = 0;
        while (offset < contentLength) {
            bytesRead = ((InputStream)in).read(data, offset, data.length - offset);
            if (bytesRead == -1) break;
            offset += bytesRead;
        }
        ((InputStream)in).close();
        if (offset != contentLength) {
            throw new IOException("Nur " + offset + " bytes gelesen; Erwartete " + contentLength + " bytes");
        }
        FileOutputStream out = new FileOutputStream(filename);
        out.write(data);
        out.flush();
        out.close();
        System.out.println("Datei " + filename + " gespeichert");
    }

    private static InputStream getText(String url, String filename) throws MalformedURLException, IOException {
        String s;
        StringBuffer sb = new StringBuffer();
        URL u = new URL(url);
        InputStream is = u.openStream();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
        while ((s = dis.readLine()) != null) {
            sb.append(String.valueOf(s) + "\n");
        }
        if (sb.indexOf("Session-Timeout erreicht") > -1) {
            throw new IOException("Authentifizierung fehlgeschlagen");
        }
        FileWriter fw = new FileWriter(filename);
        BufferedWriter bfw = new BufferedWriter(fw);
        bfw.write(sb.toString());
        bfw.close();
        fw.close();
        System.out.println("Datei " + filename + " gespeichert");
        return is;
    }
}

