/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.memtext.util.DateUtils;
import de.superx.applet.SichtApplet;
import de.superx.applet.SxForm;
import de.superx.applet.SxTableModel;
import de.superx.common.Sichtgruppe;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class SxField
extends JTextField
implements ComboBoxEditor,
FocusListener {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_INTEGER = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_DATE = 3;
    public static final int TYPE_SQL = 4;
    private Sichtgruppe sichtgruppe;
    protected int field_type = 0;
    protected int field_length = -1;
    protected boolean isInputNeeded = false;
    protected boolean field_input = false;
    protected boolean field_withCombo = false;
    private String field_value = "";
    private Object field_key = new Integer(-1);
    private SxForm sxForm = null;
    private JButton defaultBtn = null;
    private Object defaultValue = new Integer(-1);
    private SichtApplet selectedSicht;
    JTable tableView = null;

    public SxField() {
        this.init();
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean hasSichten() {
        return this.selectedSicht != null;
    }

    public SxField(int type) {
        this.field_type = type;
        this.init();
    }

    public SxField(String text) {
        this.setText(text);
        this.init();
    }

    public SxField(String text, int columns, int type) {
        this.field_type = type;
        this.setText(text);
        this.setColumns(columns);
        this.init();
    }

    public SxField(String text, int columns) {
        this.setText(text);
        this.setColumns(columns);
        this.init();
    }

    public SxField(int type, int length) {
        this.field_type = type;
        this.field_length = length;
        this.init();
    }

    public SxField(String text, int columns, int type, int length) {
        this.field_type = type;
        this.setText(text);
        this.setColumns(columns);
        this.field_length = length;
        this.init();
    }

    public void setJTable(JTable table) {
        this.tableView = table;
    }

    public void setForm(SxForm form) {
        this.sxForm = form;
    }

    public void setWithCombo(boolean withCombo) {
        this.field_withCombo = withCombo;
    }

    public boolean isWithCombo() {
        return this.field_withCombo;
    }

    public SxForm getForm() {
        return this.sxForm;
    }

    public void setType(int type) {
        this.field_type = type;
    }

    public int getType() {
        return this.field_type;
    }

    public void setKey(Object key) {
        this.field_key = key;
    }

    public Object getKey() {
        Object ret = this.field_key;
        return ret;
    }

    public void setInputNeeded(boolean input) {
        this.isInputNeeded = input;
    }

    public boolean isInputNeeded() {
        return this.isInputNeeded;
    }

    @Override
    public boolean isValid() {
        if (this.checkField()) {
            this.setBackground(Color.white);
            this.repaint();
            return true;
        }
        this.setBackground(Color.red);
        this.repaint();
        return false;
    }

    @Override
    public Component getEditorComponent() {
        return this;
    }

    @Override
    public Object getItem() {
        return this.getText();
    }

    @Override
    public void setItem(Object anObject) {
        if (anObject == null) {
            this.setText("");
        } else {
            this.setText(anObject.toString());
        }
    }

    protected void init() {
        final SxField thisField = this;
        KeyAdapter sxFieldKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e2) {
                switch (e2.getKeyCode()) {
                    case 10: {
                        JButton defaultBtn;
                        if (SxField.this.tableView != null) {
                            int col;
                            SxTableModel model = (SxTableModel)SxField.this.tableView.getModel();
                            TableCellEditor editor = SxField.this.tableView.getCellEditor();
                            Component component = SxField.this.tableView.getEditorComponent();
                            int row = SxField.this.tableView.getSelectedRow();
                            Object value = model.getObjectAt(row, col = SxField.this.tableView.getSelectedColumn());
                            if (value instanceof Integer) {
                                SxField.this.field_type = 1;
                            }
                            if (value instanceof Double) {
                                SxField.this.field_type = 2;
                            }
                            if (value instanceof Date) {
                                SxField.this.field_type = 3;
                            }
                            SxField.this.field_value = ((JTextField)component).getText();
                        } else {
                            SxField.this.field_value = SxField.this.getText();
                            SxField.this.setKey(new Integer("-1"));
                        }
                        if (!SxField.this.isValid()) {
                            e2.consume();
                            SxField.this.getToolkit().beep();
                            break;
                        }
                        if (SxField.this.sxForm != null) {
                            SxField.this.sxForm.removeErrorComp(thisField);
                            defaultBtn = SxField.this.sxForm.getDefaultBtn();
                            if (defaultBtn == null) break;
                            defaultBtn.doClick();
                            break;
                        }
                        defaultBtn = SxField.this.getRootPane().getDefaultButton();
                        if (defaultBtn == null) break;
                        defaultBtn.doClick();
                        break;
                    }
                    case 27: {
                        if (SxField.this.tableView == null) break;
                        TableCellEditor editor = SxField.this.tableView.getCellEditor();
                        editor.cancelCellEditing();
                        break;
                    }
                    default: {
                        int metaPressed = e2.getModifiers() & 4;
                        if (metaPressed == 0) break;
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e2) {
                JComboBox combo;
                block0 : switch (SxField.this.field_type) {
                    case 1: 
                    case 2: {
                        int altPressed;
                        switch (e2.getKeyChar()) {
                            case ',': 
                            case '-': 
                            case '.': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                SxField.this.field_input = true;
                                break block0;
                            }
                        }
                        int metaPressed = e2.getModifiers() & 4;
                        if (metaPressed != 0 || (altPressed = e2.getModifiers() & 8) != 0 || e2.getKeyChar() < 'A' || e2.getKeyChar() > 'z') break;
                        SxField.this.getToolkit().beep();
                        e2.consume();
                        break;
                    }
                    case 3: {
                        int altPressed;
                        switch (e2.getKeyChar()) {
                            case '-': 
                            case '.': 
                            case '/': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                SxField.this.field_input = true;
                                break block0;
                            }
                        }
                        int metaPressed = e2.getModifiers() & 4;
                        if (metaPressed != 0 || (altPressed = e2.getModifiers() & 8) != 0 || e2.getKeyChar() < 'A' || e2.getKeyChar() > 'z') break;
                        SxField.this.getToolkit().beep();
                        e2.consume();
                        break;
                    }
                    case 0: {
                        SxField.this.field_input = true;
                        break;
                    }
                }
                int text_len = SxField.this.getText().length();
                if (SxField.this.field_length != -1 && text_len >= SxField.this.field_length && SxField.this.getSelectedText() == null && e2.getKeyChar() != '\n' && e2.getKeyChar() != '\b') {
                    e2.consume();
                    SxField.this.getToolkit().beep();
                }
                if (SxField.this.sxForm != null && SxField.this.isWithCombo() && (combo = (JComboBox)SxField.this.sxForm.getComp(SxField.this.getName())).getItemCount() > 0) {
                    combo.removeAllItems();
                }
            }
        };
        this.addKeyListener(sxFieldKeyListener);
        this.addFocusListener(this);
    }

    private boolean checkField() {
        boolean error = false;
        this.field_value = "";
        try {
            this.field_value = this.getText();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.field_value.equals("")) {
            this.setKey(this.defaultValue);
            return !this.isInputNeeded();
        }
        this.field_value = this.getKey().toString();
        if (this.field_value.equals("-1")) {
            this.field_value = this.getText();
        }
        try {
            switch (this.field_type) {
                case 1: {
                    new Integer(this.field_value);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (!DateUtils.isValidDate(this.field_value)) {
                        throw new Exception("Date error");
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            error = true;
        }
        return !error;
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.field_input = false;
    }

    @Override
    public void focusLost(FocusEvent e2) {
        if (this.field_input) {
            JComboBox combo;
            this.setKey(new Integer("-1"));
            if (this.sxForm != null && this.isWithCombo() && (combo = (JComboBox)this.sxForm.getComp(this.getName())).getItemCount() > 0) {
                combo.removeAllItems();
            }
        }
        if (!this.isValid()) {
            if (this.sxForm != null) {
                this.sxForm.addErrorComp(this);
            }
        } else if (this.sxForm != null) {
            this.sxForm.removeErrorComp(this);
        }
    }

    public SichtApplet getSelectedSicht() {
        return this.selectedSicht;
    }

    public void setSelectedSicht(SichtApplet sicht) {
        this.selectedSicht = sicht;
    }

    public void clearSichtSelections() {
        if (this.selectedSicht != null) {
            this.selectedSicht.clearSelection();
        }
        if (this.sichtgruppe != null) {
            this.sichtgruppe.clearSelections();
        }
    }

    @Override
    public String toString() {
        String result = "";
        if (this.getText() != null) {
            result = String.valueOf(result) + this.getText();
        }
        result = String.valueOf(result) + " -key:";
        result = this.getKey() != null ? String.valueOf(result) + this.getKey() : String.valueOf(result) + " null";
        return result;
    }

    public Sichtgruppe getSichtgruppe() {
        return this.sichtgruppe;
    }

    public void setSichtgruppe(Sichtgruppe sichtgruppe) {
        this.sichtgruppe = sichtgruppe;
    }
}

