/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util.saxon.extensions;

import de.memtext.util.StringUtils;
import de.superx.util.HtmlUtils;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

public class Headers2Html
implements ExtensionFunction {
    public QName getName() {
        return new QName("http://memtext.de", "headers2html");
    }

    public SequenceType getResultType() {
        return SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ONE)};
    }

    public XdmValue call(XdmValue[] arguments) throws SaxonApiException {
        String headerStr = null;
        try {
            headerStr = arguments[0].getUnderlyingValue().getStringValue();
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
        headerStr = headerStr.trim();
        if (headerStr.endsWith("^")) {
            headerStr = headerStr.substring(0, headerStr.length() - 1);
        }
        StringBuffer buf = new StringBuffer(headerStr);
        StringUtils.replace(buf, "\\n", "\n");
        StringUtils.replace(buf, "\\000", "\u0000");
        HtmlUtils.HeaderMatrix headers = null;
        headers = new HtmlUtils.HeaderMatrix(buf.toString(), "^", "\u0000");
        return new XdmAtomicValue(headers.toString());
    }
}

