/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.baseobjects.coll;

import de.memtext.baseobjects.NamedObjectI;
import de.memtext.baseobjects.coll.BaseObjectCollection;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;

public class NamedObjectCollection
extends BaseObjectCollection
implements Collection,
Serializable {
    private static final long serialVersionUID = 1L;

    public NamedObjectI getByName(String name) {
        NamedObjectI result = null;
        for (NamedObjectI test : this.collect) {
            if (!test.getName().equals(name)) continue;
            result = test;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("No element with name " + name + " found.");
        }
        return result;
    }

    public String getNamesApostropheString() {
        StringBuffer result = new StringBuffer();
        for (NamedObjectI test : this.collect) {
            result.append("'" + test.getName() + "',");
        }
        StringUtils.deleteLastChar(result);
        if (result.length() == 0) {
            result.append("''");
        }
        return result.toString();
    }

    public boolean containsItemWithName(String name) {
        boolean result = false;
        for (NamedObjectI test : this.collect) {
            if (!EqualsUtil.areEqual(test.getName(), name)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean add(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("can't add null value");
        }
        if (!(o instanceof NamedObjectI)) {
            throw new IllegalArgumentException("only named Objects allowed");
        }
        return this.collect.add(o);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.size() + " NamedObjects: ");
        for (NamedObjectI element : this) {
            result.append(element + " - ");
        }
        return result.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        NamedObjectCollection c = new NamedObjectCollection();
        c.addAll((Collection)this);
        return c;
    }
}

