/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.jaas;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.jaas.AuthorityGranter;
import org.springframework.security.authentication.jaas.DefaultLoginExceptionResolver;
import org.springframework.security.authentication.jaas.JaasAuthenticationCallbackHandler;
import org.springframework.security.authentication.jaas.JaasAuthenticationToken;
import org.springframework.security.authentication.jaas.JaasGrantedAuthority;
import org.springframework.security.authentication.jaas.LoginExceptionResolver;
import org.springframework.security.authentication.jaas.event.JaasAuthenticationFailedEvent;
import org.springframework.security.authentication.jaas.event.JaasAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.session.SessionDestroyedEvent;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasAuthenticationProvider
implements AuthenticationProvider,
ApplicationEventPublisherAware,
InitializingBean,
ApplicationListener<SessionDestroyedEvent> {
    protected static final Log log = LogFactory.getLog(JaasAuthenticationProvider.class);
    private LoginExceptionResolver loginExceptionResolver = new DefaultLoginExceptionResolver();
    private Resource loginConfig;
    private String loginContextName = "SPRINGSECURITY";
    private AuthorityGranter[] authorityGranters;
    private JaasAuthenticationCallbackHandler[] callbackHandlers;
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean refreshConfigurationOnStartup = true;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.loginConfig, (String)("loginConfig must be set on " + this.getClass()));
        Assert.hasLength((String)this.loginContextName, (String)("loginContextName must be set on " + this.getClass()));
        this.configureJaas(this.loginConfig);
        Assert.notNull((Object)Configuration.getConfiguration(), (String)"As per http://java.sun.com/j2se/1.5.0/docs/api/javax/security/auth/login/Configuration.html \"If a Configuration object was set via the Configuration.setConfiguration method, then that object is returned. Otherwise, a default Configuration object is returned\". Your JRE returned null to Configuration.getConfiguration().");
    }

    @Override
    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        if (!(auth instanceof UsernamePasswordAuthenticationToken)) {
            return null;
        }
        UsernamePasswordAuthenticationToken request = (UsernamePasswordAuthenticationToken)auth;
        try {
            LoginContext loginContext = new LoginContext(this.loginContextName, new InternalCallbackHandler(auth));
            loginContext.login();
            HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
            authorities.addAll(request.getAuthorities());
            Set<Principal> principals = loginContext.getSubject().getPrincipals();
            for (Principal principal : principals) {
                for (int i = 0; i < this.authorityGranters.length; ++i) {
                    AuthorityGranter granter = this.authorityGranters[i];
                    Set<String> roles = granter.grant(principal);
                    if (roles == null || roles.isEmpty()) continue;
                    for (String role : roles) {
                        authorities.add(new JaasGrantedAuthority(role, principal));
                    }
                }
            }
            JaasAuthenticationToken result = new JaasAuthenticationToken(request.getPrincipal(), request.getCredentials(), new ArrayList<GrantedAuthority>(authorities), loginContext);
            this.publishSuccessEvent(result);
            return result;
        }
        catch (LoginException loginException) {
            AuthenticationException ase = this.loginExceptionResolver.resolveException(loginException);
            this.publishFailureEvent(request, ase);
            throw ase;
        }
    }

    protected void configureJaas(Resource loginConfig) throws IOException {
        this.configureJaasUsingLoop();
        if (this.refreshConfigurationOnStartup) {
            Configuration.getConfiguration().refresh();
        }
    }

    private void configureJaasUsingLoop() throws IOException {
        String loginConfigUrl = this.convertLoginConfigToUrl();
        boolean alreadySet = false;
        int n = 1;
        String prefix = "login.config.url.";
        String existing = null;
        while ((existing = Security.getProperty("login.config.url." + n)) != null && !(alreadySet = existing.equals(loginConfigUrl))) {
            ++n;
        }
        if (!alreadySet) {
            String key = "login.config.url." + n;
            log.debug((Object)("Setting security property [" + key + "] to: " + loginConfigUrl));
            Security.setProperty(key, loginConfigUrl);
        }
    }

    private String convertLoginConfigToUrl() throws IOException {
        String loginConfigPath = this.loginConfig.getFile().getAbsolutePath();
        loginConfigPath.replace(File.separatorChar, '/');
        if (!loginConfigPath.startsWith("/")) {
            loginConfigPath = "/" + loginConfigPath;
        }
        return new URL("file", "", loginConfigPath).toString();
    }

    protected void handleLogout(SessionDestroyedEvent event) {
        SecurityContext context = event.getSecurityContext();
        if (context == null) {
            log.debug((Object)"The destroyed session has no SecurityContext");
            return;
        }
        Authentication auth = context.getAuthentication();
        if (auth != null && auth instanceof JaasAuthenticationToken) {
            JaasAuthenticationToken token = (JaasAuthenticationToken)auth;
            try {
                LoginContext loginContext = token.getLoginContext();
                if (loginContext != null) {
                    log.debug((Object)("Logging principal: [" + token.getPrincipal() + "] out of LoginContext"));
                    loginContext.logout();
                } else {
                    log.debug((Object)("Cannot logout principal: [" + token.getPrincipal() + "] from LoginContext. " + "The LoginContext is unavailable"));
                }
            }
            catch (LoginException e) {
                log.warn((Object)"Error error logging out of LoginContext", (Throwable)e);
            }
        }
    }

    public void onApplicationEvent(SessionDestroyedEvent event) {
        this.handleLogout(event);
    }

    protected void publishFailureEvent(UsernamePasswordAuthenticationToken token, AuthenticationException ase) {
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new JaasAuthenticationFailedEvent(token, ase));
    }

    protected void publishSuccessEvent(UsernamePasswordAuthenticationToken token) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new JaasAuthenticationSuccessEvent(token));
        }
    }

    AuthorityGranter[] getAuthorityGranters() {
        return this.authorityGranters;
    }

    public void setAuthorityGranters(AuthorityGranter[] authorityGranters) {
        this.authorityGranters = authorityGranters;
    }

    JaasAuthenticationCallbackHandler[] getCallbackHandlers() {
        return this.callbackHandlers;
    }

    public void setCallbackHandlers(JaasAuthenticationCallbackHandler[] callbackHandlers) {
        this.callbackHandlers = callbackHandlers;
    }

    public Resource getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(Resource loginConfig) {
        this.loginConfig = loginConfig;
    }

    String getLoginContextName() {
        return this.loginContextName;
    }

    public void setLoginContextName(String loginContextName) {
        this.loginContextName = loginContextName;
    }

    LoginExceptionResolver getLoginExceptionResolver() {
        return this.loginExceptionResolver;
    }

    public void setLoginExceptionResolver(LoginExceptionResolver loginExceptionResolver) {
        this.loginExceptionResolver = loginExceptionResolver;
    }

    public void setRefreshConfigurationOnStartup(boolean refresh) {
        this.refreshConfigurationOnStartup = refresh;
    }

    @Override
    public boolean supports(Class<? extends Object> aClass) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(aClass);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    private class InternalCallbackHandler
    implements CallbackHandler {
        private Authentication authentication;

        public InternalCallbackHandler(Authentication authentication) {
            this.authentication = authentication;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < JaasAuthenticationProvider.this.callbackHandlers.length; ++i) {
                JaasAuthenticationCallbackHandler handler = JaasAuthenticationProvider.this.callbackHandlers[i];
                for (int j = 0; j < callbacks.length; ++j) {
                    Callback callback = callbacks[j];
                    handler.handle(callback, this.authentication);
                }
            }
        }
    }
}

