/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv.filter;

import de.werum.sis.csv.filter.Filter;
import de.werum.sis.csv.filter.FilterConstants;
import de.werum.sis.csv.filter.FilterField;
import de.werum.sis.csv.filter.FilterFieldGroup;
import de.werum.sis.csv.filter.FilterFieldSet;
import de.werum.sis.csv.filter.FilterFieldSetInstance;
import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FilterXmlParser
extends DefaultHandler
implements FilterConstants {
    private Filter filter;
    private Stack<List<Object>> lists;
    private List<Object> currentList;
    private FilterField currentField;
    private FilterFieldSet currentFieldSet;
    private StringBuffer buffer;

    public synchronized Filter parse(InputStream in) throws Exception {
        return this.parse(new InputSource(in));
    }

    public synchronized Filter parse(InputSource in) throws Exception {
        this.filter = null;
        this.lists = new Stack();
        this.currentList = null;
        this.currentField = null;
        this.currentFieldSet = null;
        this.buffer = new StringBuffer();
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(in, (DefaultHandler)this);
        return this.filter;
    }

    private void startNewList(List<Object> list) {
        if (this.currentList != null) {
            this.lists.push(this.currentList);
        }
        this.currentList = list;
    }

    private void finishList() {
        this.currentList = this.lists.isEmpty() ? null : this.lists.pop();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.buffer.delete(0, this.buffer.length());
        if ("filter".equalsIgnoreCase(qName)) {
            this.filter = new Filter();
            String type = attributes.getValue("type");
            if (type != null && type.equalsIgnoreCase("ascii")) {
                this.filter.setType(2);
            }
            this.filter.setId(attributes.getValue("id"));
            this.filter.setName(attributes.getValue("name"));
            this.filter.setJspName(attributes.getValue("jsp"));
            this.startNewList(this.filter.getFields());
        } else if ("field".equalsIgnoreCase(qName)) {
            String length;
            this.currentField = new FilterField();
            this.currentField.setName(attributes.getValue("name"));
            this.currentField.setNameImport(attributes.getValue("import-name"));
            String position = attributes.getValue("position");
            if (position != null) {
                this.currentField.setPosition(new Integer(position));
            }
            if ((length = attributes.getValue("length")) != null) {
                this.currentField.setLength(new Integer(length));
            }
            if (this.currentList != null) {
                this.currentList.add(this.currentField);
            }
        } else if ("group".equalsIgnoreCase(qName)) {
            String number;
            FilterFieldGroup fieldGroup = new FilterFieldGroup();
            fieldGroup.setName(attributes.getValue("name"));
            fieldGroup.setNameImport(attributes.getValue("import-name"));
            String maxNumber = attributes.getValue("max");
            if (maxNumber != null) {
                fieldGroup.setMaxNumber(Integer.parseInt(maxNumber));
            }
            if ((number = attributes.getValue("number")) != null) {
                fieldGroup.setNumber(Integer.parseInt(number));
            }
            if (this.currentList != null) {
                this.currentList.add(fieldGroup);
            }
            this.startNewList(fieldGroup.getFields());
        } else if ("set".equalsIgnoreCase(qName)) {
            this.currentFieldSet = new FilterFieldSet();
            this.currentFieldSet.setName(attributes.getValue("name"));
            this.currentFieldSet.setNameImport(attributes.getValue("import-name"));
            String additive = attributes.getValue("additive");
            if (additive != null) {
                this.currentFieldSet.setAdditive(new Boolean(additive));
            }
            if (this.filter != null) {
                this.filter.getFieldSets().add(this.currentFieldSet);
            }
            this.startNewList(this.currentFieldSet.getFields());
        } else if ("instance".equalsIgnoreCase(qName) && this.currentFieldSet != null) {
            FilterFieldSetInstance fieldSetInstance = new FilterFieldSetInstance(this.currentFieldSet);
            fieldSetInstance.setName(attributes.getValue("name"));
            this.currentFieldSet.getInstances().add(fieldSetInstance);
            this.startNewList(fieldSetInstance.getFields());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("filter".equalsIgnoreCase(qName)) {
            this.finishList();
        } else if ("group".equalsIgnoreCase(qName)) {
            this.finishList();
        } else if ("set".equalsIgnoreCase(qName)) {
            this.finishList();
        } else if ("instance".equalsIgnoreCase(qName)) {
            this.finishList();
        } else if ("default".equalsIgnoreCase(qName) && this.currentField != null) {
            this.currentField.setDefaultValue(this.buffer.toString());
        }
    }

    @Override
    public void characters(char[] chars, int offset, int length) throws SAXException {
        this.buffer.append(chars, offset, length);
    }
}

