/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv.filter;

import de.werum.sis.csv.CsvReader;
import de.werum.sis.csv.filter.DataContainer;
import de.werum.sis.csv.filter.Filter;
import de.werum.sis.csv.filter.FilterField;
import de.werum.sis.csv.filter.FilterFieldGroup;
import de.werum.sis.csv.filter.FilterFieldSet;
import de.werum.sis.csv.filter.FilterFieldSetInstance;
import de.werum.sis.csv.filter.FilterImporter;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;

public class CsvFilterImporter
extends FilterImporter {
    private char separator = (char)59;

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    @Override
    public void importData(Filter filter, InputStream in, DataContainer dataContainer) throws IOException {
        CsvReader reader = this.getEncoding() != null && this.getEncoding().length() > 0 ? new CsvReader(new InputStreamReader(in, this.getEncoding()), this.separator, '\"') : new CsvReader(new InputStreamReader(in), this.separator, '\"');
        HashMap<String, Integer> fieldSetIndices = new HashMap<String, Integer>();
        boolean endOfFileReached = false;
        for (int i = 1; i < this.getLineNumberFrom() && !endOfFileReached; ++i) {
            endOfFileReached = reader.skipLine();
        }
        if (!endOfFileReached && filter.getPosition() != null) {
            String[] values = reader.readLine();
            if (values == null) {
                endOfFileReached = true;
            } else if (values.length > 0) {
                this.read(dataContainer, null, filter.getFields(), values, 0);
            }
        }
        while (!endOfFileReached) {
            FilterFieldSetInstance fieldSetInstance;
            String[] values = reader.readLine();
            if (values == null) {
                endOfFileReached = true;
                continue;
            }
            if (values.length <= 0 || (fieldSetInstance = this.getFieldSetInstance(filter, values)) == null) continue;
            String fieldSetName = fieldSetInstance.getFieldSet().getNameImport();
            Integer index = (Integer)fieldSetIndices.get(fieldSetName);
            index = index == null ? new Integer(0) : new Integer(index + 1);
            fieldSetIndices.put(fieldSetName, index);
            dataContainer.setValue(fieldSetName + dataContainer.getNumberOfKeyword(), String.valueOf(index + 1));
            this.read(dataContainer, fieldSetName + dataContainer.getIndicesPrefix() + index + dataContainer.getIndicesSuffix(), fieldSetInstance.getFields(), values, 0);
        }
    }

    private FilterFieldSetInstance getFieldSetInstance(Filter filter, String[] values) {
        FilterFieldSetInstance result = null;
        if (filter.getFieldSets().size() == 1 && filter.getFieldSets().get(0).getInstances().size() == 1) {
            result = filter.getFieldSets().get(0).getInstances().get(0);
        } else {
            for (int i = 0; result == null && i < filter.getFieldSets().size(); ++i) {
                FilterFieldSet fieldSet = filter.getFieldSets().get(i);
                for (int j = 0; result == null && j < fieldSet.getInstances().size(); ++j) {
                    FilterFieldSetInstance fieldSetInstance = fieldSet.getInstances().get(j);
                    FilterField[] selectors = fieldSetInstance.getPossibleSelectors();
                    if (selectors == null || selectors.length <= 0) continue;
                    boolean found = true;
                    for (int k = 0; k < selectors.length; ++k) {
                        String value;
                        FilterField selector = selectors[k];
                        if (selector.getPosition() == null || selector.getPosition() <= 0 || (value = selector.getPosition() <= values.length ? values[selector.getPosition() - 1] : null) != null && value.length() != 0 && selector.getDefaultValue().equals(value)) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    result = fieldSetInstance;
                }
            }
        }
        return result;
    }

    private Point read(DataContainer dataContainer, String prefix, List<Object> fields, String[] values, int offset) {
        Point region = new Point(Integer.MAX_VALUE, Integer.MIN_VALUE);
        String prefixNotNull = "";
        if (prefix != null && prefix.length() > 0) {
            prefixNotNull = prefix + dataContainer.getNameSeparator();
        }
        for (Object object : fields) {
            if (object instanceof FilterField) {
                FilterField field = (FilterField)object;
                String value = null;
                if (field.getPosition() != null && field.getPosition() > 0) {
                    int position = field.getPosition() + offset;
                    if (position <= values.length) {
                        value = values[position - 1];
                    }
                    if (position < region.x) {
                        region.x = position;
                    }
                    if (position > region.y) {
                        region.y = position;
                    }
                }
                if ((value == null || value.length() == 0) && field.getDefaultValue() != null && field.getDefaultValue().length() > 0) {
                    value = field.getDefaultValue();
                }
                dataContainer.setValue(prefixNotNull + field.getNameImport(), value);
                continue;
            }
            if (!(object instanceof FilterFieldGroup)) continue;
            FilterFieldGroup fieldGroup = (FilterFieldGroup)object;
            int subOffset = offset;
            for (int j = 0; j < fieldGroup.getNumber(); ++j) {
                Point subRegion = this.read(dataContainer, prefixNotNull + fieldGroup.getNameImport() + (fieldGroup.getMaxNumber() > 1 ? dataContainer.getIndicesPrefix() + j + dataContainer.getIndicesSuffix() : ""), fieldGroup.getFields(), values, subOffset);
                if (subRegion.x < region.x) {
                    region.x = subRegion.x;
                }
                if (subRegion.y > region.y) {
                    region.y = subRegion.y;
                }
                subOffset += subRegion.y - subRegion.x + 1;
            }
        }
        return region;
    }
}

