/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.meta.MetaCustomSDFFeldReferenz;
import de.statspez.sdf.generator.meta.SDFTags;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.parser.DataGroupParser;
import de.statspez.sdf.generator.parser.MessageDataGroupParser;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserChain;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SDFAusgabesatzParser
extends SubParser
implements SuperParser {
    private ParserChain parserChain = new ParserChain();
    private MessageDataGroupParser messageDataGroupParser;
    private DataGroupParser dataGroupParser;
    private MetaSDFAusgabesatz ausgabesatz;
    private Vector selectors;

    public SDFAusgabesatzParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
        this.messageDataGroupParser = new MessageDataGroupParser(this, resolver);
        this.parserChain.addParser((SubParser)this.messageDataGroupParser);
        this.dataGroupParser = new DataGroupParser(this, resolver);
        this.parserChain.addParser((SubParser)this.dataGroupParser);
        this.ausgabesatz = null;
        this.selectors = new Vector();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("outputDataModel".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name != null) {
                this.ausgabesatz.setName(SDFTags.dekodiereXMLName(name));
            } else {
                this.ausgabesatz.setName("Ausgabesatz");
            }
        } else if ("selector".equalsIgnoreCase(localName)) {
            String variable = atts.getValue("variable");
            if (variable == null) {
                throw new MetaParseException("Variablenname nicht definiert!");
            }
            this.selectors.add(SDFTags.dekodiereXMLName(variable));
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("outputDataModel".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("outputDataModel".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSDF(namespaceURI);
            this.ausgabesatz = new MetaSDFAusgabesatz();
            this.selectors.clear();
            this.enable();
        } else if ("annotation".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("selectors".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSDF(namespaceURI);
        } else if ("selector".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSDF(namespaceURI);
        } else if ("groups".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSDF(namespaceURI);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts)) {
            if ("description".equalsIgnoreCase(localName)) {
                ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            } else {
                throw MetaParseException.unknownTagException((String)localName);
            }
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("outputDataModel".equalsIgnoreCase(localName)) {
            boolean resolved = true;
            Iterator iter = this.selectors.iterator();
            while (iter != null && iter.hasNext() && resolved) {
                String selector = (String)iter.next();
                Iterator dataGroups = this.ausgabesatz.getAusgabegruppen();
                while (dataGroups != null && dataGroups.hasNext() && resolved) {
                    MetaSDFAusgabegruppe dataGroup = (MetaSDFAusgabegruppe)dataGroups.next();
                    if (1 != dataGroup.getAttributDaten()) continue;
                    resolved = false;
                    Iterator variables = dataGroup.getSDFFeldReferenzen();
                    while (variables != null && variables.hasNext() && !resolved) {
                        MetaCustomSDFFeldReferenz variable = (MetaCustomSDFFeldReferenz)variables.next();
                        if (!variable.getReferenceName().equals(selector)) continue;
                        variable.setIstSelektor(true);
                        resolved = true;
                    }
                }
                if (resolved) continue;
                throw new MetaParseException("Selektorvariable nicht (in allen Ausgabegruppen) definiert!");
            }
            this.disableAndNotify();
        } else if (!("selectors".equalsIgnoreCase(localName) || "selector".equalsIgnoreCase(localName) || "groups".equalsIgnoreCase(localName) || this.parserChain.endElement(namespaceURI, localName, qName))) {
            if ("description".equalsIgnoreCase(localName)) {
                this.ausgabesatz.setBeschreibung(this.superParser().charData().toString().trim());
            } else if ("annotation".equalsIgnoreCase(localName)) {
                this.ausgabesatz.setKommentar(this.superParser().charData().toString().trim());
            } else {
                throw MetaParseException.unknownClosingTagException((String)localName);
            }
        }
    }

    public MetaElementInterface object() {
        return this.ausgabesatz;
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public void notifyObjectAvailable(SubParser aParser) {
        this.ausgabesatz.addToAusgabegruppen((MetaSDFAusgabegruppe)aParser.object());
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

