/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.util;

import java.util.HashMap;
import java.util.Map;
import org.saiku.olap.query.IQuery;
import org.saiku.service.util.exception.SaikuServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectHolder {
    ThreadLocal<Map<String, IQuery>> threadQueries = new ThreadLocal();
    private static final Logger LOG = LoggerFactory.getLogger(ObjectHolder.class);

    public void putIQuery(String queryName, IQuery query) {
        this.getIQueryMap().put(queryName, query);
    }

    public void removeIQuery(String queryName) {
        this.getIQueryMap().remove(queryName);
    }

    public IQuery getIQuery(String queryName) {
        IQuery query = this.getIQueryMap().get(queryName);
        if (query == null) {
            throw new SaikuServiceException("No query with name (" + queryName + ") found");
        }
        return query;
    }

    public Map<String, IQuery> getIQueryMap() {
        LOG.trace("ObjectHoler.getIQueryMap : Thread ID " + Thread.currentThread().getId() + " Name: " + Thread.currentThread().getName());
        if (this.threadQueries.get() == null) {
            this.threadQueries.set(new HashMap());
        }
        return this.threadQueries.get();
    }
}

