/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.Variable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class IteratorIterator
implements PlausiRuntimeIterator {
    private Stack iteratorStack = new Stack();
    private PlausiRuntimeIterator currentIterator = null;
    private Value nextValue = NilValue.instance();
    private boolean hasNext = false;

    public void addIterator(PlausiRuntimeIterator anIterator) {
        if (this.currentIterator == null) {
            this.currentIterator = anIterator;
            this.hasNext = true;
            this.getNext();
        } else {
            this.iteratorStack.insertElementAt(anIterator, 0);
        }
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Value current = this.nextValue;
        this.getNext();
        return current;
    }

    @Override
    public Variable lastVariable() throws NoSuchElementException {
        assert (this.currentIterator != null);
        return this.currentIterator.lastVariable();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRestrictions(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PlausiRuntimeIterator duplicate() {
        if (this.currentIterator == null) {
            throw new IllegalStateException("Iterator kann nicht dupliziert werden.");
        }
        IteratorIterator theClone = new IteratorIterator();
        theClone.addIterator(this.currentIterator.duplicate());
        Iterator it = this.iteratorStack.iterator();
        while (it.hasNext()) {
            theClone.addIterator(((PlausiRuntimeIterator)it.next()).duplicate());
        }
        return theClone;
    }

    public void getNext() {
        if (this.currentIterator.hasNext()) {
            this.nextValue = (Value)this.currentIterator.next();
        } else if (!this.iteratorStack.empty()) {
            this.currentIterator = (PlausiRuntimeIterator)this.iteratorStack.pop();
            this.getNext();
        } else {
            this.hasNext = false;
        }
    }
}

