/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import org.python.util.PythonInterpreter;

public class RunTestDialog
extends JDialog
implements ActionListener,
Runnable {
    private Thread runner;
    private String testScript;
    private JTextArea textArea;
    private JPanel buttonPane;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");

    public RunTestDialog(JFrame frame, String testScript) {
        super((Frame)frame, true);
        this.setTitle("Running Test...");
        Dimension size = new Dimension(300, 200);
        this.setSize(size);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
            }
        });
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Courier", 0, 12));
        this.textArea.setLineWrap(false);
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new GridLayout(1, 2));
        this.buttonPane.add(this.cancelButton);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder());
        this.buttonPane.setBorder(border);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.testScript = testScript;
        this.runner = new Thread(this);
        this.runner.start();
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)this.buttonPane, "South");
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancelButton) {
            this.runner.stop();
            this.dispose();
        } else if (source == this.okButton) {
            this.dispose();
        }
    }

    public void run() {
        PythonInterpreter python = new PythonInterpreter();
        DialogWriter writer = new DialogWriter();
        python.setErr((Writer)writer);
        python.setOut((Writer)writer);
        try {
            python.exec(this.testScript);
            this.setTitle("Test Run Completed");
            this.textArea.setText("Test Run Successfully");
        }
        catch (Throwable e) {
            e.printStackTrace(new PrintWriter(writer));
            this.setTitle("Test Run Failed");
        }
        this.buttonPane.removeAll();
        this.buttonPane.add(this.okButton);
        this.buttonPane.validate();
    }

    class DialogWriter
    extends Writer {
        DialogWriter() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] cbuf, int off, int len) {
            RunTestDialog.this.textArea.append(new String(cbuf, off, len));
        }
    }
}

