/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.syslog;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.syslog.SyslogDefs;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.syslog.SyslogMessage;
import org.pentaho.di.trans.steps.syslog.SyslogMessageData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SyslogMessageMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SyslogMessageMeta.class;
    private String messagefieldname;
    private String serverName;
    private String port;
    private String facility;
    private String priority;
    private String datePattern;
    private boolean addTimestamp;
    private boolean addHostName;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        SyslogMessageMeta retval = (SyslogMessageMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.messagefieldname = null;
        this.port = String.valueOf(514);
        this.serverName = null;
        this.facility = SyslogDefs.FACILITYS[0];
        this.priority = SyslogDefs.PRIORITYS[0];
        this.datePattern = "MMM dd HH:mm:ss";
        this.addTimestamp = true;
        this.addHostName = true;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setMessageFieldName(String messagefieldname) {
        this.messagefieldname = messagefieldname;
    }

    public String getMessageFieldName() {
        return this.messagefieldname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void addTimestamp(boolean value) {
        this.addTimestamp = value;
    }

    public boolean isAddTimestamp() {
        return this.addTimestamp;
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void addHostName(boolean value) {
        this.addHostName = value;
    }

    public boolean isAddHostName() {
        return this.addHostName;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"messagefieldname", (String)this.messagefieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    " + XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("    " + XMLHandler.addTagValue((String)"facility", (String)this.facility));
        retval.append("    " + XMLHandler.addTagValue((String)"priority", (String)this.priority));
        retval.append("    " + XMLHandler.addTagValue((String)"addTimestamp", (boolean)this.addTimestamp));
        retval.append("    " + XMLHandler.addTagValue((String)"datePattern", (String)this.datePattern));
        retval.append("    " + XMLHandler.addTagValue((String)"addHostName", (boolean)this.addHostName));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.messagefieldname = XMLHandler.getTagValue((Node)stepnode, (String)"messagefieldname");
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)stepnode, (String)"servername");
            this.facility = XMLHandler.getTagValue((Node)stepnode, (String)"facility");
            this.priority = XMLHandler.getTagValue((Node)stepnode, (String)"priority");
            this.datePattern = XMLHandler.getTagValue((Node)stepnode, (String)"datePattern");
            this.addTimestamp = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addTimestamp"));
            this.addHostName = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addHostName"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SyslogMessageMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.messagefieldname = rep.getStepAttributeString(id_step, "messagefieldname");
            this.serverName = rep.getJobEntryAttributeString(id_step, "servername");
            this.port = rep.getJobEntryAttributeString(id_step, "port");
            this.facility = rep.getJobEntryAttributeString(id_step, "facility");
            this.priority = rep.getJobEntryAttributeString(id_step, "priority");
            this.datePattern = rep.getJobEntryAttributeString(id_step, "datePattern");
            this.addTimestamp = rep.getJobEntryAttributeBoolean(id_step, "addTimestamp");
            this.addHostName = rep.getJobEntryAttributeBoolean(id_step, "addHostName");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SyslogMessageMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "messagefieldname", this.messagefieldname);
            rep.saveJobEntryAttribute(id_transformation, id_step, "port", this.port);
            rep.saveJobEntryAttribute(id_transformation, id_step, "servername", this.serverName);
            rep.saveJobEntryAttribute(id_transformation, id_step, "facility", this.facility);
            rep.saveJobEntryAttribute(id_transformation, id_step, "priority", this.priority);
            rep.saveJobEntryAttribute(id_transformation, id_step, "datePattern", this.datePattern);
            rep.saveJobEntryAttribute(id_transformation, id_step, "addTimestamp", this.addTimestamp);
            rep.saveJobEntryAttribute(id_transformation, id_step, "addHostName", this.addHostName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SyslogMessageMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.messagefieldname)) {
            error_message = BaseMessages.getString(PKG, (String)"SyslogMessageMeta.CheckResult.MessageFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"SyslogMessageMeta.CheckResult.MessageFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SyslogMessageMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SyslogMessageMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SyslogMessage(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SyslogMessageData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

