/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sql;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sql.ExecSQL;
import org.pentaho.di.trans.steps.sql.ExecSQLData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ExecSQLMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ExecSQLMeta.class;
    private DatabaseMeta databaseMeta;
    private String sql;
    private boolean executedEachInputRow;
    private String[] arguments;
    private String updateField;
    private String insertField;
    private String deleteField;
    private String readField;
    private boolean singleStatement;
    private boolean replaceVariables;
    private boolean quoteString;
    private boolean setParams;

    public boolean isParams() {
        return this.setParams;
    }

    public void setParams(boolean value) {
        this.setParams = value;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public boolean isExecutedEachInputRow() {
        return this.executedEachInputRow;
    }

    public void setExecutedEachInputRow(boolean executedEachInputRow) {
        this.executedEachInputRow = executedEachInputRow;
    }

    public String getDeleteField() {
        return this.deleteField;
    }

    public void setDeleteField(String deleteField) {
        this.deleteField = deleteField;
    }

    public String getInsertField() {
        return this.insertField;
    }

    public void setInsertField(String insertField) {
        this.insertField = insertField;
    }

    public String getReadField() {
        return this.readField;
    }

    public void setReadField(String readField) {
        this.readField = readField;
    }

    public String getUpdateField() {
        return this.updateField;
    }

    public void setUpdateField(String updateField) {
        this.updateField = updateField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        ExecSQLMeta retval = (ExecSQLMeta)super.clone();
        return retval;
    }

    public void allocate(int nrargs) {
        this.arguments = new String[nrargs];
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String eachRow = XMLHandler.getTagValue((Node)stepnode, (String)"execute_each_row");
            this.executedEachInputRow = "Y".equalsIgnoreCase(eachRow);
            this.singleStatement = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"single_statement"));
            this.replaceVariables = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"replace_variables"));
            this.quoteString = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"quoteString"));
            this.setParams = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"set_params"));
            this.sql = XMLHandler.getTagValue((Node)stepnode, (String)"sql");
            this.insertField = XMLHandler.getTagValue((Node)stepnode, (String)"insert_field");
            this.updateField = XMLHandler.getTagValue((Node)stepnode, (String)"update_field");
            this.deleteField = XMLHandler.getTagValue((Node)stepnode, (String)"delete_field");
            this.readField = XMLHandler.getTagValue((Node)stepnode, (String)"read_field");
            Node argsnode = XMLHandler.getSubNode((Node)stepnode, (String)"arguments");
            int nrArguments = XMLHandler.countNodes((Node)argsnode, (String)"argument");
            this.allocate(nrArguments);
            for (int i = 0; i < nrArguments; ++i) {
                Node argnode = XMLHandler.getSubNodeByNr((Node)argsnode, (String)"argument", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)argnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ExecSQLMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.databaseMeta = null;
        this.sql = "";
        this.arguments = new String[0];
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        RowMetaAndData add = ExecSQL.getResultRow(new Result(), this.getUpdateField(), this.getInsertField(), this.getDeleteField(), this.getReadField());
        r.mergeRowMeta(add.getRowMeta());
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execute_each_row", (boolean)this.executedEachInputRow));
        retval.append("    ").append(XMLHandler.addTagValue((String)"single_statement", (boolean)this.singleStatement));
        retval.append("    ").append(XMLHandler.addTagValue((String)"replace_variables", (boolean)this.replaceVariables));
        retval.append("    ").append(XMLHandler.addTagValue((String)"quoteString", (boolean)this.quoteString));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    ").append(XMLHandler.addTagValue((String)"set_params", (boolean)this.setParams));
        retval.append("    ").append(XMLHandler.addTagValue((String)"insert_field", (String)this.insertField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"update_field", (String)this.updateField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"delete_field", (String)this.deleteField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_field", (String)this.readField));
        retval.append("    <arguments>").append(Const.CR);
        for (int i = 0; i < this.arguments.length; ++i) {
            retval.append("       <argument>").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i], (boolean)false, (String[])new String[0])).append("</argument>").append(Const.CR);
        }
        retval.append("    </arguments>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.executedEachInputRow = rep.getStepAttributeBoolean(id_step, "execute_each_row");
            this.singleStatement = rep.getStepAttributeBoolean(id_step, "single_statement");
            this.replaceVariables = rep.getStepAttributeBoolean(id_step, "replace_variables");
            this.quoteString = rep.getStepAttributeBoolean(id_step, "quoteString");
            this.sql = rep.getStepAttributeString(id_step, "sql");
            this.setParams = rep.getStepAttributeBoolean(id_step, "set_params");
            this.insertField = rep.getStepAttributeString(id_step, "insert_field");
            this.updateField = rep.getStepAttributeString(id_step, "update_field");
            this.deleteField = rep.getStepAttributeString(id_step, "delete_field");
            this.readField = rep.getStepAttributeString(id_step, "read_field");
            int nrargs = rep.countNrStepAttributes(id_step, "arg_name");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                this.arguments[i] = rep.getStepAttributeString(id_step, i, "arg_name");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ExecSQLMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "sql", this.sql);
            rep.saveStepAttribute(id_transformation, id_step, "execute_each_row", this.executedEachInputRow);
            rep.saveStepAttribute(id_transformation, id_step, "single_statement", this.singleStatement);
            rep.saveStepAttribute(id_transformation, id_step, "replace_variables", this.replaceVariables);
            rep.saveStepAttribute(id_transformation, id_step, "quoteString", this.quoteString);
            rep.saveStepAttribute(id_transformation, id_step, "set_params", this.setParams);
            rep.saveStepAttribute(id_transformation, id_step, "insert_field", this.insertField);
            rep.saveStepAttribute(id_transformation, id_step, "update_field", this.updateField);
            rep.saveStepAttribute(id_transformation, id_step, "delete_field", this.deleteField);
            rep.saveStepAttribute(id_transformation, id_step, "read_field", this.readField);
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
            for (int i = 0; i < this.arguments.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "arg_name", this.arguments[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ExecSQLMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.ConnectionExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.DBConnectionOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                if (this.sql != null && this.sql.length() != 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.SQLStatementEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.SQLStatementMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage(), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.ConnectionNeeded", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.executedEachInputRow) {
            if (input.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.StepReceivingInfoOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.SQLOnlyExecutedOnce", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSQLMeta.CheckResult.InputReceivedOKForSQLOnlyExecuteOnce", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExecSQL(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExecSQLData();
    }

    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMeta prev, String[] input, String[] output, RowMeta info) throws KettleStepException {
        DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), BaseMessages.getString(PKG, (String)"ExecSQLMeta.DatabaseMeta.Unknown.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSQLMeta.DatabaseMeta.Unknown2.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSQLMeta.DatabaseMeta.Unknown3.Label", (String[])new String[0]), stepMeta.getName(), this.sql, BaseMessages.getString(PKG, (String)"ExecSQLMeta.DatabaseMeta.Title", (String[])new String[0]));
        impact.add(ii);
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isReplaceVariables() {
        return this.replaceVariables;
    }

    public void setVariableReplacementActive(boolean variableReplacementActive) {
        this.replaceVariables = variableReplacementActive;
    }

    public boolean isQuoteString() {
        return this.quoteString;
    }

    public void setQuoteString(boolean quoteString) {
        this.quoteString = quoteString;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean isSingleStatement() {
        return this.singleStatement;
    }

    public void setSingleStatement(boolean singleStatement) {
        this.singleStatement = singleStatement;
    }
}

