/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.blockuntilstepsfinish;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.blockuntilstepsfinish.BlockUntilStepsFinish;
import org.pentaho.di.trans.steps.blockuntilstepsfinish.BlockUntilStepsFinishData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class BlockUntilStepsFinishMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = BlockUntilStepsFinishMeta.class;
    private String[] stepName;
    private String[] stepCopyNr;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        BlockUntilStepsFinishMeta retval = (BlockUntilStepsFinishMeta)super.clone();
        int nrfields = this.stepName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.stepName[i] = this.stepName[i];
            retval.stepCopyNr[i] = this.stepCopyNr[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.stepName = new String[nrfields];
        this.stepCopyNr = new String[nrfields];
    }

    public String[] getStepName() {
        return this.stepName;
    }

    public String[] getStepCopyNr() {
        return this.stepCopyNr;
    }

    public void setStepName(String[] stepName) {
        this.stepName = stepName;
    }

    public void setStepCopyNr(String[] stepCopyNr) {
        this.stepCopyNr = stepCopyNr;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node steps = XMLHandler.getSubNode((Node)stepnode, (String)"steps");
            int nrsteps = XMLHandler.countNodes((Node)steps, (String)"step");
            this.allocate(nrsteps);
            for (int i = 0; i < nrsteps; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)steps, (String)"step", (int)i);
                this.stepName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.stepCopyNr[i] = XMLHandler.getTagValue((Node)fnode, (String)"CopyNr");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    <steps>" + Const.CR);
        for (int i = 0; i < this.stepName.length; ++i) {
            retval.append("      <step>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.stepName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"CopyNr", (String)this.stepCopyNr[i]));
            retval.append("        </step>" + Const.CR);
        }
        retval.append("      </steps>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        int nrsteps = 0;
        this.allocate(nrsteps);
        for (int i = 0; i < nrsteps; ++i) {
            this.stepName[i] = "step" + i;
            this.stepCopyNr[i] = "CopyNr" + i;
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrsteps = rep.countNrStepAttributes(id_step, "step_name");
            this.allocate(nrsteps);
            for (int i = 0; i < nrsteps; ++i) {
                this.stepName[i] = rep.getStepAttributeString(id_step, i, "step_name");
                this.stepCopyNr[i] = rep.getStepAttributeString(id_step, i, "step_CopyNr");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.stepName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "step_name", this.stepName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "step_CopyNr", this.stepCopyNr[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = prev == null || prev.size() == 0 ? new CheckResult(3, BaseMessages.getString(PKG, (String)"BlockUntilStepsFinishMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : (this.stepName.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"BlockUntilStepsFinishMeta.CheckResult.AllStepsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(3, BaseMessages.getString(PKG, (String)"BlockUntilStepsFinishMeta.CheckResult.NoStepsEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta));
        remarks.add((CheckResultInterface)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"BlockUntilStepsFinishMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockUntilStepsFinishMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new BlockUntilStepsFinish(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new BlockUntilStepsFinishData();
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }
}

