/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PartitionerPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.Partitioner;
import org.w3c.dom.Node;

public class StepPartitioningMeta
implements XMLInterface,
Cloneable {
    public static final int PARTITIONING_METHOD_NONE = 0;
    public static final int PARTITIONING_METHOD_MIRROR = 1;
    public static final int PARTITIONING_METHOD_SPECIAL = 2;
    public static final String[] methodCodes = new String[]{"none", "Mirror"};
    public static final String[] methodDescriptions = new String[]{"None", "Mirror to all partitions"};
    private int methodType;
    private String method;
    private String partitionSchemaName;
    private PartitionSchema partitionSchema;
    private Partitioner partitioner;
    private boolean hasChanged = false;

    public StepPartitioningMeta() {
        this.method = "none";
        this.methodType = 0;
        this.partitionSchema = new PartitionSchema();
        this.hasChanged = false;
    }

    public StepPartitioningMeta(String method, PartitionSchema partitionSchema) throws KettlePluginException {
        this.setMethod(method);
        this.partitionSchema = partitionSchema;
        this.hasChanged = false;
    }

    public StepPartitioningMeta clone() {
        try {
            StepPartitioningMeta stepPartitioningMeta = new StepPartitioningMeta(this.method, this.partitionSchema != null ? (PartitionSchema)this.partitionSchema.clone() : null);
            stepPartitioningMeta.partitionSchemaName = this.partitionSchemaName;
            stepPartitioningMeta.setMethodType(this.methodType);
            stepPartitioningMeta.setPartitioner(this.partitioner == null ? null : this.partitioner.clone());
            return stepPartitioningMeta;
        }
        catch (KettlePluginException e) {
            throw new RuntimeException("Unable to load partitioning plugin", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.partitionSchemaName == null) {
            return false;
        }
        StepPartitioningMeta meta = (StepPartitioningMeta)obj;
        if (meta.partitionSchemaName == null) {
            return false;
        }
        return this.partitionSchemaName.equalsIgnoreCase(meta.partitionSchemaName);
    }

    public String toString() {
        String description = this.partitioner != null ? this.partitioner.getDescription() : this.getMethodDescription();
        if (this.partitionSchema != null) {
            description = description + " / " + this.partitionSchema.toString();
        }
        return description;
    }

    public int getMethodType() {
        return this.methodType;
    }

    public void setMethod(String method) throws KettlePluginException {
        if (!method.equals(this.method)) {
            this.method = method;
            this.createPartitioner(method);
            this.hasChanged = true;
        }
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(150);
        xml.append("         <partitioning>").append(Const.CR);
        xml.append("           ").append(XMLHandler.addTagValue((String)"method", (String)this.getMethodCode()));
        xml.append("           ").append(XMLHandler.addTagValue((String)"schema_name", (String)(this.partitionSchema != null ? this.partitionSchema.getName() : "")));
        if (this.partitioner != null) {
            xml.append(this.partitioner.getXML());
        }
        xml.append("           </partitioning>").append(Const.CR);
        return xml.toString();
    }

    public StepPartitioningMeta(Node partitioningMethodNode) throws KettleException {
        this();
        this.setMethod(StepPartitioningMeta.getMethod(XMLHandler.getTagValue((Node)partitioningMethodNode, (String)"method")));
        this.partitionSchemaName = XMLHandler.getTagValue((Node)partitioningMethodNode, (String)"schema_name");
        this.hasChanged = false;
        if (this.partitioner != null) {
            this.partitioner.loadXML(partitioningMethodNode);
        }
    }

    public String getMethodCode() {
        if (this.methodType == 2) {
            if (this.partitioner != null) {
                return this.partitioner.getId();
            }
            return methodCodes[0];
        }
        return methodCodes[this.methodType];
    }

    public String getMethodDescription() {
        if (this.methodType != 2) {
            return methodDescriptions[this.methodType];
        }
        return this.partitioner.getDescription();
    }

    public String getMethod() {
        return this.method;
    }

    public static final String getMethod(String name) {
        int i;
        if (Const.isEmpty((String)name)) {
            return methodCodes[0];
        }
        for (i = 0; i < methodDescriptions.length; ++i) {
            if (!methodDescriptions[i].equalsIgnoreCase(name)) continue;
            return methodCodes[i];
        }
        for (i = 0; i < methodCodes.length; ++i) {
            if (!methodCodes[i].equalsIgnoreCase(name)) continue;
            return methodCodes[i];
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.findPluginWithName(PartitionerPluginType.class, name);
        if (plugin != null) {
            return name;
        }
        plugin = registry.findPluginWithId(PartitionerPluginType.class, name);
        if (plugin != null) {
            return name;
        }
        return methodCodes[0];
    }

    public static final int getMethodType(String description) {
        int i;
        for (i = 0; i < methodDescriptions.length; ++i) {
            if (!methodDescriptions[i].equalsIgnoreCase(description)) continue;
            return i;
        }
        for (i = 0; i < methodCodes.length; ++i) {
            if (!methodCodes[i].equalsIgnoreCase(description)) continue;
            return i;
        }
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(PartitionerPluginType.class, description);
        if (plugin != null) {
            return 2;
        }
        return 0;
    }

    public boolean isPartitioned() {
        return this.methodType != 0;
    }

    public void setPartitionSchemaName(String partitionSchemaName) {
        this.partitionSchemaName = partitionSchemaName;
    }

    public PartitionSchema getPartitionSchema() {
        return this.partitionSchema;
    }

    public void setPartitionSchema(PartitionSchema partitionSchema) {
        this.partitionSchema = partitionSchema;
        this.hasChanged = true;
    }

    public void setPartitionSchemaAfterLoading(List<PartitionSchema> partitionSchemas) throws KettleException {
        this.partitionSchema = null;
        for (int i = 0; i < partitionSchemas.size() && this.partitionSchema == null; ++i) {
            PartitionSchema schema = partitionSchemas.get(i);
            if (!schema.getName().equalsIgnoreCase(this.partitionSchemaName)) continue;
            this.partitionSchema = schema;
        }
    }

    public void createPartitioner(String method) throws KettlePluginException {
        this.methodType = StepPartitioningMeta.getMethodType(method);
        switch (this.methodType) {
            case 2: {
                PluginRegistry registry = PluginRegistry.getInstance();
                PluginInterface plugin = registry.findPluginWithId(PartitionerPluginType.class, method);
                this.partitioner = (Partitioner)registry.loadClass(plugin);
                this.partitioner.setId(plugin.getIds()[0]);
                break;
            }
            default: {
                this.partitioner = null;
            }
        }
        if (this.partitioner != null) {
            this.partitioner.setMeta(this);
        }
    }

    public boolean isMethodMirror() {
        return this.methodType == 1;
    }

    public int getPartition(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        if (this.partitioner != null) {
            return this.partitioner.getPartition(rowMeta, row);
        }
        return 0;
    }

    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void hasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public void setMethodType(int methodType) {
        this.methodType = methodType;
    }
}

