/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.special;

import java.util.Calendar;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntrySpecial
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public static final int NOSCHEDULING = 0;
    public static final int INTERVAL = 1;
    public static final int DAILY = 2;
    public static final int WEEKLY = 3;
    public static final int MONTHLY = 4;
    private boolean start;
    private boolean dummy;
    private boolean repeat = false;
    private int schedulerType = 0;
    private int intervalSeconds = 0;
    private int intervalMinutes = 60;
    private int dayOfMonth = 1;
    private int weekDay = 1;
    private int minutes = 0;
    private int hour = 12;

    public JobEntrySpecial() {
        this(null, false, false);
    }

    public JobEntrySpecial(String name, boolean start, boolean dummy) {
        super(name, "");
        this.start = start;
        this.dummy = dummy;
    }

    @Override
    public Object clone() {
        JobEntrySpecial je = (JobEntrySpecial)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"start", (boolean)this.start));
        retval.append("      ").append(XMLHandler.addTagValue((String)"dummy", (boolean)this.dummy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.repeat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schedulerType", (int)this.schedulerType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"intervalSeconds", (int)this.intervalSeconds));
        retval.append("      ").append(XMLHandler.addTagValue((String)"intervalMinutes", (int)this.intervalMinutes));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hour", (int)this.hour));
        retval.append("      ").append(XMLHandler.addTagValue((String)"minutes", (int)this.minutes));
        retval.append("      ").append(XMLHandler.addTagValue((String)"weekDay", (int)this.weekDay));
        retval.append("      ").append(XMLHandler.addTagValue((String)"DayOfMonth", (int)this.dayOfMonth));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.start = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"start"));
            this.dummy = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"dummy"));
            this.repeat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"repeat"));
            this.setSchedulerType(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"schedulerType"), (int)0));
            this.setIntervalSeconds(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"intervalSeconds"), (int)0));
            this.setIntervalMinutes(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"intervalMinutes"), (int)0));
            this.setHour(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"hour"), (int)0));
            this.setMinutes(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"minutes"), (int)0));
            this.setWeekDay(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"weekDay"), (int)0));
            this.setDayOfMonth(Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"dayOfMonth"), (int)0));
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'special' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.start = rep.getJobEntryAttributeBoolean(id_jobentry, "start");
            this.dummy = rep.getJobEntryAttributeBoolean(id_jobentry, "dummy");
            this.repeat = rep.getJobEntryAttributeBoolean(id_jobentry, "repeat");
            this.schedulerType = (int)rep.getJobEntryAttributeInteger(id_jobentry, "schedulerType");
            this.intervalSeconds = (int)rep.getJobEntryAttributeInteger(id_jobentry, "intervalSeconds");
            this.intervalMinutes = (int)rep.getJobEntryAttributeInteger(id_jobentry, "intervalMinutes");
            this.hour = (int)rep.getJobEntryAttributeInteger(id_jobentry, "hour");
            this.minutes = (int)rep.getJobEntryAttributeInteger(id_jobentry, "minutes");
            this.weekDay = (int)rep.getJobEntryAttributeInteger(id_jobentry, "weekDay");
            this.dayOfMonth = (int)rep.getJobEntryAttributeInteger(id_jobentry, "dayOfMonth");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'special' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "start", this.start);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "dummy", this.dummy);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "repeat", this.repeat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "schedulerType", this.schedulerType);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "intervalSeconds", this.intervalSeconds);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "intervalMinutes", this.intervalMinutes);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hour", this.hour);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "minutes", this.minutes);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "weekDay", this.weekDay);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "dayOfMonth", this.dayOfMonth);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'special' to the repository with id_job=" + id_job, (Throwable)dbe);
        }
    }

    @Override
    public boolean isStart() {
        return this.start;
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public Result execute(Result previousResult, int nr) throws KettleJobException {
        Result result = previousResult;
        if (this.isStart()) {
            try {
                long sleepTime = this.getNextExecutionTime();
                if (sleepTime > 0L) {
                    this.parentJob.getLogChannel().logBasic(this.parentJob.getJobname(), new Object[]{"Sleeping: " + sleepTime / 1000L / 60L + " minutes (sleep time=" + sleepTime + ")"});
                    for (long totalSleep = 0L; totalSleep < sleepTime && !this.parentJob.isStopped(); totalSleep += 1000L) {
                        Thread.sleep(1000L);
                    }
                }
            }
            catch (InterruptedException e) {
                throw new KettleJobException((Throwable)e);
            }
            result = previousResult;
            result.setResult(true);
        } else if (this.isDummy()) {
            result = previousResult;
        }
        return result;
    }

    private long getNextExecutionTime() {
        switch (this.schedulerType) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this.getNextIntervalExecutionTime();
            }
            case 2: {
                return this.getNextDailyExecutionTime();
            }
            case 3: {
                return this.getNextWeeklyExecutionTime();
            }
            case 4: {
                return this.getNextMonthlyExecutionTime();
            }
        }
        return 0L;
    }

    private long getNextIntervalExecutionTime() {
        return this.intervalSeconds * 1000 + this.intervalMinutes * 1000 * 60;
    }

    private long getNextMonthlyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = this.hour;
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, this.minutes);
        calendar.set(5, this.dayOfMonth);
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(2, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    private long getNextWeeklyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = this.hour;
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, this.minutes);
        calendar.set(7, this.weekDay + 1);
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(3, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    private long getNextDailyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = this.hour;
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, this.minutes);
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(5, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    @Override
    public boolean evaluates() {
        return false;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    public int getSchedulerType() {
        return this.schedulerType;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getWeekDay() {
        return this.weekDay;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setWeekDay(int weekDay) {
        this.weekDay = weekDay;
    }

    public void setSchedulerType(int schedulerType) {
        this.schedulerType = schedulerType;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public void setIntervalSeconds(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public int getIntervalMinutes() {
        return this.intervalMinutes;
    }

    public void setIntervalMinutes(int intervalMinutes) {
        this.intervalMinutes = intervalMinutes;
    }

    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
    }
}

