/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.filesexist;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryFilesExist
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFilesExist.class;
    private String filename = null;
    public String[] arguments;

    public JobEntryFilesExist(String n) {
        super(n, "");
    }

    public JobEntryFilesExist() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFilesExist je = (JobEntryFilesExist)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryFilesExist.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", (String[])new String[]{xe.getMessage()}));
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryFilesExist.ERROR_0002_Cannot_Load_Job_From_Repository", (String[])new String[]{"" + id_jobentry, dbe.getMessage()}));
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "name", this.arguments[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryFilesExist.ERROR_0003_Cannot_Save_Job_Entry", (String[])new String[]{"" + id_job, dbe.getMessage()}));
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(0L);
        int missingfiles = 0;
        int nrErrors = 0;
        boolean oldBehavior = "Y".equalsIgnoreCase(this.getVariable("KETTLE_COMPATIBILITY_SET_ERROR_ON_SPECIFIC_JOB_ENTRIES", "N"));
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !this.parentJob.isStopped(); ++i) {
                FileObject file = null;
                try {
                    String realFilefoldername = this.environmentSubstitute(this.arguments[i]);
                    file = KettleVFS.getFileObject((String)realFilefoldername, (VariableSpace)this);
                    if (file.exists() && file.isReadable()) {
                        if (!this.log.isDetailed()) continue;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFilesExist.File_Exists", (String[])new String[]{realFilefoldername}));
                        continue;
                    }
                    ++missingfiles;
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFilesExist.File_Does_Not_Exist", (String[])new String[]{realFilefoldername}));
                    continue;
                }
                catch (Exception e) {
                    ++nrErrors;
                    ++missingfiles;
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFilesExist.ERROR_0004_IO_Exception", (String[])new String[]{e.toString()}), e);
                    continue;
                }
                finally {
                    if (file != null) {
                        try {
                            file.close();
                            file = null;
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        result.setNrErrors((long)nrErrors);
        if (oldBehavior) {
            result.setNrErrors((long)missingfiles);
        }
        if (missingfiles == 0) {
            result.setResult(true);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
    }
}

