/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.deletefolders;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryDeleteFolders
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryDeleteFolders.class;
    public boolean argFromPrevious = false;
    public String[] arguments = null;
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    public String SUCCESS_IF_AT_LEAST_X_FOLDERS_DELETED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String limit_folders = "10";
    int NrErrors = 0;
    int NrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFolders = 0;

    public JobEntryDeleteFolders(String n) {
        super(n, "");
    }

    public JobEntryDeleteFolders() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryDeleteFolders je = (JobEntryDeleteFolders)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"limit_folders", (String)this.limit_folders));
        retval.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.arguments[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.limit_folders = XMLHandler.getTagValue((Node)entrynode, (String)"limit_folders");
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.arguments = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.limit_folders = rep.getJobEntryAttributeString(id_jobentry, "limit_folders");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "name");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "name");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.UnableToLoadFromRepo", (String[])new String[]{String.valueOf(id_jobentry)}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "limit_folders", this.limit_folders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "name", this.arguments[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.UnableToSaveToRepo", (String[])new String[]{String.valueOf(id_job)}), (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result result, int nr) throws KettleException {
        List rows = result.getRows();
        result.setNrErrors(1L);
        result.setResult(false);
        this.NrErrors = 0;
        this.NrSuccess = 0;
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        this.limitFolders = Const.toInt((String)this.environmentSubstitute(this.getLimitFolders()), (int)10);
        if (this.argFromPrevious && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
        }
        if (this.argFromPrevious && rows != null) {
            for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                    result.setNrErrors((long)this.NrErrors);
                    result.setNrLinesDeleted((long)this.NrSuccess);
                    return result;
                }
                RowMetaAndData resultRow = (RowMetaAndData)rows.get(iteration);
                String args_previous = resultRow.getString(0, null);
                if (!Const.isEmpty((String)args_previous)) {
                    if (this.deleteFolder(args_previous)) {
                        this.updateSuccess();
                        continue;
                    }
                    this.updateErrors();
                    continue;
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.Error.EmptyLine", (String[])new String[0]));
            }
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length && !this.parentJob.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                    result.setNrErrors((long)this.NrErrors);
                    result.setNrLinesDeleted((long)this.NrSuccess);
                    return result;
                }
                String realfilename = this.environmentSubstitute(this.arguments[i]);
                if (!Const.isEmpty((String)realfilename)) {
                    if (this.deleteFolder(realfilename)) {
                        this.updateSuccess();
                        continue;
                    }
                    this.updateErrors();
                    continue;
                }
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.Error.EmptyLine", (String[])new String[0]));
            }
        }
        if (this.log.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.Log.Info.NrError", (String[])new String[]{"" + this.NrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.Log.Info.NrDeletedFolders", (String[])new String[]{"" + this.NrSuccess}));
            this.logDetailed("=======================================");
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesDeleted((long)this.NrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        return result;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFolders && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateSuccess() {
        ++this.NrSuccess;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFolders && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FOLDERS_DELETED) || this.NrErrors <= this.limitFolders && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteFolder(String foldername) {
        boolean rcode = false;
        FileObject filefolder = null;
        try {
            filefolder = KettleVFS.getFileObject((String)foldername, (VariableSpace)this);
            if (filefolder.exists()) {
                if (filefolder.getType() == FileType.FOLDER) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.ProcessingFolder", (String[])new String[]{foldername}));
                    }
                    int Nr = filefolder.delete((FileSelector)new TextFileSelector());
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.TotalDeleted", (String[])new String[]{foldername, String.valueOf(Nr)}));
                    }
                    rcode = true;
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.Error.NotFolder", (String[])new String[0]));
                }
            } else {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.FolderAlreadyDeleted", (String[])new String[]{foldername}));
                }
                rcode = true;
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryDeleteFolders.CouldNotDelete", (String[])new String[]{foldername, e.getMessage()}), e);
        }
        finally {
            if (filefolder != null) {
                try {
                    filefolder.close();
                }
                catch (IOException ex) {}
            }
        }
        return rcode;
    }

    public void setPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.arguments.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.arguments != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.arguments.length; ++i) {
                String filename = jobMeta.environmentSubstitute(this.arguments[i]);
                if (reference == null) {
                    reference = new ResourceReference(this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setLimitFolders(String limit_folders) {
        this.limit_folders = limit_folders;
    }

    public String getLimitFolders() {
        return this.limit_folders;
    }

    private class TextFileSelector
    implements FileSelector {
        private TextFileSelector() {
        }

        public boolean includeFile(FileSelectInfo info) {
            return true;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

