/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.database.PostgreSQLDatabaseMeta;

public class RedshiftDatabaseMeta
extends PostgreSQLDatabaseMeta {
    public RedshiftDatabaseMeta() {
        this.addExtraOption("REDSHIFT", "tcpKeepAlive", "true");
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 5439;
        }
        return -1;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.amazon.redshift.jdbc4.Driver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        return "jdbc:redshift://" + hostname + ":" + port + "/" + databaseName;
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "http://docs.aws.amazon.com/redshift/latest/mgmt/configure-jdbc-connection.html";
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public boolean supportsSetMaxRows() {
        return false;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"RedshiftJDBC4_1.0.10.1010.jar"};
    }
}

