/*
 * Decompiled with CFR 0.152.
 */
package javax.help;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class SwingHelpUtilities
implements PropertyChangeListener {
    private static UIDefaults uiDefaults = null;
    private static SwingHelpUtilities myLAFListener = new SwingHelpUtilities();
    static Object basicOnItemCursor;
    private static final boolean debug = false;
    static /* synthetic */ Class class$javax$help$HelpUtilities;

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("lookAndFeel")) {
            SwingHelpUtilities.installLookAndFeelDefaults();
        }
    }

    static void installUIDefaults() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        if (uiDefaults != uIDefaults) {
            uiDefaults = uIDefaults;
            UIManager.removePropertyChangeListener(myLAFListener);
            SwingHelpUtilities.installLookAndFeelDefaults();
            UIManager.addPropertyChangeListener(myLAFListener);
        }
    }

    static void installLookAndFeelDefaults() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        SwingHelpUtilities.debug("installLookAndFeelDefaults - " + lookAndFeel);
        if (lookAndFeel != null && uIDefaults != null) {
            if (lookAndFeel.getID().equals("Motif")) {
                SwingHelpUtilities.installMotifDefaults(uIDefaults);
            } else if (lookAndFeel.getID().equals("Windows")) {
                SwingHelpUtilities.installWindowsDefaults(uIDefaults);
            } else {
                SwingHelpUtilities.installMetalDefaults(uIDefaults);
            }
        }
        SwingHelpUtilities.debug("verifing UIDefaults; HelpUI=" + uIDefaults.getString("HelpUI"));
    }

    private static Object createIcon(String string, String string2) {
        ClassLoader classLoader = (class$javax$help$HelpUtilities == null ? (class$javax$help$HelpUtilities = SwingHelpUtilities.class$("javax.help.HelpUtilities")) : class$javax$help$HelpUtilities).getClassLoader();
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            Method method = clazz.getMethod(string2, classArray);
            Object object = method.invoke(null, objectArray);
            return object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void installBasicDefaults(UIDefaults uIDefaults) {
        String string = "javax.help.plaf.basic.";
        Object[] objectArray = new Object[]{"HelpUI", string + "BasicHelpUI", "HelpTOCNavigatorUI", string + "BasicTOCNavigatorUI", "HelpIndexNavigatorUI", string + "BasicIndexNavigatorUI", "HelpSearchNavigatorUI", string + "BasicSearchNavigatorUI", "HelpContentViewerUI", string + "BasicContentViewerUI", "HelpOnItemCursor", basicOnItemCursor};
        uIDefaults.putDefaults(objectArray);
    }

    private static void installMetalDefaults(UIDefaults uIDefaults) {
        SwingHelpUtilities.installBasicDefaults(uIDefaults);
    }

    private static void installWindowsDefaults(UIDefaults uIDefaults) {
        SwingHelpUtilities.installBasicDefaults(uIDefaults);
    }

    private static void installMotifDefaults(UIDefaults uIDefaults) {
        SwingHelpUtilities.installBasicDefaults(uIDefaults);
    }

    public static ImageIcon getImageIcon(Class clazz, String string) {
        if (string == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[1][];
        try {
            int n;
            InputStream inputStream = clazz.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byArrayArray[0] = new byte[1024];
            while ((n = bufferedInputStream.read(byArrayArray[0])) > 0) {
                byteArrayOutputStream.write(byArrayArray[0], 0, n);
            }
            bufferedInputStream.close();
            byteArrayOutputStream.flush();
            byArrayArray[0] = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return null;
        }
        if (byArrayArray[0] == null) {
            System.err.println(clazz.getName() + "/" + string + " not found.");
            return null;
        }
        if (byArrayArray[0].length == 0) {
            System.err.println("warning: " + string + " is zero-length");
            return null;
        }
        return new ImageIcon(byArrayArray[0]);
    }

    private static void debug(Object object) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SwingHelpUtilities.installUIDefaults();
        basicOnItemCursor = new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults uIDefaults) {
                return SwingHelpUtilities.createIcon("javax.help.plaf.basic.BasicCursorFactory", "getOnItemCursor");
            }
        };
    }
}

