/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;

public class HsqlDateTime {
    private static Calendar today = new GregorianCalendar();
    private static Calendar tempCalDefault = new GregorianCalendar();
    private static Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static java.sql.Date tempDate = new java.sql.Date(0L);
    private static java.sql.Date currentDate;
    static final String zerodatetime = "1970-01-01 00:00:00.000000000";
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    static SimpleDateFormat sdfd;
    static SimpleDateFormat sdft;
    static SimpleDateFormat sdfts;

    public static Timestamp timestampValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        string = string + zerodatetime.substring(string.length());
        return Timestamp.valueOf(string);
    }

    public static Timestamp timestampValue(long l, int n) {
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(n);
        return timestamp;
    }

    public static java.sql.Date dateValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(133));
        }
        if (string.length() > sdfdPattern.length()) {
            return java.sql.Date.valueOf(string.substring(0, sdfdPattern.length()));
        }
        return java.sql.Date.valueOf(string);
    }

    public static Time timeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        return Time.valueOf(string);
    }

    static int compare(Time time, Time time2) throws HsqlException {
        if (time.getTime() == time2.getTime()) {
            return 0;
        }
        return time.getTime() > time2.getTime() ? 1 : -1;
    }

    public static synchronized java.sql.Date getCurrentDate(long l) {
        HsqlDateTime.getToday(l);
        return currentDate;
    }

    public static Timestamp getTimestamp(long l) {
        return new Timestamp(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static java.sql.Date getDate(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(calendar);
            Date date = sdfd.parse(string);
            return new java.sql.Date(date.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Time getTime(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(calendar);
            Date date = sdft.parse(string);
            return new Time(date.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Timestamp getTimestamp(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(calendar);
            Date date = sdfts.parse(string.substring(0, sdftsPattern.length()));
            String string2 = string.substring(sdftsPattern.length(), string.length());
            Timestamp timestamp = new Timestamp(date.getTime());
            timestamp.setNanos(Integer.parseInt(string2));
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(Timestamp timestamp, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(calendar == null ? tempCalDefault : calendar);
            String string = sdfts.format(new Date(timestamp.getTime())) + timestamp.getNanos();
            return string + zerodatetime.substring(string.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeString(Time time, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(calendar == null ? tempCalDefault : calendar);
            return sdft.format(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(java.sql.Date date, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(calendar == null ? tempCalDefault : calendar);
            return sdfd.format(date);
        }
    }

    static synchronized Calendar getToday(long l) {
        if (l - HsqlDateTime.getTimeInMillis(today) >= 86400000L) {
            HsqlDateTime.resetToday(l);
        }
        return today;
    }

    public static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void resetToTime(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
    }

    private static synchronized void resetToday(long l) {
        today.setTimeInMillis(l);
        HsqlDateTime.resetToDate(today);
        currentDate = new java.sql.Date(HsqlDateTime.getTimeInMillis(today));
    }

    private static void setTimeInMillis(Calendar calendar, long l) {
        calendar.setTimeInMillis(l);
    }

    public static long getTimeInMillis(Calendar calendar) {
        return calendar.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time getNormalisedTime(long l) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, l);
            HsqlDateTime.resetToTime(tempCalDefault);
            long l2 = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new Time(l2);
        }
    }

    public static Time getNormalisedTime(Time time) {
        return HsqlDateTime.getNormalisedTime(time.getTime());
    }

    public static Time getNormalisedTime(Timestamp timestamp) {
        return HsqlDateTime.getNormalisedTime(timestamp.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long l) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, l);
            HsqlDateTime.resetToDate(tempCalDefault);
            return HsqlDateTime.getTimeInMillis(tempCalDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date getNormalisedDate(Timestamp timestamp) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, timestamp.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new java.sql.Date(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date getNormalisedDate(java.sql.Date date) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, date.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new java.sql.Date(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getNormalisedTimestamp(Time time) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalGMT, System.currentTimeMillis());
            HsqlDateTime.resetToDate(tempCalGMT);
            long l = HsqlDateTime.getTimeInMillis(tempCalGMT) + time.getTime();
            return new Timestamp(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getNormalisedTimestamp(java.sql.Date date) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, date.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new Timestamp(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDateTimePart(Date date, int n) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            tempCalDefault.setTime(date);
            return tempCalDefault.get(n);
        }
    }

    static {
        HsqlDateTime.resetToday(System.currentTimeMillis());
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
    }
}

