/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import de.his.tools.StringUtil;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class PropUtil {
    private static Logger logger = Logger.getLogger(PropUtil.class);

    public static Properties xmlToProperties(Element element) {
        Properties prop = new Properties();
        if (element != null) {
            List children = element.getChildren();
            for (Element e : children) {
                String key = e.getName();
                String value = e.getText().trim();
                if (value.length() == 0 && e.getChildren().size() != 0) continue;
                prop.put(key, value);
            }
        }
        return prop;
    }

    public static void putIgnoreNull(Properties prop, String key, Object value) {
        if (prop != null) {
            if (key != null) {
                if (value != null) {
                    prop.put(key, value);
                } else {
                    logger.debug((Object)("Value for key " + key + " is null"));
                }
            } else {
                logger.warn((Object)"Key is null!");
            }
        } else {
            logger.warn((Object)"Properties is null!");
        }
    }

    public static Properties encodeURL(Properties orgProp) {
        return PropUtil.encodeURL(orgProp, null);
    }

    public static Properties encodeURL(Properties orgProp, String charset) {
        Properties prop = (Properties)orgProp.clone();
        String prefix = "url:";
        for (Object key : orgProp.keySet()) {
            String val;
            String strKey = (String)key;
            if (strKey.startsWith(prefix) || (val = prop.getProperty(strKey)) == null) continue;
            prop.put(prefix + strKey, StringUtil.encodeURL(val, charset));
        }
        return prop;
    }

    public static Properties argsubst(Properties rules, Properties data) {
        Properties res = new Properties();
        for (Object key : rules.keySet()) {
            String strKey = (String)key;
            res.put(key, StringUtil.argsubst(rules.getProperty(strKey), data));
        }
        return res;
    }

    public static Properties filterProperties(Properties prop, String accept, boolean reverse) {
        String[] filter = StringUtil.stringToArray(accept);
        return PropUtil.filterProperties(prop, filter, reverse);
    }

    public static Properties filterProperties(Properties prop, String[] filter, boolean reverse) {
        Properties temp = new Properties();
        String match = null;
        if (prop != null && filter != null) {
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                String key = entry.getKey().toString();
                boolean found = false;
                for (int i = 0; i < filter.length; ++i) {
                    if (filter[i].endsWith("*")) {
                        match = filter[i].substring(0, filter[i].length() - 1);
                        if (!key.startsWith(match)) continue;
                        found = true;
                        continue;
                    }
                    if (filter[i].startsWith("*")) {
                        match = filter[i].substring(1);
                        if (!key.endsWith(match)) continue;
                        found = true;
                        continue;
                    }
                    if (!filter[i].equals(key)) continue;
                    found = true;
                }
                if (reverse) {
                    if (found) continue;
                    temp.put(key, entry.getValue());
                    continue;
                }
                if (!found) continue;
                temp.put(key, entry.getValue());
            }
        }
        return temp;
    }

    public static void printProperties(String propsLabel, Properties props) {
        if (propsLabel == null) {
            return;
        }
        if (props == null) {
            return;
        }
        if (!logger.isDebugEnabled()) {
            return;
        }
        StringBuilder builder = new StringBuilder("Properties " + propsLabel + " = {");
        String indent = "    ";
        if (props.size() > 0) {
            Enumeration<?> propNames = props.propertyNames();
            String innerIndent = "        ";
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                builder.append("\n        " + propName + "=" + propValue);
            }
        }
        builder.append("\n    }");
        logger.debug((Object)builder.toString());
    }
}

