/*
 * Decompiled with CFR 0.152.
 */
package de.his.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HttpClient {
    private static final Logger logger = Logger.getLogger(HttpClient.class);
    private final String urlString;
    private HttpURLConnection connection;
    private InputStream is;
    private ProgressListener progressListener;
    private final int timeout = 1500;
    private boolean tryVeryHard;
    private String contentType;

    public HttpClient(String url) {
        this.urlString = url;
    }

    public HttpClient(String url, boolean tryVeryHard) {
        this.urlString = url;
        this.tryVeryHard = tryVeryHard;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    private void openInputStream() {
        try {
            URL url = new URL(this.urlString);
            int retryCount = 0;
            int myTimeout = 1500;
            while (this.is == null) {
                ++retryCount;
                try {
                    this.connection = (HttpURLConnection)url.openConnection();
                    this.connection.setInstanceFollowRedirects(true);
                    this.connection.setConnectTimeout(1500);
                    if (this.connection.getResponseCode() != 200) {
                        logger.error((Object)("HttpServer returned an error code (" + this.urlString + "): " + this.connection.getResponseCode()));
                        this.connection = null;
                    }
                    if (this.connection != null) {
                        this.is = this.connection.getInputStream();
                        if (retryCount > 1) {
                            logger.info((Object)"Retry successful");
                        }
                    }
                }
                catch (SocketTimeoutException e) {
                    logger.error((Object)("Timeout (" + this.urlString + "): " + " " + e.toString()));
                }
                myTimeout *= 2;
                if (this.tryVeryHard && retryCount <= 3) continue;
            }
            if (this.connection != null) {
                this.contentType = this.connection.getHeaderField("Content-Type");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error connecting to http-Server (" + this.urlString + "): "), (Throwable)e);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        this.openInputStream();
        return this.is;
    }

    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    public String fetchFirstLine() {
        String line = null;
        try {
            this.openInputStream();
            if (this.is == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
            line = br.readLine();
            br.close();
            this.connection.disconnect();
        }
        catch (Exception e) {
            logger.error((Object)"Error connecting to http-Server: ", (Throwable)e);
        }
        return line;
    }

    public Properties fetchProperties() {
        Properties prop = null;
        this.openInputStream();
        if (this.is == null) {
            return prop;
        }
        try {
            prop = new Properties();
            prop.load(this.is);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.close();
        return prop;
    }

    public boolean fetchFile(String filename) {
        boolean res = false;
        this.openInputStream();
        if (this.is == null) {
            return res;
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(filename));
            this.copyStream(this.is, os);
            this.connection.disconnect();
            res = true;
        }
        catch (Exception e) {
            res = false;
            logger.error((Object)e, (Throwable)e);
        }
        return res;
    }

    public String fetchString() {
        this.openInputStream();
        if (this.is == null) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.copyStream(this.is, os);
            this.connection.disconnect();
            return os.toString();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int length;
        byte[] buffer = new byte[10240];
        int byteCounter = length = inputStream.read(buffer);
        while (length > -1) {
            outputStream.write(buffer, 0, length);
            length = inputStream.read(buffer);
            if (length <= 0) continue;
            byteCounter += length;
            if (this.progressListener == null) continue;
            this.progressListener.onDownloading(byteCounter);
        }
        inputStream.close();
        outputStream.close();
        if (this.progressListener != null) {
            this.progressListener.onDownloadCompleted(byteCounter);
        }
    }

    private String extractCookieFromHeaderValue(String headerValue) {
        if (headerValue == null) {
            return null;
        }
        String res = headerValue;
        int pos = headerValue.indexOf(";");
        if (pos > -1) {
            res = headerValue.substring(0, pos);
        }
        return res;
    }

    public String getCookie(String cookie) {
        List<String> headers = this.connection.getHeaderFields().get("Set-Cookie");
        if (headers == null) {
            return null;
        }
        for (String header : headers) {
            String cookieString = this.extractCookieFromHeaderValue(header);
            if (!cookieString.toLowerCase(Locale.ENGLISH).startsWith(cookie.toLowerCase(Locale.ENGLISH) + "=")) continue;
            return cookieString.substring(cookieString.indexOf("=") + 1);
        }
        return null;
    }

    public static interface ProgressListener {
        public void onDownloading(int var1);

        public void onDownloadCompleted(int var1);
    }
}

