/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.commons.validator.Var;
import org.dbforms.config.DbFormsErrors;
import org.dbforms.util.MessageResources;
import org.dbforms.util.Util;

public class DbFormsValidatorUtil {
    static Log logCat = LogFactory.getLog((String)(class$org$dbforms$validation$DbFormsValidatorUtil == null ? (class$org$dbforms$validation$DbFormsValidatorUtil = DbFormsValidatorUtil.class$("org.dbforms.validation.DbFormsValidatorUtil")) : class$org$dbforms$validation$DbFormsValidatorUtil).getName());
    static /* synthetic */ Class class$org$dbforms$validation$DbFormsValidatorUtil;

    public static String[] getArgs(String actionName, Locale locale, Field field) {
        Arg arg0 = field.getArg0(actionName);
        Arg arg1 = field.getArg1(actionName);
        Arg arg2 = field.getArg2(actionName);
        Arg arg3 = field.getArg3(actionName);
        String sArg0 = null;
        String sArg1 = null;
        String sArg2 = null;
        String sArg3 = null;
        if (arg0 != null) {
            if (arg0.getResource()) {
                sArg0 = MessageResources.getMessage(arg0.getKey(), locale);
                if (sArg0 == null) {
                    sArg0 = arg0.getKey();
                }
            } else {
                sArg0 = arg0.getKey();
            }
        } else {
            sArg0 = field.getKey();
        }
        if (arg1 != null) {
            if (arg1.getResource()) {
                sArg1 = MessageResources.getMessage(arg1.getKey(), locale);
                if (sArg1 == null) {
                    sArg1 = arg1.getKey();
                }
            } else {
                sArg1 = arg1.getKey();
            }
        }
        if (arg2 != null) {
            if (arg2.getResource()) {
                sArg2 = MessageResources.getMessage(arg2.getKey(), locale);
                if (sArg2 == null) {
                    sArg2 = arg2.getKey();
                }
            } else {
                sArg2 = arg2.getKey();
            }
        }
        if (arg3 != null) {
            if (arg3.getResource()) {
                sArg3 = MessageResources.getMessage(arg3.getKey(), locale);
                if (sArg3 == null) {
                    sArg3 = arg3.getKey();
                }
            } else {
                sArg3 = arg3.getKey();
            }
        }
        return new String[]{sArg0, sArg1, sArg2, sArg3};
    }

    public static StringBuffer getJavascript(List formNames, Locale locale, Hashtable fieldsName, ValidatorResources resources, String javascriptValidationSrcFile, DbFormsErrors errors) {
        ValidatorAction va;
        Iterator i;
        StringBuffer results = new StringBuffer();
        StringBuffer jsFunctions = new StringBuffer();
        boolean bJavascriptSrcFile = javascriptValidationSrcFile != null;
        Form form = null;
        String formName = "";
        ArrayList<ValidatorAction> lActions = new ArrayList<ValidatorAction>();
        ArrayList lActionMethods = new ArrayList();
        Iterator formIterator = formNames.iterator();
        while (formIterator.hasNext()) {
            formName = (String)formIterator.next();
            form = resources.get(locale, (Object)formName);
            if (form == null) continue;
            i = form.getFields().iterator();
            while (i.hasNext()) {
                Field field = (Field)i.next();
                if (!fieldsName.containsValue(field.getProperty())) continue;
                Iterator x = field.getDependencies().iterator();
                while (x.hasNext()) {
                    Object o = x.next();
                    if (o == null || lActionMethods.contains(o)) continue;
                    lActionMethods.add(o);
                }
            }
        }
        Iterator i2 = lActionMethods.iterator();
        while (i2.hasNext()) {
            String actionName = (String)i2.next();
            va = resources.getValidatorAction(actionName);
            if (va != null) {
                String javascript = va.getJavascript();
                if (javascript != null && javascript.length() > 0) {
                    lActions.add(va);
                    continue;
                }
                i2.remove();
                continue;
            }
            i2.remove();
        }
        Collections.sort(lActions, new Comparator(){

            public int compare(Object o1, Object o2) {
                ValidatorAction va1 = (ValidatorAction)o1;
                ValidatorAction va2 = (ValidatorAction)o2;
                if (!(va1.getDepends() != null && va1.getDepends().length() != 0 || va2.getDepends() != null && va2.getDepends().length() != 0)) {
                    return 0;
                }
                if (va1.getDepends() != null && va1.getDepends().length() > 0 && (va2.getDepends() == null || va2.getDepends().length() == 0)) {
                    return 1;
                }
                if ((va1.getDepends() == null || va1.getDepends().length() == 0) && va2.getDepends() != null && va2.getDepends().length() > 0) {
                    return -1;
                }
                return va1.getDependencies().size() - va2.getDependencies().size();
            }
        });
        String methods = null;
        i = lActions.iterator();
        while (i.hasNext()) {
            va = (ValidatorAction)i.next();
            if (methods == null) {
                methods = va.getMethod() + "(form)";
                continue;
            }
            methods = methods + " && " + va.getMethod() + "(form)";
        }
        results.append(DbFormsValidatorUtil.getJavascriptBegin(formName, methods));
        i = lActions.iterator();
        while (i.hasNext()) {
            va = (ValidatorAction)i.next();
            String jscriptVar = null;
            String functionName = null;
            functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
            if (!bJavascriptSrcFile) {
                jsFunctions.append(va.getJavascript());
                jsFunctions.append("\n\n");
            }
            results.append("\t function " + functionName + " () { \n");
            Iterator formIterator2 = formNames.iterator();
            while (formIterator2.hasNext()) {
                formName = (String)formIterator2.next();
                form = resources.get(locale, (Object)formName);
                if (form == null) continue;
                Iterator x = form.getFields().iterator();
                while (x.hasNext()) {
                    Field field = (Field)x.next();
                    if (field.isIndexed() || !field.isDependency(va.getName())) continue;
                    String message = DbFormsValidatorUtil.getMessage(functionName, va, locale, field, errors);
                    Enumeration e = fieldsName.keys();
                    while (e.hasMoreElements()) {
                        String fieldName = (String)e.nextElement();
                        String val = (String)fieldsName.get(fieldName);
                        if (!field.getKey().equals(val)) continue;
                        jscriptVar = DbFormsValidatorUtil.getNextVar(jscriptVar);
                        if (fieldName.indexOf("ins") != -1) {
                            results.append("\t    if(").append("bValidateUpdate").append("==false) ");
                        } else {
                            results.append("\t    if(").append("bValidateUpdate").append("==true) ");
                        }
                        results.append(" this.dbforms_" + jscriptVar + " = new Array(\"" + fieldName + "\", \"" + message + "\", ");
                        results.append("new Function (\"varName\", \"");
                        Map hVars = field.getVars();
                        Iterator iVars = hVars.keySet().iterator();
                        while (iVars.hasNext()) {
                            String varKey = (String)iVars.next();
                            Var var = (Var)hVars.get(varKey);
                            String varValue = var.getValue();
                            String jsType = var.getJsType();
                            if ("int".equalsIgnoreCase(jsType)) {
                                results.append("this." + varKey + "=" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "; ");
                                continue;
                            }
                            if ("regexp".equalsIgnoreCase(jsType)) {
                                results.append("this." + varKey + "=/" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                                continue;
                            }
                            if ("string".equalsIgnoreCase(jsType)) {
                                results.append("this." + varKey + "='" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                                continue;
                            }
                            if ("mask".equalsIgnoreCase(varKey)) {
                                results.append("this." + varKey + "=/" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                                continue;
                            }
                            results.append("this." + varKey + "='" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                        }
                        results.append(" return this[varName];\"));\n");
                    }
                }
            }
            results.append("\t } \n\n");
        }
        if (!bJavascriptSrcFile) {
            results.append(jsFunctions.toString());
        }
        results.append(DbFormsValidatorUtil.getJavascriptEnd());
        if (bJavascriptSrcFile) {
            results.append("\n<SCRIPT language=\"javascript\" src=\"" + javascriptValidationSrcFile + "\"></SCRIPT> \n");
        }
        return results;
    }

    public static String getMessage(String type, ValidatorAction va, Locale locale, Field field, DbFormsErrors errors) {
        String msg;
        String result = null;
        String[] arg = DbFormsValidatorUtil.getArgs(va.getName(), locale, field);
        String string = msg = field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
        if (msg == null) {
            msg = "errors." + va.getName();
        }
        if ((result = MessageResources.getMessage(msg, locale, arg)) != null) {
            return result;
        }
        result = msg + ":";
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] == null) continue;
            result = result + arg[i] + ",";
        }
        result = result.substring(0, result.length() - 1);
        try {
            result = errors.getXMLErrorMessage(result);
        }
        catch (Exception e) {
            logCat.error((Object)"Not in proper format - do not try to convert!");
        }
        return result;
    }

    private static String getJavascriptBegin(String formName, String methods) {
        StringBuffer sb = new StringBuffer();
        String name = Character.toUpperCase(formName.charAt(0)) + formName.substring(1, formName.length());
        sb.append("<script language=\"Javascript1.1\"> \n");
        sb.append("<!-- Begin \n");
        sb.append("\n\t var bValidateForm = false;");
        sb.append("\n\t var bValidateUpdate = true; \n\n");
        sb.append("\t function validate" + name + "(form) {  \n");
        sb.append("\t      if (!bValidateForm) \n");
        sb.append("\t \treturn true; \n");
        sb.append("\t      else \n");
        if (Util.isNull(methods)) {
            sb.append("\t \treturn true; \n");
        } else {
            sb.append("\t \treturn " + methods + "; \n");
        }
        sb.append("\t } \n\n");
        return sb.toString();
    }

    private static String getJavascriptEnd() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("//  End -->\n");
        sb.append("</script>\n\n");
        return sb.toString();
    }

    private static String getNextVar(String input) {
        if (input == null) {
            return "aa";
        }
        input = input.toLowerCase();
        for (int i = input.length(); i > 0; --i) {
            int pos = i - 1;
            char c = input.charAt(pos);
            if ((c = (char)(c + '\u0001')) <= 'z') {
                if (i == 0) {
                    return c + input.substring(pos, input.length());
                }
                if (i == input.length()) {
                    return input.substring(0, pos) + c;
                }
                return input.substring(0, pos) + c + input.substring(pos, input.length() - 1);
            }
            input = DbFormsValidatorUtil.replaceChar(input, pos, 'a');
        }
        return null;
    }

    private static String replaceChar(String input, int pos, char c) {
        if (pos == 0) {
            return c + input.substring(pos, input.length());
        }
        if (pos == input.length()) {
            return input.substring(0, pos) + c;
        }
        return input.substring(0, pos) + c + input.substring(pos, input.length() - 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

