/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.devgui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.dbforms.devgui.ConfigFilePanel;
import org.dbforms.devgui.DbPanel;
import org.dbforms.devgui.HelpFrame;
import org.dbforms.devgui.ProjectData;
import org.dbforms.devgui.PropertyPanel;
import org.dbforms.devgui.WebAppPanel;
import org.dbforms.devgui.XMLConfigGenerator;
import org.dbforms.devgui.XSLTransformPanel;
import org.dbforms.util.Util;

public class DevGui
extends JFrame
implements ActionListener {
    private static final String metalLF = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String motifLF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String windowsLF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String ARG_PROPERTY_FILE_NAME = "propertyfilename";
    private static final String ARG_CREATE_CONFIG = "createconfigfile";
    private static final String ARG_OUTPUT_FILE_NAME = "outputfilename";
    private File dbFormsHome;
    private JFrame helpFrame;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem exitMenuItem;
    private JMenuItem helpMenuItem;
    private JMenuItem metalMenuItem;
    private JMenuItem motifMenuItem;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem windowsMenuItem;
    private JSeparator jSeparator1;
    private JTabbedPane jTabbedPane1;
    private ProjectData projectData;
    private PropertyPanel tab_configFilePanel;
    private PropertyPanel tab_dbPanel;
    private PropertyPanel tab_webAppPanel;
    private PropertyPanel tab_xslTranformPanel;
    private String dbFormsHomeStr;
    private String fileSeparator;
    private final String titleCore = "DbForms Developers' GUI - ";

    public DevGui(ProjectData projectData) {
        this.projectData = projectData;
        boolean projectDataLoaded = false;
        this.dbFormsHomeStr = System.getProperty("DBFORMS_HOME");
        if (this.dbFormsHomeStr != null) {
            this.dbFormsHome = new File(this.dbFormsHomeStr);
            System.out.println("dbFormsHome=" + this.dbFormsHome.getAbsolutePath());
            if (this.dbFormsHome.isDirectory() && this.dbFormsHome.canRead()) {
                if (projectData == null) {
                    this.projectData = new ProjectData();
                } else {
                    projectDataLoaded = true;
                }
                this.fileSeparator = System.getProperties().getProperty("file.separator");
                this.setTitle("DbForms Developers' GUI - [New Project]");
                this.setSize(750, 500);
                this.initComponents();
                this.jTabbedPane1.setTabPlacement(1);
                this.jTabbedPane1.setTitleAt(0, "(1) Web Application");
                this.jTabbedPane1.setToolTipTextAt(0, "specify web application location and URI");
                this.jTabbedPane1.setTitleAt(1, "(2) Database");
                this.jTabbedPane1.setToolTipTextAt(1, "set database properties like JDBC driver, username");
                this.jTabbedPane1.setTitleAt(2, "(3) XML Config");
                this.jTabbedPane1.setToolTipTextAt(2, "automatically generate dbforms config file");
                this.jTabbedPane1.setTitleAt(3, "(4) XSL Transformation");
                this.jTabbedPane1.setToolTipTextAt(3, "use XSL to generate JSPs from dbforms config file");
                ButtonGroup lfButtonGroup = new ButtonGroup();
                JMenu jMenu2 = new JMenu();
                jMenu2.setText("Look&Feel");
                this.metalMenuItem = new JRadioButtonMenuItem("Java Metal L&F");
                this.metalMenuItem.setActionCommand("Java Metal L&F");
                this.metalMenuItem.addActionListener(this);
                lfButtonGroup.add(this.metalMenuItem);
                jMenu2.add(this.metalMenuItem);
                this.motifMenuItem = new JRadioButtonMenuItem("Motif L&F");
                this.motifMenuItem.setActionCommand("Motiv L&F");
                this.motifMenuItem.addActionListener(this);
                lfButtonGroup.add(this.motifMenuItem);
                jMenu2.add(this.motifMenuItem);
                this.windowsMenuItem = new JRadioButtonMenuItem("Windows L&F");
                this.windowsMenuItem.setActionCommand("Windows L&F");
                this.windowsMenuItem.addActionListener(this);
                lfButtonGroup.add(this.windowsMenuItem);
                jMenu2.add(this.windowsMenuItem);
                this.metalMenuItem.setSelected(true);
                this.setLookAndFeel(metalLF);
                this.jMenuBar1.add(jMenu2);
                JMenu jMenu3 = new JMenu();
                jMenu3.setText("Help");
                this.helpMenuItem = new JMenuItem();
                this.helpMenuItem.setActionCommand("Show Helptext");
                this.helpMenuItem.setText("Show Helptext");
                this.helpMenuItem.addActionListener(this);
                jMenu3.add(this.helpMenuItem);
                this.jMenuBar1.add(jMenu3);
                this.helpFrame = new HelpFrame();
                this.doLayout();
                if (projectDataLoaded) {
                    this.updateGUI();
                    this.setTitle("DbForms Developers' GUI - [" + projectData.getFile().getAbsolutePath() + "]");
                }
            } else {
                this.quickQuit("DBFORMS_HOME is set to \"" + this.dbFormsHomeStr + "\", which is not a valid accessible directory.", 1);
            }
        } else {
            this.quickQuit("Pleases set the environment variable DBFORMS_HOME to the root of your unzipped DbForms-Distribution! Check manual for more info.", 1);
        }
    }

    public File getDbFormsHome() {
        return this.dbFormsHome;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public ProjectData getProjectData() {
        return this.projectData;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newMenuItem) {
            this.newProject();
        } else if (e.getSource() == this.openMenuItem) {
            this.openProject();
        } else if (e.getSource() == this.saveMenuItem) {
            this.saveProject();
        } else if (e.getSource() == this.saveAsMenuItem) {
            this.saveAsProject();
        } else if (e.getSource() == this.exitMenuItem) {
            this.exitProject();
        } else if (e.getSource() == this.helpMenuItem) {
            this.helpFrame.show();
        } else if (e.getSource() == this.metalMenuItem) {
            this.setLookAndFeel(metalLF);
        } else if (e.getSource() == this.motifMenuItem) {
            this.setLookAndFeel(motifLF);
        } else if (e.getSource() == this.windowsMenuItem) {
            this.setLookAndFeel(windowsLF);
        }
    }

    public static void main(String[] args) {
        Map argsMap = DevGui.parseCommandlineParameters(args);
        if (argsMap.get(ARG_CREATE_CONFIG) != null) {
            DevGui.createConfigFile((String)argsMap.get(ARG_PROPERTY_FILE_NAME), (String)argsMap.get(ARG_OUTPUT_FILE_NAME));
        } else {
            ProjectData pd = null;
            String propsFileName = (String)argsMap.get(ARG_PROPERTY_FILE_NAME);
            if (!Util.isNull(propsFileName)) {
                File projFile = new File(propsFileName);
                try {
                    pd = ProjectData.loadFromDisc(projFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            new DevGui(pd).show();
        }
    }

    protected static void createConfigFile(String propsFileName, String outputFileName) {
        try {
            File projFile = new File(propsFileName);
            ProjectData pd = ProjectData.loadFromDisc(projFile);
            if (Util.isNull(outputFileName)) {
                outputFileName = pd.getProperty("configFile");
            }
            if (Util.isNull(outputFileName)) {
                throw new Exception("Property configFile in propery file not set");
            }
            String result = XMLConfigGenerator.createXMLOutput(pd, false);
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileName));
            bw.write(result);
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static Map parseCommandlineParameters(String[] args) {
        if (args == null) {
            return null;
        }
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-propertyfile")) {
                if (argsMap.get(ARG_PROPERTY_FILE_NAME) == null) {
                    argsMap.put(ARG_PROPERTY_FILE_NAME, args[++i]);
                    continue;
                }
                System.err.println("Not allowed to specify \"createconfigfile\" and \"-propertyfile\" at the same time");
                System.err.println("Programm stopped");
                System.err.println();
                DevGui.usage();
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase(ARG_CREATE_CONFIG)) {
                argsMap.put(ARG_CREATE_CONFIG, true);
                if (argsMap.get(ARG_PROPERTY_FILE_NAME) == null) {
                    if (i < args.length) {
                        argsMap.put(ARG_PROPERTY_FILE_NAME, args[++i]);
                    } else {
                        System.err.println("<propertyfilename> must be specified");
                        System.err.println("Programm stopped");
                        System.err.println();
                        DevGui.usage();
                        System.exit(1);
                    }
                    if (i >= args.length - 1) continue;
                    argsMap.put(ARG_OUTPUT_FILE_NAME, args[++i]);
                    continue;
                }
                System.err.println("Not allowed to specify \"createconfigfile\" and \"-propertyfile\" at the same time");
                System.err.println("Programm stopped");
                System.err.println();
                DevGui.usage();
                System.exit(1);
                continue;
            }
            System.err.println("Undefined parameter \"" + args[i] + "\"");
            System.err.println("Programm stopped");
            System.err.println();
            DevGui.usage();
            System.exit(1);
        }
        return argsMap;
    }

    static void usage() {
        System.out.println("Usage: ");
        System.out.println("Gui mode: \n  java -DDBFORMS_HOME=/path/to/dbfhome org.dbforms.devgui.DevGui ");
        System.out.println("Gui mode with automatic loaded configfile: \n  java org.dbforms.devgui.DevGui -propertyfile <propertyfilename>");
        System.out.println("Command line mode: \n  java org.dbforms.devgui.DevGui createconfigfile <propertyfilename> [ <outputfilename> ]");
    }

    private void setLookAndFeel(String lf) {
        try {
            UIManager.setLookAndFeel(lf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void exitProject() {
        if (!this.projectData.isUnsaved()) {
            System.exit(0);
        } else {
            int answer = JOptionPane.showOptionDialog(this, "Your project data has not been not saved.", "Ooops", 1, 2, null, new String[]{"Save and exit", "Exit without saving", "Cancel"}, "Save and exit");
            switch (answer) {
                case 0: {
                    this.saveProject();
                }
                case 1: {
                    System.exit(0);
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.jTabbedPane1 = new JTabbedPane();
        this.jMenu1.setActionCommand("Project");
        this.jMenu1.setText("Project");
        this.newMenuItem.setActionCommand("New");
        this.newMenuItem.setText("New");
        this.newMenuItem.addActionListener(this);
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        this.jMenu1.add(this.newMenuItem);
        this.openMenuItem.setActionCommand("Open");
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(this);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.jMenu1.add(this.openMenuItem);
        this.saveMenuItem.setActionCommand("Save");
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(this);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2, false));
        this.jMenu1.add(this.saveMenuItem);
        this.saveAsMenuItem.setActionCommand("Save As...");
        this.saveAsMenuItem.setText("Save As...");
        this.saveAsMenuItem.addActionListener(this);
        this.jMenu1.add(this.saveAsMenuItem);
        this.jMenu1.add(this.jSeparator1);
        this.exitMenuItem.setActionCommand("Exit");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(this);
        this.jMenu1.add(this.exitMenuItem);
        this.jMenuBar1.add(this.jMenu1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DevGui.this.exitForm(evt);
            }
        });
        this.setJMenuBar(this.jMenuBar1);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", this.jTabbedPane1);
        this.jTabbedPane1.setTabPlacement(2);
        this.tab_webAppPanel = new WebAppPanel(this);
        this.jTabbedPane1.add("(1) Web Application properties", this.tab_webAppPanel);
        this.tab_dbPanel = new DbPanel(this);
        this.jTabbedPane1.add("(2) Database properties", this.tab_dbPanel);
        this.tab_configFilePanel = new ConfigFilePanel(this);
        this.jTabbedPane1.add("(3) XML config", this.tab_configFilePanel);
        this.tab_xslTranformPanel = new XSLTransformPanel(this);
        this.jTabbedPane1.add("(4) XSL transformation", this.tab_xslTranformPanel);
        this.tab_webAppPanel.doLayout();
        this.tab_dbPanel.doLayout();
        this.tab_configFilePanel.doLayout();
        this.tab_xslTranformPanel.doLayout();
    }

    private void newProject() {
        this.projectData = new ProjectData();
        this.updateGUI();
        this.setTitle("DbForms Developers' GUI - [New Project]");
        System.out.println("new Project initialized");
    }

    private void openProject() {
        JFileChooser dlg_fileChooser = new JFileChooser();
        dlg_fileChooser.setDialogTitle("Open Project...");
        dlg_fileChooser.setVisible(true);
        int returnVal = dlg_fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File f = dlg_fileChooser.getSelectedFile();
            try {
                if (f.isFile()) {
                    this.projectData = ProjectData.loadFromDisc(f);
                    this.updateGUI();
                    this.setTitle("DbForms Developers' GUI - [" + this.projectData.getFile().getAbsolutePath() + "]");
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.showExceptionDialog(ioe);
            }
        }
    }

    private void quickQuit(String message, int returnValue) {
        System.out.println(message);
        System.out.println("\nPlease drop a line of feedback to j.peer@gmx.net, thanks!\n");
        System.exit(returnValue);
    }

    private void saveAsProject() {
        JFileChooser dlg_fileChooser = new JFileChooser();
        dlg_fileChooser.setDialogTitle("Save Project As...");
        dlg_fileChooser.setVisible(true);
        int returnVal = dlg_fileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            try {
                File f = dlg_fileChooser.getSelectedFile();
                this.projectData.storeToDisc(f);
                this.setTitle("DbForms Developers' GUI - [" + this.projectData.getFile().getAbsolutePath() + "]");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.showExceptionDialog(ioe);
            }
        }
    }

    private void saveProject() {
        if (this.projectData.getFile() != null) {
            try {
                this.projectData.storeToDisc(this.projectData.getFile());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.showExceptionDialog(ioe);
            }
        } else {
            this.saveAsProject();
        }
    }

    private void showExceptionDialog(Exception e) {
        JOptionPane.showMessageDialog(this, "An exception occurred:\n\n" + e.toString() + "\n", "Exception", 0);
    }

    private void updateGUI() {
        this.tab_dbPanel.setNewProjectData(this.projectData);
        this.tab_webAppPanel.setNewProjectData(this.projectData);
        this.tab_configFilePanel.setNewProjectData(this.projectData);
        this.tab_xslTranformPanel.setNewProjectData(this.projectData);
    }
}

