/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard.csvtemplate;

import de.destatis.core.map.Mapping;
import de.destatis.core.map.editor.util.CsvTableCreator;
import de.destatis.core.map.editor.util.MappingCsvTemplateCreator;
import de.destatis.core.map.editor.util.MetaMappingCsvTemplateCreator;
import de.destatis.core.map.editor.wizard.AbstractStep;
import de.destatis.core.map.editor.wizard.AbstractWizard;
import de.destatis.core.map.editor.wizard.Step;
import de.destatis.core.map.editor.wizard.csvtemplate.CsvFileChoiceStep;
import de.destatis.core.map.editor.wizard.csvtemplate.CsvTemplateTypeChoiceStep;
import de.destatis.core.map.model.MetaMapping;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class CsvTemplateWizard
extends AbstractWizard {
    private CsvTemplateTypeChoiceStep typeChoiceStep;
    private CsvFileChoiceStep fileChoiceStep;
    private Step[] allSteps;
    private Mapping mapping;
    private MetaErhebungsbeschreibung metaErhebungsbeschreibung;
    private MetaMapping metaMapping;

    public CsvTemplateWizard(Mapping mapping, MetaErhebungsbeschreibung metaErhebungsbeschreibung) {
        this(mapping, metaErhebungsbeschreibung, null);
    }

    public CsvTemplateWizard(MetaMapping metaMapping) {
        this(null, null, metaMapping);
    }

    private CsvTemplateWizard(Mapping mapping, MetaErhebungsbeschreibung metaErhebungsbeschreibung, MetaMapping metaMapping) {
        if (mapping != null && metaMapping != null) {
            throw new IllegalArgumentException("mapping und metaMapping uebergeben.");
        }
        if (mapping == null && metaMapping == null) {
            throw new IllegalArgumentException("mapping oder metaMapping erforderlich.");
        }
        if (mapping != null) {
            if (metaErhebungsbeschreibung == null) {
                throw new IllegalArgumentException("metaErhebungsbeschreibung ist erforderlich.");
            }
            this.mapping = mapping;
            this.metaErhebungsbeschreibung = metaErhebungsbeschreibung;
            this.metaMapping = null;
        } else {
            this.metaMapping = metaMapping;
            this.mapping = null;
            this.metaErhebungsbeschreibung = null;
        }
        ArrayList<AbstractStep> allSteps = new ArrayList<AbstractStep>();
        if (this.mapping != null) {
            this.typeChoiceStep = new CsvTemplateTypeChoiceStep();
            allSteps.add(this.typeChoiceStep);
        }
        this.fileChoiceStep = new CsvFileChoiceStep();
        allSteps.add(this.fileChoiceStep);
        this.allSteps = allSteps.toArray(new Step[allSteps.size()]);
        this.setCurrentStep(this.mapping != null ? this.typeChoiceStep : this.fileChoiceStep);
    }

    @Override
    protected Step[] getAllSteps() {
        return this.allSteps;
    }

    @Override
    public Step getNextStep() {
        CsvFileChoiceStep nextStep;
        Step currentStep = this.getCurrentStep();
        if (currentStep == this.typeChoiceStep) {
            boolean separateFiles = this.typeChoiceStep.isSeparateFiles();
            this.fileChoiceStep.setIsChooseDirectory(separateFiles);
            nextStep = this.fileChoiceStep;
        } else {
            nextStep = null;
        }
        return nextStep;
    }

    @Override
    public Step getPreviousStep() {
        Step currentStep = this.getCurrentStep();
        CsvTemplateTypeChoiceStep previousStep = currentStep == this.fileChoiceStep ? (this.mapping != null ? this.typeChoiceStep : null) : null;
        return previousStep;
    }

    @Override
    public String getTitle() {
        return "CSV-Vorlage erstellen";
    }

    @Override
    public boolean finish() {
        CsvTableCreator tableCreator;
        String filepath = this.fileChoiceStep.getFilepath();
        String encoding = this.fileChoiceStep.getEncoding();
        char csvSeparator = this.fileChoiceStep.getCsvSeparator();
        if (this.mapping != null) {
            int answer;
            int answer2;
            String[] csvFiles;
            boolean separateFiles = this.typeChoiceStep.isSeparateFiles();
            File file = new File(filepath);
            if (separateFiles ? file.isDirectory() && (csvFiles = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".csv");
                }
            })) != null && csvFiles.length > 0 && (answer2 = JOptionPane.showConfirmDialog(this.getDialog(), "Das Verzeichnis '" + file.getAbsolutePath() + "' existiert bereits und enth\u00e4lt CSV-Dateien.\n" + "Vorhandene CSV-Dateien in diesem Verzeichnis werden u.U. \u00fcberschrieben.\n" + "Soll der Export in dieses Verzeichnis erfolgen?", "Achtung", 1, 2)) != 0 : file.isFile() && (answer = JOptionPane.showConfirmDialog(this.getDialog(), "Die Datei '" + file.getAbsolutePath() + "' existiert bereits.\n" + "Soll die Datei \u00fcberschrieben werden?", "Achtung", 1, 2)) != 0) {
                return false;
            }
            tableCreator = new MappingCsvTemplateCreator(this.mapping, this.metaErhebungsbeschreibung, file, separateFiles, encoding, csvSeparator, '\"');
        } else {
            int answer;
            File file = new File(filepath);
            if (file.isFile() && (answer = JOptionPane.showConfirmDialog(this.getDialog(), "Die Datei '" + file.getAbsolutePath() + "' existiert bereits.\n" + "Soll die Datei \u00fcberschrieben werden?", "Achtung", 1, 3)) != 0) {
                return false;
            }
            tableCreator = new MetaMappingCsvTemplateCreator(this.metaMapping, file, encoding, csvSeparator, '\"');
        }
        boolean finish = false;
        try {
            tableCreator.run();
            JOptionPane.showMessageDialog(this.getDialog(), "Die CSV-Vorlage wurde erfolgreich erstellt.", "Hinweis", 1);
            finish = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.getDialog(), "Bei der Erzeugung der CSV-Vorlage ist ein Fehler aufgetreten:\n" + e.toString(), "Fehler", 0);
        }
        return finish;
    }
}

