/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.pdf.AcroFields;
import clover.com.lowagie.text.pdf.PRStream;
import clover.com.lowagie.text.pdf.PdfArray;
import clover.com.lowagie.text.pdf.PdfDictionary;
import clover.com.lowagie.text.pdf.PdfIndirectReference;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfReader;
import clover.com.lowagie.text.pdf.PdfStream;
import clover.com.lowagie.text.pdf.PdfWriter;
import clover.com.lowagie.text.xml.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XfaForm {
    private Xml2SomTemplate templateSom;
    private Xml2SomDatasets datasetsSom;
    private AcroFieldsSearch acroFieldsSom;
    private PdfReader reader;
    private boolean xfaPresent;
    private Document domDocument;
    private boolean changed;
    private Node datasetsNode;
    private Node templateNode;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";

    public XfaForm() {
    }

    public XfaForm(PdfReader reader) throws IOException, ParserConfigurationException, SAXException {
        this.reader = reader;
        PdfDictionary af = (PdfDictionary)PdfReader.getPdfObjectRelease(reader.getCatalog().get(PdfName.ACROFORM));
        if (af == null) {
            this.xfaPresent = false;
            return;
        }
        PdfObject xfa = PdfReader.getPdfObjectRelease(af.get(PdfName.XFA));
        if (xfa == null) {
            this.xfaPresent = false;
            return;
        }
        this.xfaPresent = true;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (xfa.isArray()) {
            ArrayList ar = ((PdfArray)xfa).getArrayList();
            int k = 1;
            while (k < ar.size()) {
                PdfObject ob = PdfReader.getPdfObject((PdfObject)ar.get(k));
                if (ob instanceof PRStream) {
                    byte[] b = PdfReader.getStreamBytes((PRStream)ob);
                    bout.write(b);
                }
                k += 2;
            }
        } else if (xfa instanceof PRStream) {
            byte[] b = PdfReader.getStreamBytes((PRStream)xfa);
            bout.write(b);
        }
        bout.close();
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        DocumentBuilder db = fact.newDocumentBuilder();
        this.domDocument = db.parse(new ByteArrayInputStream(bout.toByteArray()));
        Node n = this.domDocument.getFirstChild();
        n = n.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1) {
                String s = n.getLocalName();
                if (s.equals("template")) {
                    this.templateNode = n;
                    this.templateSom = new Xml2SomTemplate(n);
                } else if (s.equals("datasets")) {
                    this.datasetsNode = n;
                    this.datasetsSom = new Xml2SomDatasets(n.getFirstChild());
                }
            }
            n = n.getNextSibling();
        }
    }

    public static void setXfa(byte[] xfaData, PdfReader reader, PdfWriter writer) throws IOException {
        PdfDictionary af = (PdfDictionary)PdfReader.getPdfObjectRelease(reader.getCatalog().get(PdfName.ACROFORM));
        if (af == null) {
            return;
        }
        reader.killXref(af.get(PdfName.XFA));
        PdfStream str = new PdfStream(xfaData);
        str.flateCompress();
        PdfIndirectReference ref = writer.addToBody(str).getIndirectReference();
        af.put(PdfName.XFA, ref);
    }

    public void setXfa(PdfWriter writer) throws IOException {
        XfaForm.setXfa(XfaForm.serializeDoc(this.domDocument), this.reader, writer);
    }

    public static byte[] serializeDoc(Node n) throws IOException {
        XmlDomWriter xw = new XmlDomWriter();
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        xw.setOutput(fout, null);
        xw.setCanonical(false);
        xw.write(n);
        fout.close();
        return fout.toByteArray();
    }

    public boolean isXfaPresent() {
        return this.xfaPresent;
    }

    public Document getDomDocument() {
        return this.domDocument;
    }

    public String findFieldName(String name, AcroFields af) {
        HashMap items = af.getFields();
        if (items.containsKey(name)) {
            return name;
        }
        if (this.acroFieldsSom == null) {
            this.acroFieldsSom = new AcroFieldsSearch(items.keySet());
        }
        if (this.acroFieldsSom.getAcroShort2LongName().containsKey(name)) {
            return (String)this.acroFieldsSom.getAcroShort2LongName().get(name);
        }
        return this.acroFieldsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public String findDatasetsName(String name) {
        if (this.datasetsSom.getName2Node().containsKey(name)) {
            return name;
        }
        return this.datasetsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public Node findDatasetsNode(String name) {
        if (name == null) {
            return null;
        }
        if ((name = this.findDatasetsName(name)) == null) {
            return null;
        }
        return (Node)this.datasetsSom.getName2Node().get(name);
    }

    public static String getNodeText(Node n) {
        if (n == null) {
            return "";
        }
        return XfaForm.getNodeText(n, "");
    }

    private static String getNodeText(Node n, String name) {
        Node n2 = n.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                name = XfaForm.getNodeText(n2, name);
            } else if (n2.getNodeType() == 3) {
                name = String.valueOf(name) + n2.getNodeValue();
            }
            n2 = n2.getNextSibling();
        }
        return name;
    }

    public void setNodeText(Node n, String text) {
        if (n == null) {
            return;
        }
        Node nc = null;
        while ((nc = n.getFirstChild()) != null) {
            n.removeChild(nc);
        }
        if (n.getAttributes().getNamedItemNS(XFA_DATA_SCHEMA, "dataNode") != null) {
            n.getAttributes().removeNamedItemNS(XFA_DATA_SCHEMA, "dataNode");
        }
        n.appendChild(this.domDocument.createTextNode(text));
        this.changed = true;
    }

    public void setXfaPresent(boolean xfaPresent) {
        this.xfaPresent = xfaPresent;
    }

    public void setDomDocument(Document domDocument) {
        this.domDocument = domDocument;
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public void setReader(PdfReader reader) {
        this.reader = reader;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Xml2SomTemplate getTemplateSom() {
        return this.templateSom;
    }

    public void setTemplateSom(Xml2SomTemplate templateSom) {
        this.templateSom = templateSom;
    }

    public Xml2SomDatasets getDatasetsSom() {
        return this.datasetsSom;
    }

    public void setDatasetsSom(Xml2SomDatasets datasetsSom) {
        this.datasetsSom = datasetsSom;
    }

    public AcroFieldsSearch getAcroFieldsSom() {
        return this.acroFieldsSom;
    }

    public void setAcroFieldsSom(AcroFieldsSearch acroFieldsSom) {
        this.acroFieldsSom = acroFieldsSom;
    }

    public Node getDatasetsNode() {
        return this.datasetsNode;
    }

    public static class InverseStore {
        protected ArrayList part = new ArrayList();
        protected ArrayList follow = new ArrayList();

        public String getDefaultName() {
            InverseStore store = this;
            Object obj;
            while (!((obj = store.follow.get(0)) instanceof String)) {
                store = (InverseStore)obj;
            }
            return (String)obj;
        }

        public boolean isSimilar(String name) {
            int idx = name.indexOf(91);
            name = name.substring(0, idx + 1);
            int k = 0;
            while (k < this.part.size()) {
                if (((String)this.part.get(k)).startsWith(name)) {
                    return true;
                }
                ++k;
            }
            return false;
        }
    }

    public static class Stack2
    extends ArrayList {
        private static final long serialVersionUID = -7451476576174095212L;

        public Object peek() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            return this.get(this.size() - 1);
        }

        public Object pop() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            Object ret = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            return ret;
        }

        public Object push(Object item) {
            this.add(item);
            return item;
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }

    public static class Xml2Som {
        protected ArrayList order;
        protected HashMap name2Node;
        protected HashMap inverseSearch;
        protected Stack2 stack;
        protected int anform;

        public static String escapeSom(String s) {
            int idx = s.indexOf(46);
            if (idx < 0) {
                return s;
            }
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (idx >= 0) {
                sb.append(s.substring(last, idx));
                sb.append('\\');
                last = idx;
                idx = s.indexOf(46, idx + 1);
            }
            sb.append(s.substring(last));
            return sb.toString();
        }

        public static String unescapeSom(String s) {
            int idx = s.indexOf(92);
            if (idx < 0) {
                return s;
            }
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (idx >= 0) {
                sb.append(s.substring(last, idx));
                last = idx + 1;
                idx = s.indexOf(92, idx + 1);
            }
            sb.append(s.substring(last));
            return sb.toString();
        }

        protected String printStack() {
            if (this.stack.empty()) {
                return "";
            }
            StringBuffer s = new StringBuffer();
            int k = 0;
            while (k < this.stack.size()) {
                s.append('.').append((String)this.stack.get(k));
                ++k;
            }
            return s.substring(1);
        }

        public static String getShortName(String s) {
            int idx = s.indexOf(".#subform[");
            if (idx < 0) {
                return s;
            }
            int last = 0;
            StringBuffer sb = new StringBuffer();
            while (idx >= 0) {
                sb.append(s.substring(last, idx));
                idx = s.indexOf("]", idx + 10);
                if (idx < 0) {
                    return sb.toString();
                }
                last = idx + 1;
                idx = s.indexOf(".#subform[", last);
            }
            sb.append(s.substring(last));
            return sb.toString();
        }

        public void inverseSearchAdd(String unstack) {
            Xml2Som.inverseSearchAdd(this.inverseSearch, this.stack, unstack);
        }

        public static void inverseSearchAdd(HashMap inverseSearch, Stack2 stack, String unstack) {
            String last = (String)stack.peek();
            InverseStore store = (InverseStore)inverseSearch.get(last);
            if (store == null) {
                store = new InverseStore();
                inverseSearch.put(last, store);
            }
            int k = stack.size() - 2;
            while (k >= 0) {
                InverseStore store2;
                last = (String)stack.get(k);
                int idx = store.part.indexOf(last);
                if (idx < 0) {
                    store.part.add(last);
                    store2 = new InverseStore();
                    store.follow.add(store2);
                } else {
                    store2 = (InverseStore)store.follow.get(idx);
                }
                store = store2;
                --k;
            }
            store.part.add("");
            store.follow.add(unstack);
        }

        public String inverseSearchGlobal(ArrayList parts) {
            if (parts.isEmpty()) {
                return null;
            }
            InverseStore store = (InverseStore)this.inverseSearch.get(parts.get(parts.size() - 1));
            if (store == null) {
                return null;
            }
            int k = parts.size() - 2;
            while (k >= 0) {
                String part = (String)parts.get(k);
                int idx = store.part.indexOf(part);
                if (idx < 0) {
                    if (store.isSimilar(part)) {
                        return null;
                    }
                    return store.getDefaultName();
                }
                store = (InverseStore)store.follow.get(idx);
                --k;
            }
            return store.getDefaultName();
        }

        public static Stack2 splitParts(String name) {
            String part;
            while (name.startsWith(".")) {
                name = name.substring(1);
            }
            Stack2 parts = new Stack2();
            int last = 0;
            int pos = 0;
            while (true) {
                pos = last;
                while ((pos = name.indexOf(46, pos)) >= 0 && name.charAt(pos - 1) == '\\') {
                    ++pos;
                }
                if (pos < 0) break;
                part = name.substring(last, pos);
                if (!part.endsWith("]")) {
                    part = String.valueOf(part) + "[0]";
                }
                parts.add(part);
                last = pos + 1;
            }
            part = name.substring(last);
            if (!part.endsWith("]")) {
                part = String.valueOf(part) + "[0]";
            }
            parts.add(part);
            return parts;
        }

        public ArrayList getOrder() {
            return this.order;
        }

        public void setOrder(ArrayList order) {
            this.order = order;
        }

        public HashMap getName2Node() {
            return this.name2Node;
        }

        public void setName2Node(HashMap name2Node) {
            this.name2Node = name2Node;
        }

        public HashMap getInverseSearch() {
            return this.inverseSearch;
        }

        public void setInverseSearch(HashMap inverseSearch) {
            this.inverseSearch = inverseSearch;
        }
    }

    public static class Xml2SomDatasets
    extends Xml2Som {
        public Xml2SomDatasets(Node n) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.inverseSearch = new HashMap();
            this.processDatasetsInternal(n);
        }

        public Node insertNode(Node n, String shortName) {
            Stack2 stack = Xml2SomDatasets.splitParts(shortName);
            Document doc = n.getOwnerDocument();
            Node n2 = null;
            n = n.getFirstChild();
            int k = 0;
            while (k < stack.size()) {
                String part = (String)stack.get(k);
                int idx = part.lastIndexOf("[");
                String name = part.substring(0, idx);
                idx = Integer.parseInt(part.substring(idx + 1, part.length() - 1));
                int found = -1;
                n2 = n.getFirstChild();
                while (n2 != null) {
                    String s;
                    if (n2.getNodeType() == 1 && (s = Xml2SomDatasets.escapeSom(n2.getLocalName())).equals(name) && ++found == idx) break;
                    n2 = n2.getNextSibling();
                }
                while (found < idx) {
                    n2 = doc.createElementNS(null, name);
                    n2 = n.appendChild(n2);
                    Attr attr = doc.createAttributeNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
                    attr.setNodeValue("dataGroup");
                    n2.getAttributes().setNamedItemNS(attr);
                    ++found;
                }
                n = n2;
                ++k;
            }
            Xml2SomDatasets.inverseSearchAdd(this.inverseSearch, stack, shortName);
            this.name2Node.put(shortName, n2);
            this.order.add(shortName);
            return n2;
        }

        private static boolean hasChildren(Node n) {
            Node dataNodeN = n.getAttributes().getNamedItemNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
            if (dataNodeN != null) {
                String dataNode = dataNodeN.getNodeValue();
                if ("dataGroup".equals(dataNode)) {
                    return true;
                }
                if ("dataValue".equals(dataNode)) {
                    return false;
                }
            }
            if (!n.hasChildNodes()) {
                return false;
            }
            Node n2 = n.getFirstChild();
            while (n2 != null) {
                if (n2.getNodeType() == 1) {
                    return true;
                }
                n2 = n2.getNextSibling();
            }
            return false;
        }

        private void processDatasetsInternal(Node n) {
            HashMap<String, Integer> ss = new HashMap<String, Integer>();
            Node n2 = n.getFirstChild();
            while (n2 != null) {
                if (n2.getNodeType() == 1) {
                    String s = Xml2SomDatasets.escapeSom(n2.getLocalName());
                    Integer i = (Integer)ss.get(s);
                    i = i == null ? new Integer(0) : new Integer(i + 1);
                    ss.put(s, i);
                    if (Xml2SomDatasets.hasChildren(n2)) {
                        this.stack.push(String.valueOf(s) + "[" + i.toString() + "]");
                        this.processDatasetsInternal(n2);
                        this.stack.pop();
                    } else {
                        this.stack.push(String.valueOf(s) + "[" + i.toString() + "]");
                        String unstack = this.printStack();
                        this.order.add(unstack);
                        this.inverseSearchAdd(unstack);
                        this.name2Node.put(unstack, n2);
                        this.stack.pop();
                    }
                }
                n2 = n2.getNextSibling();
            }
        }
    }

    public static class AcroFieldsSearch
    extends Xml2Som {
        private HashMap acroShort2LongName;

        public AcroFieldsSearch(Collection items) {
            this.inverseSearch = new HashMap();
            this.acroShort2LongName = new HashMap();
            Iterator it = items.iterator();
            while (it.hasNext()) {
                String itemName = (String)it.next();
                String itemShort = AcroFieldsSearch.getShortName(itemName);
                this.acroShort2LongName.put(itemShort, itemName);
                AcroFieldsSearch.inverseSearchAdd(this.inverseSearch, AcroFieldsSearch.splitParts(itemShort), itemName);
            }
        }

        public HashMap getAcroShort2LongName() {
            return this.acroShort2LongName;
        }

        public void setAcroShort2LongName(HashMap acroShort2LongName) {
            this.acroShort2LongName = acroShort2LongName;
        }
    }

    public static class Xml2SomTemplate
    extends Xml2Som {
        private boolean dynamicForm;
        private int templateLevel;

        public Xml2SomTemplate(Node n) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.templateLevel = 0;
            this.inverseSearch = new HashMap();
            this.processTemplate(n, null);
        }

        public String getFieldType(String s) {
            Node n = (Node)this.name2Node.get(s);
            if (n == null) {
                return null;
            }
            if (n.getLocalName().equals("exclGroup")) {
                return "exclGroup";
            }
            Node ui = n.getFirstChild();
            while (ui != null) {
                if (ui.getNodeType() == 1 && ui.getLocalName().equals("ui")) break;
                ui = ui.getNextSibling();
            }
            if (ui == null) {
                return null;
            }
            Node type = ui.getFirstChild();
            while (type != null) {
                if (!(type.getNodeType() != 1 || type.getLocalName().equals("extras") && type.getLocalName().equals("picture"))) {
                    return type.getLocalName();
                }
                type = type.getNextSibling();
            }
            return null;
        }

        private void processTemplate(Node n, HashMap ff) {
            if (ff == null) {
                ff = new HashMap<String, Integer>();
            }
            HashMap<String, Integer> ss = new HashMap<String, Integer>();
            Node n2 = n.getFirstChild();
            while (n2 != null) {
                if (n2.getNodeType() == 1) {
                    String s = n2.getLocalName();
                    if (s.equals("subform")) {
                        Integer i;
                        Node name = n2.getAttributes().getNamedItem("name");
                        String nn = "#subform";
                        boolean annon = true;
                        if (name != null) {
                            nn = Xml2SomTemplate.escapeSom(name.getNodeValue());
                            annon = false;
                        }
                        if (annon) {
                            i = new Integer(this.anform);
                            ++this.anform;
                        } else {
                            i = (Integer)ss.get(nn);
                            i = i == null ? new Integer(0) : new Integer(i + 1);
                            ss.put(nn, i);
                        }
                        this.stack.push(String.valueOf(nn) + "[" + i.toString() + "]");
                        ++this.templateLevel;
                        if (annon) {
                            this.processTemplate(n2, ff);
                        } else {
                            this.processTemplate(n2, null);
                        }
                        --this.templateLevel;
                        this.stack.pop();
                    } else if (s.equals("field") || s.equals("exclGroup")) {
                        Node name = n2.getAttributes().getNamedItem("name");
                        if (name != null) {
                            String nn = Xml2SomTemplate.escapeSom(name.getNodeValue());
                            Integer i = (Integer)ff.get(nn);
                            i = i == null ? new Integer(0) : new Integer(i + 1);
                            ff.put(nn, i);
                            this.stack.push(String.valueOf(nn) + "[" + i.toString() + "]");
                            String unstack = this.printStack();
                            this.order.add(unstack);
                            this.inverseSearchAdd(unstack);
                            this.name2Node.put(unstack, n2);
                            this.stack.pop();
                        }
                    } else if (!this.dynamicForm && this.templateLevel > 0 && s.equals("occur")) {
                        int initial = 1;
                        int min = 1;
                        int max = 1;
                        Node a = n2.getAttributes().getNamedItem("initial");
                        if (a != null) {
                            try {
                                initial = Integer.parseInt(a.getNodeValue().trim());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((a = n2.getAttributes().getNamedItem("min")) != null) {
                            try {
                                min = Integer.parseInt(a.getNodeValue().trim());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((a = n2.getAttributes().getNamedItem("max")) != null) {
                            try {
                                max = Integer.parseInt(a.getNodeValue().trim());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (initial != min || min != max) {
                            this.dynamicForm = true;
                        }
                    }
                }
                n2 = n2.getNextSibling();
            }
        }

        public boolean isDynamicForm() {
            return this.dynamicForm;
        }

        public void setDynamicForm(boolean dynamicForm) {
            this.dynamicForm = dynamicForm;
        }
    }
}

