/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.ExceptionConverter;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.pdf.Barcode;
import clover.com.lowagie.text.pdf.BaseFont;
import clover.com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class Barcode39
extends Barcode {
    private static final byte[][] BARS;
    private static final String CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%*";
    private static final String EXTENDED = "%U$A$B$C$D$E$F$G$H$I$J$K$L$M$N$O$P$Q$R$S$T$U$V$W$X$Y$Z%A%B%C%D%E  /A/B/C/D/E/F/G/H/I/J/K/L - ./O 0 1 2 3 4 5 6 7 8 9/Z%F%G%H%I%J%V A B C D E F G H I J K L M N O P Q R S T U V W X Y Z%K%L%M%N%O%W+A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+X+Y+Z%P%Q%R%S%T";

    static {
        byte[][] byArrayArray = new byte[44][];
        byte[] byArray = new byte[9];
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[6] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[9];
        byArray2[0] = 1;
        byArray2[3] = 1;
        byArray2[8] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[9];
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[8] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[9];
        byArray4[0] = 1;
        byArray4[2] = 1;
        byArray4[3] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[9];
        byArray5[3] = 1;
        byArray5[4] = 1;
        byArray5[8] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[9];
        byArray6[0] = 1;
        byArray6[3] = 1;
        byArray6[4] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[9];
        byArray7[2] = 1;
        byArray7[3] = 1;
        byArray7[4] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[9];
        byArray8[3] = 1;
        byArray8[6] = 1;
        byArray8[8] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[9];
        byArray9[0] = 1;
        byArray9[3] = 1;
        byArray9[6] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[9];
        byArray10[2] = 1;
        byArray10[3] = 1;
        byArray10[6] = 1;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[9];
        byArray11[0] = 1;
        byArray11[5] = 1;
        byArray11[8] = 1;
        byArrayArray[10] = byArray11;
        byte[] byArray12 = new byte[9];
        byArray12[2] = 1;
        byArray12[5] = 1;
        byArray12[8] = 1;
        byArrayArray[11] = byArray12;
        byte[] byArray13 = new byte[9];
        byArray13[0] = 1;
        byArray13[2] = 1;
        byArray13[5] = 1;
        byArrayArray[12] = byArray13;
        byte[] byArray14 = new byte[9];
        byArray14[4] = 1;
        byArray14[5] = 1;
        byArray14[8] = 1;
        byArrayArray[13] = byArray14;
        byte[] byArray15 = new byte[9];
        byArray15[0] = 1;
        byArray15[4] = 1;
        byArray15[5] = 1;
        byArrayArray[14] = byArray15;
        byte[] byArray16 = new byte[9];
        byArray16[2] = 1;
        byArray16[4] = 1;
        byArray16[5] = 1;
        byArrayArray[15] = byArray16;
        byte[] byArray17 = new byte[9];
        byArray17[5] = 1;
        byArray17[6] = 1;
        byArray17[8] = 1;
        byArrayArray[16] = byArray17;
        byte[] byArray18 = new byte[9];
        byArray18[0] = 1;
        byArray18[5] = 1;
        byArray18[6] = 1;
        byArrayArray[17] = byArray18;
        byte[] byArray19 = new byte[9];
        byArray19[2] = 1;
        byArray19[5] = 1;
        byArray19[6] = 1;
        byArrayArray[18] = byArray19;
        byte[] byArray20 = new byte[9];
        byArray20[4] = 1;
        byArray20[5] = 1;
        byArray20[6] = 1;
        byArrayArray[19] = byArray20;
        byte[] byArray21 = new byte[9];
        byArray21[0] = 1;
        byArray21[7] = 1;
        byArray21[8] = 1;
        byArrayArray[20] = byArray21;
        byte[] byArray22 = new byte[9];
        byArray22[2] = 1;
        byArray22[7] = 1;
        byArray22[8] = 1;
        byArrayArray[21] = byArray22;
        byte[] byArray23 = new byte[9];
        byArray23[0] = 1;
        byArray23[2] = 1;
        byArray23[7] = 1;
        byArrayArray[22] = byArray23;
        byte[] byArray24 = new byte[9];
        byArray24[4] = 1;
        byArray24[7] = 1;
        byArray24[8] = 1;
        byArrayArray[23] = byArray24;
        byte[] byArray25 = new byte[9];
        byArray25[0] = 1;
        byArray25[4] = 1;
        byArray25[7] = 1;
        byArrayArray[24] = byArray25;
        byte[] byArray26 = new byte[9];
        byArray26[2] = 1;
        byArray26[4] = 1;
        byArray26[7] = 1;
        byArrayArray[25] = byArray26;
        byte[] byArray27 = new byte[9];
        byArray27[6] = 1;
        byArray27[7] = 1;
        byArray27[8] = 1;
        byArrayArray[26] = byArray27;
        byte[] byArray28 = new byte[9];
        byArray28[0] = 1;
        byArray28[6] = 1;
        byArray28[7] = 1;
        byArrayArray[27] = byArray28;
        byte[] byArray29 = new byte[9];
        byArray29[2] = 1;
        byArray29[6] = 1;
        byArray29[7] = 1;
        byArrayArray[28] = byArray29;
        byte[] byArray30 = new byte[9];
        byArray30[4] = 1;
        byArray30[6] = 1;
        byArray30[7] = 1;
        byArrayArray[29] = byArray30;
        byte[] byArray31 = new byte[9];
        byArray31[0] = 1;
        byArray31[1] = 1;
        byArray31[8] = 1;
        byArrayArray[30] = byArray31;
        byte[] byArray32 = new byte[9];
        byArray32[1] = 1;
        byArray32[2] = 1;
        byArray32[8] = 1;
        byArrayArray[31] = byArray32;
        byte[] byArray33 = new byte[9];
        byArray33[0] = 1;
        byArray33[1] = 1;
        byArray33[2] = 1;
        byArrayArray[32] = byArray33;
        byte[] byArray34 = new byte[9];
        byArray34[1] = 1;
        byArray34[4] = 1;
        byArray34[8] = 1;
        byArrayArray[33] = byArray34;
        byte[] byArray35 = new byte[9];
        byArray35[0] = 1;
        byArray35[1] = 1;
        byArray35[4] = 1;
        byArrayArray[34] = byArray35;
        byte[] byArray36 = new byte[9];
        byArray36[1] = 1;
        byArray36[2] = 1;
        byArray36[4] = 1;
        byArrayArray[35] = byArray36;
        byte[] byArray37 = new byte[9];
        byArray37[1] = 1;
        byArray37[6] = 1;
        byArray37[8] = 1;
        byArrayArray[36] = byArray37;
        byte[] byArray38 = new byte[9];
        byArray38[0] = 1;
        byArray38[1] = 1;
        byArray38[6] = 1;
        byArrayArray[37] = byArray38;
        byte[] byArray39 = new byte[9];
        byArray39[1] = 1;
        byArray39[2] = 1;
        byArray39[6] = 1;
        byArrayArray[38] = byArray39;
        byte[] byArray40 = new byte[9];
        byArray40[1] = 1;
        byArray40[3] = 1;
        byArray40[5] = 1;
        byArrayArray[39] = byArray40;
        byte[] byArray41 = new byte[9];
        byArray41[1] = 1;
        byArray41[3] = 1;
        byArray41[7] = 1;
        byArrayArray[40] = byArray41;
        byte[] byArray42 = new byte[9];
        byArray42[1] = 1;
        byArray42[5] = 1;
        byArray42[7] = 1;
        byArrayArray[41] = byArray42;
        byte[] byArray43 = new byte[9];
        byArray43[3] = 1;
        byArray43[5] = 1;
        byArray43[7] = 1;
        byArrayArray[42] = byArray43;
        byte[] byArray44 = new byte[9];
        byArray44[1] = 1;
        byArray44[4] = 1;
        byArray44[6] = 1;
        byArrayArray[43] = byArray44;
        BARS = byArrayArray;
    }

    public Barcode39() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = true;
            this.extended = false;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static byte[] getBarsCode39(String text) {
        text = "*" + text + "*";
        byte[] bars = new byte[text.length() * 10 - 1];
        int k = 0;
        while (k < text.length()) {
            int idx = CHARS.indexOf(text.charAt(k));
            if (idx < 0) {
                throw new IllegalArgumentException("The character '" + text.charAt(k) + "' is illegal in code 39.");
            }
            System.arraycopy(BARS[idx], 0, bars, k * 10, 9);
            ++k;
        }
        return bars;
    }

    public static String getCode39Ex(String text) {
        String out = "";
        int k = 0;
        while (k < text.length()) {
            char c = text.charAt(k);
            if (c > '\u007f') {
                throw new IllegalArgumentException("The character '" + c + "' is illegal in code 39 extended.");
            }
            char c1 = EXTENDED.charAt(c * 2);
            char c2 = EXTENDED.charAt(c * 2 + 1);
            if (c1 != ' ') {
                out = String.valueOf(out) + c1;
            }
            out = String.valueOf(out) + c2;
            ++k;
        }
        return out;
    }

    static char getChecksum(String text) {
        int chk = 0;
        int k = 0;
        while (k < text.length()) {
            int idx = CHARS.indexOf(text.charAt(k));
            if (idx < 0) {
                throw new IllegalArgumentException("The character '" + text.charAt(k) + "' is illegal in code 39.");
            }
            chk += idx;
            ++k;
        }
        return CHARS.charAt(chk % 43);
    }

    public Rectangle getBarcodeSize() {
        String fullCode;
        float fontX = 0.0f;
        float fontY = 0.0f;
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            fullCode = this.code;
            if (this.generateChecksum && this.checksumText) {
                fullCode = String.valueOf(fullCode) + Barcode39.getChecksum(fullCode);
            }
            if (this.startStopText) {
                fullCode = "*" + fullCode + "*";
            }
            fontX = this.font.getWidthPoint(this.altText != null ? this.altText : fullCode, this.size);
        }
        fullCode = this.code;
        if (this.extended) {
            fullCode = Barcode39.getCode39Ex(this.code);
        }
        int len = fullCode.length() + 2;
        if (this.generateChecksum) {
            ++len;
        }
        float fullWidth = (float)len * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(len - 1) * this.x;
        fullWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(fullWidth, fullHeight);
    }

    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        String fullCode = this.code;
        float fontX = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                fullCode = String.valueOf(fullCode) + Barcode39.getChecksum(fullCode);
            }
            if (this.startStopText) {
                fullCode = "*" + fullCode + "*";
            }
            fullCode = this.altText != null ? this.altText : fullCode;
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        String bCode = this.code;
        if (this.extended) {
            bCode = Barcode39.getCode39Ex(this.code);
        }
        if (this.generateChecksum) {
            bCode = String.valueOf(bCode) + Barcode39.getChecksum(bCode);
        }
        int len = bCode.length() + 2;
        float fullWidth = (float)len * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(len - 1) * this.x;
        float barStartX = 0.0f;
        float textStartX = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (fontX > fullWidth) {
                    barStartX = fontX - fullWidth;
                    break;
                }
                textStartX = fullWidth - fontX;
                break;
            }
            default: {
                if (fontX > fullWidth) {
                    barStartX = (fontX - fullWidth) / 2.0f;
                    break;
                }
                textStartX = (fullWidth - fontX) / 2.0f;
            }
        }
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.font.getFontDescriptor(3, this.size);
                barStartY = textStartY + this.baseline;
            }
        }
        byte[] bars = Barcode39.getBarsCode39(bCode);
        boolean print = true;
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        int k = 0;
        while (k < bars.length) {
            float w;
            float f = w = bars[k] == 0 ? this.x : this.x * this.n;
            if (print) {
                cb.rectangle(barStartX, barStartY, w - this.inkSpreading, this.barHeight);
            }
            print = !print;
            barStartX += w;
            ++k;
        }
        cb.fill();
        if (this.font != null) {
            if (textColor != null) {
                cb.setColorFill(textColor);
            }
            cb.beginText();
            cb.setFontAndSize(this.font, this.size);
            cb.setTextMatrix(textStartX, textStartY);
            cb.showText(fullCode);
            cb.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color foreground, Color background) {
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        String bCode = this.code;
        if (this.extended) {
            bCode = Barcode39.getCode39Ex(this.code);
        }
        if (this.generateChecksum) {
            bCode = String.valueOf(bCode) + Barcode39.getChecksum(bCode);
        }
        int len = bCode.length() + 2;
        int nn = (int)this.n;
        int fullWidth = len * (6 + 3 * nn) + (len - 1);
        byte[] bars = Barcode39.getBarsCode39(bCode);
        boolean print = true;
        int ptr = 0;
        int height = (int)this.barHeight;
        int[] pix = new int[fullWidth * height];
        int k = 0;
        while (k < bars.length) {
            int w = bars[k] == 0 ? 1 : nn;
            int c = g;
            if (print) {
                c = f;
            }
            print = !print;
            int j = 0;
            while (j < w) {
                pix[ptr++] = c;
                ++j;
            }
            ++k;
        }
        k = fullWidth;
        while (k < pix.length) {
            System.arraycopy(pix, 0, pix, k, fullWidth);
            k += fullWidth;
        }
        Image img = canvas.createImage(new MemoryImageSource(fullWidth, height, pix, 0, fullWidth));
        return img;
    }
}

