/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class BackwardBranchMarker
extends SimplifiedVisitor
implements InstructionVisitor {
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        this.markBackwardBranch(method, branchInstruction.branchOffset);
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SwitchInstruction switchInstruction) {
        this.markBackwardBranch(method, switchInstruction.defaultOffset);
        for (int i = 0; i < switchInstruction.jumpOffsets.length; ++i) {
            this.markBackwardBranch(method, switchInstruction.jumpOffsets[i]);
        }
    }

    private void markBackwardBranch(Method method, int n) {
        if (n < 0) {
            BackwardBranchMarker.setBranchesBackward(method);
        }
    }

    private static void setBranchesBackward(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (methodOptimizationInfo != null) {
            methodOptimizationInfo.setBranchesBackward();
        }
    }

    public static boolean branchesBackward(Method method) {
        MethodOptimizationInfo methodOptimizationInfo = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return methodOptimizationInfo == null || methodOptimizationInfo.branchesBackward();
    }
}

