/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.superx.util.SqlStringUtils;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;

public class XilParser
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected String xilString;

    public XilParser(String xilString) {
        this.xilString = xilString;
    }

    public XilParser() {
    }

    public void setXilString(String xilString) {
        this.xilString = xilString;
    }

    public int getFixedColumnCount() {
        Integer fixedColumns = new Integer(0);
        try {
            Properties xilProps = new Properties();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.xilString.getBytes());
            xilProps.load(bis);
            String fc = xilProps.getProperty("fixed_columns", "1");
            if (fc != null) {
                fc = fc.trim();
            }
            fixedColumns = new Integer(fc);
        }
        catch (Exception e) {
            System.out.println("Konnte fixedColumns nicht einlesen " + e);
        }
        if (this.xilString.toLowerCase().indexOf("\"ebene\"") > -1 && fixedColumns < 2) {
            fixedColumns = new Integer(2);
        }
        return fixedColumns;
    }

    public boolean hasAggregationHeaders() {
        return this.xilString.indexOf("\u0000") > -1 || this.xilString.indexOf("\\000") > -1;
    }

    public String getHiddenAggregationColumns() {
        String result = null;
        String x = "hiddenaggregationcolumns=\"";
        int pos1 = this.xilString.toLowerCase().indexOf(x);
        if (pos1 > -1) {
            int pos2 = this.xilString.substring(pos1 + x.length()).indexOf(34);
            if (pos2 < 2) {
                throw new IllegalStateException("Endemarkierung von Attribut startcolset nicht gefunden");
            }
            result = this.xilString.substring(pos1 + x.length(), pos1 + x.length() + pos2);
        }
        return result;
    }

    public String getStartColSet() {
        String result = null;
        String x = "startcolset=\"";
        int pos1 = this.xilString.toLowerCase().indexOf(x);
        if (pos1 > -1) {
            int pos2 = this.xilString.substring(pos1 + x.length()).indexOf(34);
            if (pos2 < 2) {
                throw new IllegalStateException("Endemarkierung von Attribut startcolset nicht gefunden");
            }
            result = this.xilString.substring(pos1 + x.length(), pos1 + x.length() + pos2);
        }
        return result;
    }

    public Vector getHeaderVector() {
        return SqlStringUtils.getHeader(this.xilString);
    }

    public Vector getWidths() {
        Vector<String> widths = new Vector<String>();
        int pos = 0;
        int end_pos = 0;
        int offset = 0;
        int len = this.xilString.length();
        String search_str = "width=";
        String width_str = null;
        int search_len = search_str.length();
        while (offset < len && (pos = this.xilString.indexOf(search_str, offset)) != -1 && (end_pos = this.xilString.indexOf("\n", pos + search_len)) != -1) {
            width_str = this.xilString.substring(pos + search_len, end_pos);
            int pos_leer = 0;
            pos_leer = width_str.indexOf(" ");
            if (pos_leer != -1) {
                width_str = width_str.substring(0, pos_leer);
            }
            widths.addElement(width_str.trim());
            offset = pos + search_len + width_str.length() + 1;
        }
        return widths;
    }
}

