/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.coll.NamedObjectSet;
import de.memtext.util.StringUtils;
import de.memtext.util.TransletUtils;
import de.memtext.util.TransletWrapper;
import de.superx.common.DBServletException;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;

public class TransletCache {
    private static NamedObjectSet transletPool = new NamedObjectSet();
    private static HashMap merkmale = new HashMap();

    private TransletCache() {
    }

    public static boolean isFullXMLRequired(String filename) {
        boolean result = false;
        if (merkmale.containsKey(filename) && merkmale.get(filename).equals("fullXML")) {
            result = true;
        }
        return result;
    }

    public static Transformer getTransformer(String mandantenID, String filename) throws TransformerConfigurationException, DBServletException {
        TransletWrapper tr = null;
        String transletname = filename;
        if (mandantenID != null && SxPools.get(mandantenID).hasCustomPDFFile() && TransletCache.isPDF(filename)) {
            transletname = transletname + mandantenID;
        }
        if (transletPool.containsItemWithName(transletname)) {
            tr = (TransletWrapper)transletPool.getByName(transletname);
            if (mandantenID != null) {
                Logger.getLogger("superx_" + mandantenID).log(Level.FINER, "   using prepared translet: " + filename);
            }
        } else {
            try {
                tr = TransletCache.prepareTranslet(filename, mandantenID);
                if (filename.toLowerCase().indexOf("maske") > -1) {
                    URI u = new URI(filename.replace('\\', '/').replace(" ", "%20"));
                    String content = StringUtils.readFile(new File(u));
                    if (content.indexOf("dojo") == -1 || content.indexOf("isFullXMLRequired=true") > -1) {
                        merkmale.put(filename, "fullXML");
                    }
                } else {
                    merkmale.remove(filename);
                }
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
                throw new DBServletException("Konnte XSL-Datei " + filename + " nicht kompilieren evtl. Datei nicht gefunden. DETAILS: Genauere Infos in  tomcat-logs (catalina.out)");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new DBServletException("Konnte XSL-Datei " + filename + " nicht pr\u00fcfen. DETAILS: Genauere Infos in  tomcat-logs (catalina.out)");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new DBServletException("Konnte XSL-Datei " + filename + " nicht pr\u00fcfen. DETAIS: Genauere Infos in  tomcat-logs (catalina.out)");
            }
            transletPool.add(tr);
            if (mandantenID != null) {
                Logger.getLogger("superx_" + mandantenID).log(Level.FINER, "   using freshly compiled translet: " + filename);
            }
        }
        Transformer t = tr.newTransformer();
        t.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        return t;
    }

    private static boolean isPDF(String filename) {
        return filename.toLowerCase().indexOf("_pdf") > -1;
    }

    private static TransletWrapper prepareTranslet(String fileuri, String mandantenID) throws TransformerConfigurationException {
        TransletWrapper tr = null;
        String transletname = fileuri;
        if (TransletCache.isPDF(fileuri) && mandantenID != null && SxPools.get(mandantenID).hasCustomPDFFile()) {
            File fRead = null;
            URI uRead = null;
            File fWrite = null;
            URI uWrite = null;
            try {
                uRead = new URI(fileuri.replace('\\', '/'));
                fRead = new File(uRead);
                String xsl = StringUtils.readFile(fRead);
                if (xsl.indexOf("<!--<xsl:import href=\"../custom/MANDANTENID/custom_pdf.xsl\"/>-->") > -1) {
                    String tmp_xsl = StringUtils.replace(xsl, "<!--<xsl:import href=\"../custom/MANDANTENID/custom_pdf.xsl\"/>-->", "<xsl:import href=\"../" + mandantenID + "/custom/custom_pdf.xsl\"/>");
                    fileuri = fileuri.replace(".xsl", "") + "_" + mandantenID + "_tmp.xsl";
                    uWrite = new URI(fileuri.replace('\\', '/'));
                    fWrite = new File(uWrite);
                    StringUtils.write(fWrite, tmp_xsl);
                    transletname = transletname + mandantenID;
                }
            }
            catch (Exception e) {
                throw new TransformerConfigurationException("Datei uri " + fileuri + " kann nicht gelesen oder verarbeitet werden");
            }
        }
        tr = new TransletWrapper(transletname, TransletUtils.createTemplate(fileuri));
        return tr;
    }

    public static void initStandardTranslets() throws TransformerConfigurationException, DBServletException {
        TransletCache.getTransformer("file:///" + ServletUtils.getPath() + "/menue_html.xsl", "");
        TransletCache.getTransformer("file:///" + ServletUtils.getPath() + "/maske_html.xsl", "");
        TransletCache.getTransformer("file:///" + ServletUtils.getPath() + "/tabelle_html.xsl", "");
    }

    public static void clear() {
        transletPool.clear();
    }
}

