/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.meta.parser;

import de.werum.sis.common.AbstractMessage;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MessagesException;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ParserContextInterface;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import java.io.IOException;
import java.io.Reader;
import java.util.EmptyStackException;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MainParser
extends DefaultHandler
implements SuperParser {
    private Stack path = new Stack();
    private StringBuffer charBuffer = new StringBuffer();
    private ParserContextInterface context = null;
    private SubParser rootParser = null;
    private ResolverInterface resolver = null;
    private MessagesException messagesException = null;

    public void setParserContext(ParserContextInterface context) {
        this.context = context;
    }

    public void setResolver(ResolverInterface resolver) {
        this.resolver = resolver;
    }

    public MetaElementInterface perform(Reader aReader, SubParser parser) throws IOException, SAXException {
        this.rootParser = parser;
        XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        reader.setFeature("http://xml.org/sax/features/namespaces", true);
        reader.parse(new InputSource(aReader));
        if (this.resolver != null) {
            this.resolver.doResolve(this.rootParser.object());
        }
        return this.rootParser.object();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!this.rootParser.isAllowed() || !this.rootParser.canHandleOpenTag(namespaceURI, localName)) {
            throw MetaParseException.unknownTagException(localName);
        }
        this.rootParser.startElement(namespaceURI, localName, qName, atts);
        this.path.push(localName);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!this.rootParser.isAllowed() || !this.rootParser.canHandleClosedTag(namespaceURI, localName)) {
            throw MetaParseException.unknownClosingTagException(localName);
        }
        this.rootParser.endElement(namespaceURI, localName, qName);
        this.path.pop();
        this.charBuffer = new StringBuffer();
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        this.charBuffer.append(characters, start, length);
    }

    public void ignorableWhitespace(char[] characters, int start, int length) throws SAXException {
        this.characters(characters, start, length);
    }

    public StringBuffer charData() {
        return this.charBuffer;
    }

    public void notifyObjectStarted(SubParser aParser) {
    }

    public void notifyObjectAvailable(SubParser aParser) {
    }

    public String parentElement() {
        try {
            return (String)this.path.peek();
        }
        catch (EmptyStackException _) {
            return null;
        }
    }

    public void error(AbstractMessage errorMessage) {
        if (this.messagesException == null) {
            this.messagesException = new MessagesException("Es sind Fehler aufgetreten");
        }
        this.messagesException.addMessage(errorMessage);
    }

    public void checkForErrors() throws MessagesException {
        if (this.messagesException != null) {
            throw this.messagesException;
        }
    }

    public ParserContextInterface getParserKontext() {
        return this.context;
    }

    public String getKontextPath() {
        return "";
    }
}

