/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.item;

import de.werum.sis.mapping.MapMaker;
import de.werum.sis.mapping.item.Assignment;
import de.werum.sis.mapping.item.assignment.AssignmentMN;
import de.werum.sis.mapping.item.assignment.AssignmentStore;
import de.werum.sis.mapping.item.assignment.InvalidAssignmentDataException;
import de.werum.sis.mapping.item.mappingelement.MappingElementLink;
import de.werum.sis.mapping.item.mappingelement.MappingElementLinkImpl;
import de.werum.sis.mapping.item.mappingelement.MappingElementObject;
import de.werum.sis.mapping.item.mappingelement.MappingElementObjectImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class MappingContainer {
    protected SortedMap left_ = null;
    protected SortedMap right_ = null;
    public static final int LEFT = 10;
    public static final int RIGHT = 20;
    protected Assignment assignment_ = null;
    protected MapMaker mapmaker_ = null;
    protected Comparator leftComparator_ = null;
    protected Comparator rightComparator_ = null;

    public MappingContainer() {
        this.left_ = new TreeMap();
        this.right_ = new TreeMap();
        this.assignment_ = new AssignmentMN();
    }

    public MappingContainer(SortedMap left, SortedMap right) {
        this.left_ = new TreeMap(left);
        this.right_ = new TreeMap(right);
        this.assignment_ = new AssignmentMN();
    }

    public MappingContainer(SortedMap left, SortedMap right, AssignmentStore assignment, boolean validateassignment) throws InvalidAssignmentDataException {
        this.left_ = new TreeMap(left);
        this.right_ = new TreeMap(right);
        this.assignment_ = new AssignmentMN(assignment);
        if (validateassignment) {
            this.validate();
        }
    }

    public MappingElementObject putLeft(MappingElementObject item) {
        return this.getLeft().put(item.getKey(), item);
    }

    public MappingElementObject putRight(MappingElementObject item) {
        return this.getRight().put(item.getKey(), item);
    }

    public MappingElementLink putAssignment(MappingElementLink item) {
        return (MappingElementLink)this.getAssignment().put(item.getLeftKey(), item.getRightKey(), item);
    }

    public void setMapMaker(MapMaker mapmaker) {
        this.mapmaker_ = mapmaker;
    }

    public MapMaker getMapMaker() {
        return this.mapmaker_;
    }

    public Comparator getLeftComparator() {
        return this.leftComparator_;
    }

    public void setLeftComparator(Comparator leftComparator) {
        this.leftComparator_ = leftComparator;
    }

    public Comparator getRightComparator() {
        return this.rightComparator_;
    }

    public void setRightComparator(Comparator rightComparator) {
        this.rightComparator_ = rightComparator;
    }

    public Assignment getAssignment() {
        return this.assignment_;
    }

    public List getLeftUnassignedKeys() {
        List assikeys;
        ArrayList allkeys = new ArrayList(this.getLeft().keySet());
        if (allkeys != null && allkeys.size() > 0 && (assikeys = this.getLeftAssignedKeys()) != null && assikeys.size() > 0) {
            allkeys.removeAll(assikeys);
        }
        return allkeys;
    }

    public List getLeftAssignedKeys() {
        return new ArrayList(this.getAssignment().getAllKeysOnLeftSide());
    }

    public List getRightUnassignedKeys() {
        List assikeys;
        ArrayList allkeys = new ArrayList(this.getRight().keySet());
        if (allkeys != null && allkeys.size() > 0 && (assikeys = this.getRightAssignedKeys()) != null && assikeys.size() > 0) {
            allkeys.removeAll(assikeys);
        }
        return allkeys;
    }

    public List getRightAssignedKeys() {
        return new ArrayList(this.getAssignment().getAllKeysOnRightSide());
    }

    public SortedMap getRight() {
        return this.right_;
    }

    public SortedMap getLeft() {
        return this.left_;
    }

    public void validate() throws InvalidAssignmentDataException {
        if (this.getAssignment() != null) {
            String element;
            Iterator iter;
            Set _assignmentkey = this.getAssignment().getAllKeysOnLeftSide();
            if (_assignmentkey != null) {
                iter = _assignmentkey.iterator();
                while (iter.hasNext()) {
                    element = (String)iter.next();
                    if (this.getLeft().containsKey(element)) continue;
                    throw new InvalidAssignmentDataException("Target does not include left assignment key: '" + element + "'");
                }
            }
            if ((_assignmentkey = this.getAssignment().getAllKeysOnRightSide()) != null) {
                iter = _assignmentkey.iterator();
                while (iter.hasNext()) {
                    element = (String)iter.next();
                    if (this.getRight().containsKey(element)) continue;
                    throw new InvalidAssignmentDataException("Source does not include right assignment key: '" + element + "'");
                }
            }
        }
    }

    public void initDemoData() {
        MappingElementObjectImpl my_element = null;
        my_element = new MappingElementObjectImpl("path1");
        my_element.setType(10);
        my_element.setPath("path1");
        my_element.setDisplayName("Pfad 1");
        my_element.setIsStructure(true);
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey1");
        my_element.setType(10);
        my_element.setDisplayName("Erster Name L");
        my_element.setName("leftkey1name");
        my_element.setPath("path1");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey2");
        my_element.setType(10);
        my_element.setDisplayName("Name Zwei L");
        my_element.setName("leftkey2name");
        my_element.setPath("path1");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey3");
        my_element.setType(10);
        my_element.setDisplayName("Dritter Name L");
        my_element.setName("leftkey3name");
        my_element.setPath("path2.path21");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey4");
        my_element.setType(10);
        my_element.setDisplayName("Vierter Name L");
        my_element.setName("leftkey4name");
        my_element.setPath("path2.path22");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl();
        my_element.setType(10);
        my_element.setIsStructure(true);
        my_element.setDisplayName("pfad23");
        my_element.setPath("path2.path23");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey5");
        my_element.setType(10);
        my_element.setDisplayName("F\u00fcnfter Name L");
        my_element.setName("leftkey5name");
        my_element.setPath("path2");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey6");
        my_element.setType(10);
        my_element.setDisplayName("Sechster Name L");
        my_element.setName("leftkey6name");
        my_element.setPath("path3");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey7");
        my_element.setType(10);
        my_element.setDisplayName("Siebter Name L");
        my_element.setName("leftkey7name");
        my_element.setPath("path3");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey8");
        my_element.setType(10);
        my_element.setDisplayName("Achter Name L");
        my_element.setName("leftkey8name");
        my_element.setPath("path4");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("leftkey9");
        my_element.setType(10);
        my_element.setDisplayName("Neunter Name L");
        my_element.setName("leftkey9name");
        my_element.setPath("path4");
        this.putLeft(my_element);
        my_element = new MappingElementObjectImpl("rightkey1");
        my_element.setType(20);
        my_element.setDisplayName("Erster Name R");
        my_element.setName("rightkey1name");
        my_element.setPath("");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey2");
        my_element.setType(20);
        my_element.setDisplayName("Zweiter Name R");
        my_element.setName("rightkey2name");
        my_element.setPath("");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey3");
        my_element.setType(20);
        my_element.setDisplayName("Dritter Name R");
        my_element.setName("rightkey3name");
        my_element.setPath("");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey4");
        my_element.setType(20);
        my_element.setDisplayName("Vierter Name R");
        my_element.setName("rightkey4name");
        my_element.setPath("");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey5");
        my_element.setType(20);
        my_element.setDisplayName("F\u00fcnfter Name R");
        my_element.setName("rightkey5name");
        my_element.setPath("");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey6");
        my_element.setType(20);
        my_element.setDisplayName("Sechster Name R");
        my_element.setName("rightkey6name");
        my_element.setPath("right");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey7");
        my_element.setType(20);
        my_element.setDisplayName("Siebter Name R");
        my_element.setName("rightkey7name");
        my_element.setPath("");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey8");
        my_element.setType(20);
        my_element.setDisplayName("Achter Name R");
        my_element.setName("rightkey8name");
        my_element.setPath("path1");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey9");
        my_element.setType(20);
        my_element.setDisplayName("Neunter Name R");
        my_element.setName("rightkey9name");
        my_element.setPath("path1");
        this.putRight(my_element);
        my_element = new MappingElementObjectImpl("rightkey10");
        my_element.setType(20);
        my_element.setDisplayName("Zehnter Name R");
        my_element.setName("rightkey10name");
        my_element.setPath("path1");
        this.putRight(my_element);
        this.putAssignment(new MappingElementLinkImpl("leftkey3", "rightkey5"));
        this.putAssignment(new MappingElementLinkImpl("leftkey1", "rightkey3"));
        this.putAssignment(new MappingElementLinkImpl("leftkey8", "rightkey4"));
        this.putAssignment(new MappingElementLinkImpl("leftkey5", "rightkey1"));
        this.putAssignment(new MappingElementLinkImpl("leftkey4", "rightkey6"));
        this.putAssignment(new MappingElementLinkImpl("leftkey9", "rightkey2"));
        this.putAssignment(new MappingElementLinkImpl("leftkey6", "rightkey3"));
    }
}

