/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv.filter;

import de.werum.sis.csv.filter.FilterFieldSetInstance;
import de.werum.sis.csv.filter.FilterStructure;
import java.util.LinkedList;
import java.util.List;

public class FilterFieldSet
extends FilterStructure {
    private String nameImport = null;
    private boolean additive = false;
    private List<FilterFieldSetInstance> instances = new LinkedList<FilterFieldSetInstance>();

    public String getNameImport() {
        return this.nameImport;
    }

    public void setNameImport(String nameImport) {
        this.nameImport = nameImport;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public List<FilterFieldSetInstance> getInstances() {
        return this.instances;
    }

    public FilterFieldSetInstance addInstance() {
        FilterFieldSetInstance result = new FilterFieldSetInstance(this);
        this.copyInto(result);
        this.getInstances().add(result);
        result.setName("Satzart " + this.getInstances().size());
        return result;
    }

    public FilterFieldSet getCopy() {
        FilterFieldSet copy = new FilterFieldSet();
        this.copyInto(copy);
        copy.setNameImport(this.getNameImport());
        copy.setAdditive(this.isAdditive());
        for (FilterFieldSetInstance instance : this.instances) {
            copy.getInstances().add(instance.getCopy(copy));
        }
        return copy;
    }

    public void computePositions(int type, boolean modifyOnly) {
        this.computePositions(1, type, modifyOnly);
        for (FilterFieldSetInstance instance : this.instances) {
            instance.computePositions(1, type, modifyOnly);
        }
    }

    @Override
    public void updateFrom(FilterStructure structure) {
        super.updateFrom(structure);
        this.getInstances().clear();
        FilterFieldSet fieldSet = (FilterFieldSet)structure;
        for (FilterFieldSetInstance anotherInstance : fieldSet.getInstances()) {
            FilterFieldSetInstance instance = this.addInstance();
            instance.setName(anotherInstance.getName());
            instance.updateFrom(anotherInstance);
        }
    }

    @Override
    public void sortByPosition() {
        super.sortByPosition();
        for (FilterFieldSetInstance instance : this.instances) {
            instance.sortByPosition();
        }
    }
}

