/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.MaskenParserFaktory;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SimpleTypeParser
extends SubParser {
    private MetaSDFMerkmal merkmal = null;

    public SimpleTypeParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    public void setMerkmal(MetaSDFMerkmal merkmal) {
        this.merkmal = merkmal;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.merkmal != null) {
            if ("string".equalsIgnoreCase(localName)) {
                String maxLength;
                this.merkmal.setTyp((short)1);
                String length = atts.getValue("length");
                if (length != null) {
                    try {
                        this.merkmal.setLaenge(Long.parseLong(length));
                        this.merkmal.setMinimaleLaenge(this.merkmal.getLaenge());
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Laenge des Merkmals ungueltig!");
                    }
                }
                String minLength = atts.getValue("minimum-length");
                if (minLength != null) {
                    try {
                        this.merkmal.setMinimaleLaenge(Long.parseLong(minLength));
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Minimale Laenge des Merkmals ungueltig!");
                    }
                }
                if ((maxLength = atts.getValue("maximum-length")) != null) {
                    try {
                        this.merkmal.setLaenge(Long.parseLong(maxLength));
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Maximale Laenge des Merkmals ungueltig!");
                    }
                }
            } else if ("normalisedString".equalsIgnoreCase(localName)) {
                String maxLength;
                this.merkmal.setTyp((short)2);
                String length = atts.getValue("length");
                if (length != null) {
                    try {
                        this.merkmal.setLaenge(Long.parseLong(length));
                        this.merkmal.setMinimaleLaenge(this.merkmal.getLaenge());
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Laenge des Merkmals ungueltig!");
                    }
                }
                String minLength = atts.getValue("minimum-length");
                if (minLength != null) {
                    try {
                        this.merkmal.setMinimaleLaenge(Long.parseLong(minLength));
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Minimale Laenge des Merkmals ungueltig!");
                    }
                }
                if ((maxLength = atts.getValue("maximum-length")) != null) {
                    try {
                        this.merkmal.setLaenge(Long.parseLong(maxLength));
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Maximale Laenge des Merkmals ungueltig!");
                    }
                }
            } else if ("token".equalsIgnoreCase(localName)) {
                String maxLength;
                this.merkmal.setTyp((short)3);
                String length = atts.getValue("length");
                if (length != null) {
                    try {
                        this.merkmal.setLaenge(Long.parseLong(length));
                        this.merkmal.setMinimaleLaenge(this.merkmal.getLaenge());
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Laenge des Merkmals ungueltig!");
                    }
                }
                String minLength = atts.getValue("minimum-length");
                if (minLength != null) {
                    try {
                        this.merkmal.setMinimaleLaenge(Long.parseLong(minLength));
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Minimale Laenge des Merkmals ungueltig!");
                    }
                }
                if ((maxLength = atts.getValue("maximum-length")) != null) {
                    try {
                        this.merkmal.setLaenge(Long.parseLong(maxLength));
                    }
                    catch (Exception e) {
                        throw new MetaParseException("Maximale Laenge des Merkmals ungueltig!");
                    }
                }
            } else if ("decimal".equalsIgnoreCase(localName)) {
                boolean fractionsSignificant;
                boolean integersSignificant;
                int fractionDigits;
                int totalDigits;
                this.merkmal.setTyp((short)4);
                String totalDigitString = atts.getValue("total-digits");
                if (totalDigitString == null) {
                    throw new MetaParseException("Anzahl Vorkommastellen nicht angegeben!");
                }
                try {
                    totalDigits = Integer.parseInt(totalDigitString);
                }
                catch (NumberFormatException e) {
                    throw new MetaParseException("Anzahl Vorkommastellen ungueltig!");
                }
                String fractionDigitsString = atts.getValue("fraction-digits");
                if (fractionDigitsString != null) {
                    try {
                        fractionDigits = Integer.parseInt(fractionDigitsString);
                    }
                    catch (NumberFormatException e) {
                        throw new MetaParseException("Anzahl Nachkommastellen ungueltig!");
                    }
                } else {
                    fractionDigits = 0;
                }
                String significantDigits = atts.getValue("significant-digits");
                if (significantDigits != null) {
                    if ("all".equals(significantDigits)) {
                        integersSignificant = true;
                        fractionsSignificant = true;
                    } else if ("integers".equals(significantDigits)) {
                        integersSignificant = true;
                        fractionsSignificant = false;
                    } else if ("fractions".equals(significantDigits)) {
                        integersSignificant = false;
                        fractionsSignificant = true;
                    } else if ("none".equals(significantDigits)) {
                        integersSignificant = false;
                        fractionsSignificant = false;
                    } else {
                        integersSignificant = false;
                        fractionsSignificant = false;
                    }
                } else {
                    integersSignificant = false;
                    fractionsSignificant = false;
                }
                StringBuffer mask = new StringBuffer();
                mask.append('-');
                if (integersSignificant) {
                    mask.append('0');
                }
                int i = 0;
                while (i < totalDigits - fractionDigits) {
                    mask.append('#');
                    ++i;
                }
                if (fractionDigits > 0) {
                    mask.append('.');
                    i = 0;
                    while (i < fractionDigits) {
                        mask.append('#');
                        ++i;
                    }
                    if (fractionsSignificant) {
                        mask.append('0');
                    }
                }
                this.merkmal.setLaenge(totalDigits);
                this.merkmal.setMaske(mask.toString());
            } else if ("integer".equalsIgnoreCase(localName)) {
                int totalDigits;
                this.merkmal.setTyp((short)5);
                String totalDigitsString = atts.getValue("total-digits");
                if (totalDigitsString == null) {
                    throw new MetaParseException("Laenge des Merkmals nicht angegeben!");
                }
                try {
                    totalDigits = Integer.parseInt(totalDigitsString);
                }
                catch (Exception e) {
                    throw new MetaParseException("Laenge des Merkmals ungueltig!");
                }
                this.merkmal.setLaenge(totalDigits);
                String significantDigits = atts.getValue("significant-digits");
                if (significantDigits != null && "all".equals(significantDigits)) {
                    StringBuffer mask = new StringBuffer();
                    mask.append('-');
                    mask.append('0');
                    int i = 0;
                    while (i < totalDigits) {
                        mask.append('#');
                        ++i;
                    }
                    this.merkmal.setMaske(mask.toString());
                }
            } else if ("nonNegativeInteger".equalsIgnoreCase(localName)) {
                int totalDigits;
                this.merkmal.setTyp((short)6);
                String totalDigitsString = atts.getValue("total-digits");
                if (totalDigitsString == null) {
                    throw new MetaParseException("Laenge des Merkmals nicht angegeben!");
                }
                try {
                    totalDigits = Integer.parseInt(totalDigitsString);
                }
                catch (Exception e) {
                    throw new MetaParseException("Laenge des Merkmals ungueltig!");
                }
                this.merkmal.setLaenge(totalDigits);
                String significantDigits = atts.getValue("significant-digits");
                if (significantDigits != null && "all".equals(significantDigits)) {
                    StringBuffer mask = new StringBuffer();
                    mask.append('-');
                    mask.append('0');
                    int i = 0;
                    while (i < totalDigits) {
                        mask.append('#');
                        ++i;
                    }
                    this.merkmal.setMaske(mask.toString());
                }
            } else if ("positiveInteger".equalsIgnoreCase(localName)) {
                int totalDigits;
                this.merkmal.setTyp((short)7);
                String totalDigitsString = atts.getValue("total-digits");
                if (totalDigitsString == null) {
                    throw new MetaParseException("Laenge des Merkmals nicht angegeben!");
                }
                try {
                    totalDigits = Integer.parseInt(totalDigitsString);
                }
                catch (Exception e) {
                    throw new MetaParseException("Laenge des Merkmals ungueltig!");
                }
                this.merkmal.setLaenge(totalDigits);
                String significantDigits = atts.getValue("significant-digits");
                if (significantDigits != null && "all".equals(significantDigits)) {
                    StringBuffer mask = new StringBuffer();
                    mask.append('-');
                    mask.append('0');
                    int i = 0;
                    while (i < totalDigits) {
                        mask.append('#');
                        ++i;
                    }
                    this.merkmal.setMaske(mask.toString());
                }
            } else if ("formattedDate".equalsIgnoreCase(localName)) {
                this.merkmal.setTyp((short)8);
                String dateFormat = atts.getValue("date-format");
                if (dateFormat == null) {
                    throw new MetaParseException("Datumsformat nicht definiert!");
                }
                StringBuffer convertedDateFormat = new StringBuffer();
                char[] chars = dateFormat.toCharArray();
                boolean withinEscapedSequence = false;
                int i = 0;
                while (i < chars.length) {
                    if (!withinEscapedSequence) {
                        switch (chars[i]) {
                            case 'y': {
                                convertedDateFormat.append('J');
                                break;
                            }
                            case 'd': {
                                convertedDateFormat.append('T');
                                break;
                            }
                            case 'H': {
                                convertedDateFormat.append('S');
                                break;
                            }
                            case '\'': {
                                withinEscapedSequence = true;
                                break;
                            }
                            default: {
                                convertedDateFormat.append(chars[i]);
                                break;
                            }
                        }
                    } else {
                        switch (chars[i]) {
                            case '\'': {
                                if (i + 1 < chars.length && chars[i + 1] == '\'') {
                                    convertedDateFormat.append("'");
                                    ++i;
                                    break;
                                }
                                withinEscapedSequence = false;
                                break;
                            }
                            case ' ': {
                                convertedDateFormat.append("@");
                                break;
                            }
                            case 'J': 
                            case 'M': 
                            case 'S': 
                            case 'T': 
                            case 'm': 
                            case 's': {
                                convertedDateFormat.append("\\");
                            }
                            default: {
                                convertedDateFormat.append(chars[i]);
                            }
                        }
                    }
                    ++i;
                }
                this.merkmal.setMaske(convertedDateFormat.toString());
                try {
                    MaskenParserInterface maskenParser = MaskenParserFaktory.getInstance().getMaskenParserFuerTyp(2);
                    AbstractMaske maske = maskenParser.parse(this.merkmal.getMaske());
                    this.merkmal.setLaenge(maske.gibMaxLaenge());
                }
                catch (Exception e) {
                    throw new MetaParseException("Fehler beim Interpretieren des Datumsformats", e);
                }
            }
        }
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("simpleType".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("simpleType".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.enable();
        } else if ("string".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("normalisedString".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("token".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("decimal".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("integer".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("nonNegativeInteger".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("positiveInteger".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("formattedDate".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else {
            throw MetaParseException.unknownTagException((String)localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("simpleType".equalsIgnoreCase(localName)) {
            this.disable();
        } else if (!("string".equalsIgnoreCase(localName) || "normalisedString".equalsIgnoreCase(localName) || "token".equalsIgnoreCase(localName) || "decimal".equalsIgnoreCase(localName) || "integer".equalsIgnoreCase(localName) || "nonNegativeInteger".equalsIgnoreCase(localName) || "positiveInteger".equalsIgnoreCase(localName) || "formattedDate".equalsIgnoreCase(localName))) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return null;
    }
}

