/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.parser;

import de.statspez.sdf.generator.parser.SDFParserContext;
import de.werum.sis.meta.MetaElementInterface;
import de.werum.sis.meta.parser.MetaParseException;
import de.werum.sis.meta.parser.ResolverInterface;
import de.werum.sis.meta.parser.SubParser;
import de.werum.sis.meta.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CreationTimeParser
extends SubParser {
    private int hours = 0;
    private int minutes = 0;
    private int seconds = 0;
    private int fractionSeconds = 0;
    private boolean readingTimeZoneOffset = false;

    public CreationTimeParser(SuperParser superParser, ResolverInterface resolver) {
        super(superParser, resolver);
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getFractionSeconds() {
        return this.fractionSeconds;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("hours".equalsIgnoreCase(localName)) {
            if (this.readingTimeZoneOffset) return handled;
            try {
                if (chars.length() <= 0) return handled;
                this.hours = Integer.parseInt(chars);
                if (this.hours < 0) throw new MetaParseException("Fehlerhafte Stundenangabe!");
                if (this.hours <= 23) return handled;
                throw new MetaParseException("Fehlerhafte Stundenangabe!");
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Stundenangabe!", (Exception)e);
            }
        }
        if ("minutes".equalsIgnoreCase(localName)) {
            if (this.readingTimeZoneOffset) return handled;
            try {
                if (chars.length() <= 0) return handled;
                this.minutes = Integer.parseInt(chars);
                if (this.minutes < 0) throw new MetaParseException("Fehlerhafte Minutenangabe!");
                if (this.minutes <= 59) return handled;
                throw new MetaParseException("Fehlerhafte Minutenangabe!");
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Minutenangabe!", (Exception)e);
            }
        }
        if ("seconds".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.seconds = Integer.parseInt(chars);
                if (this.seconds < 0) throw new MetaParseException("Fehlerhafte Sekundenangabe!");
                if (this.seconds <= 59) return handled;
                throw new MetaParseException("Fehlerhafte Sekundenangabe!");
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Sekundenangabe!", (Exception)e);
            }
        }
        if ("fractionSeconds".equalsIgnoreCase(localName)) {
            try {
                if (chars.length() <= 0) return handled;
                this.fractionSeconds = Integer.parseInt(chars);
                if (this.fractionSeconds < 0) throw new MetaParseException("Fehlerhafte Millisekundenangabe!");
                if (this.fractionSeconds <= 999) return handled;
                throw new MetaParseException("Fehlerhafte Millisekundenangabe!");
            }
            catch (NumberFormatException e) {
                throw new MetaParseException("Fehlerhafte Millisekundenangabe!", (Exception)e);
            }
        }
        if ("timeZoneName".equalsIgnoreCase(localName)) return handled;
        return false;
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("creationTime".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("creationTime".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.hours = 0;
            this.minutes = 0;
            this.seconds = 0;
            this.fractionSeconds = 0;
            this.readingTimeZoneOffset = false;
            this.enable();
        } else if ("hours".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("minutes".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("seconds".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("fractionSeconds".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("timeZoneName".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
        } else if ("timeZoneOffset".equalsIgnoreCase(localName)) {
            ((SDFParserContext)this.getParserKontext()).checkNamespaceSSP(namespaceURI);
            this.readingTimeZoneOffset = true;
        } else {
            throw MetaParseException.unknownTagException((String)localName);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("creationTime".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if ("timeZoneOffset".equalsIgnoreCase(localName)) {
            this.readingTimeZoneOffset = false;
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw MetaParseException.unknownClosingTagException((String)localName);
        }
    }

    public MetaElementInterface object() {
        return null;
    }
}

