/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.sdf.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.GenericFieldDescriptor;
import de.statspez.pleditor.generator.runtime.Classification;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.FeldDeskriptor;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.sdf.generator.meta.SDFStructureTraverser;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegung;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.werum.sis.meta.ElementVisitorInterface;
import de.werum.sis.meta.MetaElementInterface;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public class SDFFieldDescriptorFactory
extends SDFStructureTraverser
implements FieldDescriptorFactory {
    private static final Hashtable MAPPINGS = new Hashtable();
    private HashMap typeDescriptors = new HashMap();
    private MetaSDFAusgabegruppe currentOutputGroup = null;
    private Stack currentStructure = null;
    private Stack currentIndices = null;
    private int currentStructureLevel = 0;
    private Stack hierarchy = new Stack();
    private Vector classificationGroups = new Vector();

    public SDFFieldDescriptorFactory(MetaErhebungsbeschreibung sdf) {
        sdf.accept(this);
    }

    public Iterator getClassificationGroups() {
        return this.classificationGroups.iterator();
    }

    public void setCurrentOutputGroup(MetaSDFAusgabegruppe currentOutputGroup) {
        this.currentOutputGroup = currentOutputGroup;
    }

    public void setCurrentStructure(Stack currentStructure, Stack currentIndices) {
        this.currentStructure = currentStructure;
        this.currentIndices = currentIndices;
        this.currentStructureLevel = this.currentStructure != null ? this.currentStructure.size() - 1 : 0;
    }

    public void setCurrentStructureLevel(int currentStructureLevel) {
        this.currentStructureLevel = currentStructureLevel;
    }

    public FeldDeskriptorImpl getFieldDescriptor(String nameWithstructure) throws NoSuchFieldException {
        FeldDeskriptorImpl fieldDescriptor = null;
        if (nameWithstructure != null && nameWithstructure.length() > 0) {
            String[] paths = nameWithstructure.split("\\.");
            int i = 0;
            while (i < paths.length) {
                int[] indices;
                String name;
                int indexOf = paths[i].indexOf(35);
                if (indexOf > 0) {
                    name = paths[i].substring(0, indexOf);
                    indices = this.parseIndices(paths[i].substring(indexOf + 1));
                } else {
                    name = paths[i];
                    indices = null;
                }
                fieldDescriptor = this.getFieldDecriptor(name, indices, fieldDescriptor);
                ++i;
            }
        }
        return fieldDescriptor;
    }

    private String getHierarchy() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.hierarchy.size()) {
            buffer.append(this.hierarchy.get(i));
            buffer.append(".");
            ++i;
        }
        return buffer.toString();
    }

    private FeldDeskriptor getParentFieldDescriptor() {
        FeldDeskriptor parent;
        if (this.hierarchy.isEmpty()) {
            parent = null;
        } else {
            StringBuffer buffer = new StringBuffer();
            if (this.currentOutputGroup != null && 1 == this.currentOutputGroup.getAttributDaten()) {
                buffer.append(this.currentOutputGroup.getName());
                buffer.append(":");
            }
            int i = 0;
            while (i < this.hierarchy.size()) {
                buffer.append(this.hierarchy.get(i));
                if (i < this.hierarchy.size() - 1) {
                    buffer.append(".");
                }
                ++i;
            }
            parent = (FeldDeskriptor)this.typeDescriptors.get(buffer.toString());
        }
        return parent;
    }

    private int[] parseIndices(String indicesAsString) {
        String[] indices = indicesAsString.split("#");
        int[] indicesAsInt = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            indicesAsInt[i] = Integer.parseInt(indices[i]);
            ++i;
        }
        return indicesAsInt;
    }

    private boolean isFeatureGroupContext() {
        return this.currentStructure != null && !this.currentStructure.isEmpty();
    }

    private FeldDeskriptor getTypeDescriptor(String name, String structure) throws NoSuchFieldException {
        FeldDeskriptor typeDescriptor;
        String key = structure != null && structure.length() > 0 ? String.valueOf(structure) + name : name;
        if (this.typeDescriptors.containsKey(key)) {
            typeDescriptor = (FeldDeskriptor)this.typeDescriptors.get(key);
        } else if (!name.equals(key) && !this.isFeatureGroupContext() && this.typeDescriptors.containsKey(name)) {
            typeDescriptor = (FeldDeskriptor)this.typeDescriptors.get(name);
        } else {
            throw new NoSuchFieldException(name);
        }
        return typeDescriptor;
    }

    @Override
    public void visitErhebungsbeschreibung(MetaErhebungsbeschreibung erhebungsbeschreibung) {
        super.visitErhebungsbeschreibung(erhebungsbeschreibung);
        Iterator iter = erhebungsbeschreibung.getAuspraegungsgruppen();
        while (iter != null && iter.hasNext()) {
            ((MetaElementInterface)iter.next()).accept((ElementVisitorInterface)this);
        }
    }

    @Override
    public void visitSDFAusgabegruppe(MetaSDFAusgabegruppe ausgabegruppe) {
        this.setCurrentOutputGroup(ausgabegruppe);
        super.visitSDFAusgabegruppe(ausgabegruppe);
        this.setCurrentOutputGroup(null);
    }

    @Override
    public void visitSDFMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe) {
        this.typeDescriptors.put(String.valueOf(this.currentOutputGroup.getName()) + ":" + this.getHierarchy() + merkmalsgruppe.getName(), new FeldDeskriptor(MAPPINGS, merkmalsgruppe.getName(), this.getParentFieldDescriptor(), 7));
        this.hierarchy.push(merkmalsgruppe.getName());
        super.visitSDFMerkmalsgruppe(merkmalsgruppe);
        this.hierarchy.pop();
    }

    private static FeldDeskriptor createTypeDescriptor(MetaSDFMerkmal merkmal, FeldDeskriptor parent) {
        int type;
        switch (merkmal.getTyp()) {
            case 1: 
            case 2: 
            case 3: {
                type = 3;
                break;
            }
            case 4: {
                type = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                type = 0;
                break;
            }
            case 8: {
                type = 5;
                break;
            }
            default: {
                type = 7;
            }
        }
        return new FeldDeskriptor(MAPPINGS, merkmal.getName(), parent, type, merkmal.getMaske());
    }

    public static FeldDeskriptorImpl createSimpleFieldDescriptor(MetaSDFMerkmal merkmal) {
        return SDFFieldDescriptorFactory.createFieldDescriptor(SDFFieldDescriptorFactory.createTypeDescriptor(merkmal, null), null, null);
    }

    public static FeldDeskriptorImpl createFieldDescriptor(FeldDeskriptor typeDescriptor, int[] indices, FeldDeskriptorImpl parent) {
        return new GenericFieldDescriptor(typeDescriptor, indices, parent);
    }

    public static ClassificationGroup createClassificationGroup(MetaAuspraegungsgruppe auspraegungsgruppe) {
        ClassificationGroupConverter converter = new ClassificationGroupConverter();
        ClassificationGroup classificationGroup = converter.convert(auspraegungsgruppe);
        return classificationGroup;
    }

    @Override
    public void visitSDFMerkmal(MetaSDFMerkmal merkmal) {
        if (1 == this.currentOutputGroup.getAttributDaten()) {
            this.typeDescriptors.put(String.valueOf(this.currentOutputGroup.getName()) + ":" + this.getHierarchy() + merkmal.getName(), SDFFieldDescriptorFactory.createTypeDescriptor(merkmal, this.getParentFieldDescriptor()));
        } else {
            this.typeDescriptors.put(merkmal.getName(), SDFFieldDescriptorFactory.createTypeDescriptor(merkmal, null));
        }
    }

    @Override
    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe auspraegungsgruppe) {
        ClassificationGroupConverter converter = new ClassificationGroupConverter();
        ClassificationGroup classificationGroup = converter.convert(auspraegungsgruppe);
        this.classificationGroups.add(classificationGroup);
    }

    public FeldDeskriptorImpl getFieldDecriptor(String name, int[] indices, FeldDeskriptorImpl parent) throws NoSuchFieldException {
        FeldDeskriptorImpl fieldDescriptor = null;
        StringBuffer typeKey = new StringBuffer();
        if (this.currentOutputGroup != null && 1 == this.currentOutputGroup.getAttributDaten()) {
            typeKey.append(this.currentOutputGroup.getName());
            typeKey.append(':');
            if (this.isFeatureGroupContext() && parent == null) {
                int i = 0;
                while (i <= this.currentStructureLevel) {
                    String groupName = ((MetaSDFMerkmalsgruppe)this.currentStructure.get(i)).getName();
                    int index = (Integer)this.currentIndices.get(i);
                    FeldDeskriptor typeDeskriptor = this.getTypeDescriptor(groupName, typeKey.toString());
                    fieldDescriptor = new GenericFieldDescriptor(typeDeskriptor, new int[]{index}, fieldDescriptor);
                    typeKey.append(groupName);
                    typeKey.append('.');
                    ++i;
                }
            }
            if (parent != null) {
                Stack<FeldDeskriptorImpl> parents = new Stack<FeldDeskriptorImpl>();
                while (parent.getVorgaenger() != null) {
                    parents.push(parent);
                    parent = (FeldDeskriptorImpl)parent.getVorgaenger();
                }
                parent.setVorgaenger(fieldDescriptor);
                while (!parents.isEmpty()) {
                    typeKey.append(parent.getFeldNameTB());
                    typeKey.append('.');
                    parent = (FeldDeskriptorImpl)parents.pop();
                }
                typeKey.append(parent.getFeldNameTB());
                typeKey.append('.');
                fieldDescriptor = parent;
            }
        }
        return SDFFieldDescriptorFactory.createFieldDescriptor(this.getTypeDescriptor(name, typeKey.toString()), indices, fieldDescriptor);
    }

    private static class ClassificationGroupConverter
    extends SDFStructureTraverser {
        private ClassificationGroup currentClassificationGroup;

        public ClassificationGroup convert(MetaAuspraegungsgruppe auspraegungsgruppe) {
            this.currentClassificationGroup = null;
            auspraegungsgruppe.accept(this);
            return this.currentClassificationGroup;
        }

        @Override
        public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe auspraegungsgruppe) {
            this.currentClassificationGroup = new ClassificationGroup(ValueFactory.instance().valueFor(auspraegungsgruppe.getName()), ValueFactory.instance().valueFor(auspraegungsgruppe.getName()));
            super.visitAuspraegungsgruppe(auspraegungsgruppe);
        }

        @Override
        public void visitAuspraegung(MetaAuspraegung auspraegung) {
            MetaPLAuspraegung classification = (MetaPLAuspraegung)auspraegung;
            if (classification.sizeOfAuspraegungen() > 0) {
                ClassificationGroup parentGroup = this.currentClassificationGroup;
                this.currentClassificationGroup = new ClassificationGroup(ValueFactory.instance().valueFor(classification.getKode()), ValueFactory.instance().valueFor(classification.getName()));
                super.visitAuspraegung(auspraegung);
                parentGroup.addClassfication((Classification)this.currentClassificationGroup);
                this.currentClassificationGroup = parentGroup;
            } else {
                this.currentClassificationGroup.addClassfication(new Classification(ValueFactory.instance().valueFor(classification.getKode()), ValueFactory.instance().valueFor(classification.getName())));
            }
        }
    }
}

